/*  
 * Copyright 2005 unitarou <boss@unitarou.org>. 
 * All rights reserved.
 * 
 * This program and the accompanying materials are made available under the terms of 
 * the Common Public License v1.0 which accompanies this distribution, 
 * and is available at http://opensource.org/licenses/cpl.php
 * 
 * Contributors:
 *     unitarou - initial API and implementation
 */
package org.unitarou.yukinoshita.view.jface.ann;

import org.eclipse.swt.SWT;
import org.eclipse.swt.custom.StackLayout;
import org.eclipse.swt.events.FocusAdapter;
import org.eclipse.swt.events.FocusEvent;
import org.eclipse.swt.layout.FillLayout;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Combo;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Label;

import org.unitarou.ml.MessageResource;
import org.unitarou.sgf.SgfId;
import org.unitarou.sgf.type.SgfSize;


/**
 * @author unitarou &lt;boss@unitarou.org&gt; 
 */
class SizeEditor extends Editor {
    /** ucv*/
    static private final MessageResource CLB_SIZE_HEIGHT
			= new MessageResource(RootAnnotationPanel.class, "clbSizeHeight"); //$NON-NLS-1$
    
    /** uv*/
    static private final MessageResource CLB_SIZE_WIDTH
			= new MessageResource(RootAnnotationPanel.class, "clbSizeWidth"); //$NON-NLS-1$

    private StackLayout stackLayout_;
    private Composite advancedPanel_;
    private Composite normalPanel_;
    private Combo cbSize_;
    private Combo cbHorizontalSize_;
    private Combo cbVerticalSize_;
    private boolean enableAdvanced_;
    private final ComboFocusLost comboFocusLost_;

    /**
     * 
     */
    SizeEditor() {
        super();
        enableAdvanced_ = false;
        comboFocusLost_ = new ComboFocusLost();
    }
    
    /**
     * @param enable4Advanced
     */
    void setAdvanced(boolean enable4Advanced) {
        enableAdvanced_ = enable4Advanced;
        stackLayout_.topControl = enableAdvanced_ ? advancedPanel_ : normalPanel_;
        stackLayout_.topControl.getParent().layout();
    }

    /* (non-Javadoc)
     * @see org.unitarou.swt.WidgetContainer#createContents(org.eclipse.swt.widgets.Composite)
     */
    public Control createContents(Composite parent) {
    	Composite frame = new Composite(parent, SWT.NONE);
        stackLayout_ = new StackLayout();
        frame.setLayout(stackLayout_);
        normalPanel_ = createNormalEditor(frame);
        advancedPanel_ = createAdvancedEditor(frame);
        stackLayout_.topControl = normalPanel_;
        return frame;
    }
    
    /**
     * @param parent
     */
    private Composite createNormalEditor(Composite parent) {
        Composite composite = new Composite(parent, SWT.NONE);
        composite.setLayout(new FillLayout());
        cbSize_ = new Combo(composite, SWT.READ_ONLY | SWT.DROP_DOWN);
        for (int i = 1; i <= SgfSize.MAX.height(); ++i) {
            String size = String.valueOf(i);
            cbSize_.add(size + 'x' + size);
        }
        cbSize_.select(SgfSize.DEFAULT.height() - 1);
        cbSize_.addFocusListener(comboFocusLost_);
        cbSize_.setData(SgfId.SIZE);
        return composite;
    }

    private Composite createAdvancedEditor(Composite parent) {
        Composite composite = new Composite(parent, SWT.NONE);
        GridLayout gridLayout = new GridLayout(4, false);
        gridLayout.marginWidth = 0;
        gridLayout.marginHeight = 0;
        composite.setLayout(gridLayout);
		Label label = new Label(composite, SWT.NONE | SWT.RIGHT);
        label.setText(CLB_SIZE_HEIGHT.get());
        label.setLayoutData(new GridData(GridData.HORIZONTAL_ALIGN_END));
        
        cbVerticalSize_ = createSizeCombo(composite);
        cbVerticalSize_.addFocusListener(comboFocusLost_);

		label = new Label(composite, SWT.NONE | SWT.RIGHT);
        label.setText(CLB_SIZE_WIDTH.get());
        label.setLayoutData(new GridData(GridData.HORIZONTAL_ALIGN_END));
        cbHorizontalSize_ = createSizeCombo(composite);
        cbHorizontalSize_.addFocusListener(comboFocusLost_);
        return composite;
    }
    
	/* (non-Javadoc)
	 * @see org.unitarou.swt.WidgetContainer#dispose()
	 */
	public void dispose() {
		//Ȃ
	}

    
    private Combo createSizeCombo(Composite parent) {
        Combo combo = new Combo(parent, SWT.READ_ONLY | SWT.DROP_DOWN);
        combo.setLayoutData(new GridData(GridData.FILL_HORIZONTAL));
        for (int i = 1; i <= SgfSize.MAX.height(); ++i) {
            combo.add(String.valueOf(i));
        }
        combo.select(SgfSize.DEFAULT.height() - 1);
        combo.setData(SgfId.SIZE);
        return combo;
    }

    /**
     * @param sgfSize
     */
    void select(SgfSize sgfSize) {
        cbHorizontalSize_.select(sgfSize.width() - 1);
        cbVerticalSize_.select(sgfSize.height() - 1);
        cbSize_.select(sgfSize.height() - 1);
    }

    /**
     * @param isEditMode
     */
    void setEditable(boolean isEditMode) {
        cbSize_.setEnabled(isEditMode);
        cbHorizontalSize_.setEnabled(isEditMode);
        cbVerticalSize_.setEnabled(isEditMode);
    }

    /* (non-Javadoc)
     * @see org.unitarou.yukinoshita.view.jface.ann.Editor#getDatum()
     */
    @Override 
    String getDatum() {
        if (enableAdvanced_) {
            int height = cbVerticalSize_.getSelectionIndex() + 1;
            int width = cbHorizontalSize_.getSelectionIndex() + 1;
            return SgfSize.create(width, height).getString();
        } 
        int size = cbSize_.getSelectionIndex() + 1;
        return SgfSize.create(size, size).getString();
    }
    
    private class ComboFocusLost extends FocusAdapter {
        @Override
		public void focusLost(FocusEvent e) {
            fireModifyText(e.widget);
        }
    }
}