/*  
 * Copyright 2005 unitarou <boss@unitarou.org>. 
 * All rights reserved.
 * 
 * This program and the accompanying materials are made available under the terms of 
 * the Common Public License v1.0 which accompanies this distribution, 
 * and is available at http://opensource.org/licenses/cpl.php
 * 
 * Contributors:
 *     unitarou - initial API and implementation
 */
package org.unitarou.yukinoshita.view.jface.board;

import java.util.Collections;
import java.util.Set;

import org.unitarou.sgf.type.SgfPoint;
import org.unitarou.yukinoshita.model.NodeView;

/**
 * Ղ̂PubN`悷yC^[C^[tFCXłB<br>
 * g`悷ubN̈ꗗԂ܂B
 * 
 * @author unitarou &lt;boss@unitarou.org&gt; 
 */
public interface BlockPainter {
	/**
	 * {@link #getDurablePaintings(NodeView, NodeView)}
	 * {@link #getTransientPaintings(NodeView)}Ȃǂ
	 * ֋XIɎgvfłB
	 */
	Set<SgfPoint> EMPTY_SET = Collections.<SgfPoint>emptySet();
	
	/**
	 * ̃yC^[`ΏۂƂuIȁvubN̏WԂ܂B<br>
	 * ŁuIȁvƂ͌΂ՁADDAԍȂǁAU`悳
	 * ƕ\Âvf܂B̂悤ȗvf\Ȃꍇ
	 * ̏WԂĂB<br>
	 * ̃C^[tFCXNXnow̓̕Kvȏ
	 * ێĂKv܂B
	 * āAɌĂяoꂽƂnowƔr߂lƂĕԂA
	 * ̍ۂ̕KvȏXV܂B
	 * 
	 * @param now
	 * @return
	 * @throws org.unitarou.lang.NullArgumentException now<code>null</code>̏ꍇB
	 */
	Set<SgfPoint> getDurablePaintings(NodeView now);
	
	
	/**
	 * ̃yC^[`ΏۂƂuꎞIȁvubN̏WԂ܂B<br>
	 * ŁuꎞIȁvƂ́A~̋LA_Aω}pLȂǁAǖʂ
	 * `悳ꂽA̋ǖʂł͒ɏvf܂B̂悤
	 * vf\Ȃꍇ͋̏WԂĂB<br>
	 * 
	 * @param nodeView
	 * @return
	 */
	Set<SgfPoint> getTransientPaintings(NodeView nodeView);
}
