/*  
 * Copyright 2005 unitarou <boss@unitarou.org>. 
 * All rights reserved.
 * 
 * This program and the accompanying materials are made available under the terms of 
 * the Common Public License v1.0 which accompanies this distribution, 
 * and is available at http://opensource.org/licenses/cpl.php
 * 
 * Contributors:
 *     unitarou - initial API and implementation
 */
package org.unitarou.yukinoshita.view.jface.board;


import java.util.EnumSet;

import org.eclipse.swt.graphics.Rectangle;

import org.unitarou.sgf.type.SgfColor;
import org.unitarou.sgf.type.SgfPoint;
import org.unitarou.sgf.util.SgfPointType;
import org.unitarou.util.ArgumentChecker;

/**
 * Ղ̊eW̑(ʒuƐ΂̗L)ێlNXłB
 * 
 * @author unitarou &lt;boss@unitarou.org&gt;
 */
public class BlockStatus {

	/**
	 * ̃ubŇՂ̍WłB
	 */
    private SgfPoint point_;
    
    /**
     * ̃ubŇՂ̏Ԃێ܂B
     */
    private EnumSet<SgfPointType> types_;
    
    /**
     * ̃ubN̕`̈ł̍WłB
     */
    private Rectangle rectangle_; 
    
    /**
     * 
     */
    public BlockStatus() {
        super();
        point_ = null;
        types_ = EnumSet.of(SgfPointType.EMPTY);
        rectangle_ = new Rectangle(0,0,1,1);
    }

    /**
	 * @return Returns the rectangle.
	 */
	public Rectangle getRectangle() {
		return rectangle_;
	}

	/**
	 * @param rectangle The rectangle to set.
	 */
	public void setRectangle(Rectangle rectangle) {
		rectangle_ = rectangle;
	}

	/**
     * @param point
     * @throws org.unitarou.lang.NullArgumentException nul̏ꍇB
     */
    public void setPoint(SgfPoint point) {
        ArgumentChecker.throwIfNull(point);

        point_ = point;
    }

    /**
     * @param types
     * @throws org.unitarou.lang.NullArgumentException nul̏ꍇB
     * @throws IllegalArgumentException typesɎ݂̂ȂꍇF
     *          {@link SgfPointType#EMPTY}A{@link SgfPointType#WHITE}A{@link SgfPointType#BLACK}
     */
    public void setPointTypes(EnumSet<SgfPointType> types) {
        ArgumentChecker.throwIfNull(types);

        if (types.contains(SgfPointType.EMPTY) 
                || types.contains(SgfPointType.WHITE)
                || types.contains(SgfPointType.BLACK)) {
            types_ = types.clone();
        } else {
            throw new IllegalArgumentException("Argument types must contain EMPTY, WHITE, or BLACK."); //$NON-NLS-1$
        }
    }
    /**
     * @param color
     * @throws org.unitarou.lang.NullArgumentException nul̏ꍇB
     */
    public void addStone(SgfColor color) {
        ArgumentChecker.throwIfNull(color);

        types_.add(SgfColor.BLACK.equals(color) ? SgfPointType.BLACK : SgfPointType.WHITE);
        types_.remove(SgfPointType.EMPTY);
    }

    /**
     * @return
     */
    public SgfPoint getPoint() {
        return point_;
    }

    /**
     * L̉ꂩ͕K܂ނƂۏ؂܂B
     * {@link SgfPointType#EMPTY}
     * {@link SgfPointType#WHITE}
     * {@link SgfPointType#BLACK}
     */
    public EnumSet<SgfPointType> getPointTypes() {
        return types_;
    }
}
