/*  
 * Copyright 2005 unitarou <boss@unitarou.org>. 
 * All rights reserved.
 * 
 * This program and the accompanying materials are made available under the terms of 
 * the Common Public License v1.0 which accompanies this distribution, 
 * and is available at http://opensource.org/licenses/cpl.php
 * 
 * Contributors:
 *     unitarou - initial API and implementation
 */
package org.unitarou.yukinoshita.view.jface.board;

import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Set;

import org.eclipse.jface.util.Geometry;
import org.eclipse.swt.SWT;
import org.eclipse.swt.custom.ScrolledComposite;
import org.eclipse.swt.events.ControlAdapter;
import org.eclipse.swt.events.ControlEvent;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.layout.FillLayout;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;

import org.unitarou.sgf.Collection;
import org.unitarou.sgf.RootGameTree;
import org.unitarou.swt.WidgetContainer;
import org.unitarou.util.ArgumentChecker;

/**
 * {@link Collection}̒g^Cɕ\plłB
 * 
 * @author unitarou &lt;boss@unitarou.org&gt; 
 */
public class CollectionsPanel<T extends IgoOutlinePanel> implements WidgetContainer {

	private final IgoOutlinePanelFactory<T> factory_;
	
	private ScrolledComposite scrolledComposite_;
	private Composite frame_;
	private GridLayout gridLayout_;
	private List<T> list_;
	
	public CollectionsPanel(IgoOutlinePanelFactory<T> factory) {
		this(factory, 4);//TODO }WbNio[
	}
	/**
	 * 
	 */
	public CollectionsPanel(IgoOutlinePanelFactory<T> factory, int col) {
		super();
		ArgumentChecker.throwIfNull(factory);
		if (col <= 0) {
			throw new IllegalArgumentException("Bad size of column: " + col); //$NON-NLS-1$
		}
		factory_ = factory;
		scrolledComposite_ = null;
		frame_ = null;
		gridLayout_ = new GridLayout(col, false);
		list_ = new ArrayList<T>();
	}


	/* (non-Javadoc)
	 * @see org.unitarou.swt.WidgetContainer#createContents(org.eclipse.swt.widgets.Composite)
	 */
	public Control createContents(Composite parent) {
		ArgumentChecker.throwIfNull(parent);
        Composite group = new Composite(parent, SWT.NONE);
        group.setLayout(new FillLayout());

        scrolledComposite_ = new ScrolledComposite(group, SWT.V_SCROLL);
        scrolledComposite_.setLayout(new FillLayout());
        scrolledComposite_.setExpandHorizontal(true);
        scrolledComposite_.setExpandVertical(false);
        scrolledComposite_.addControlListener(new ControlAdapter() {
			@Override
			public void controlResized(ControlEvent e) {
				resized();
			}
        });
        
        frame_ = new Composite(scrolledComposite_, SWT.NONE);
		// ̒iKł͕\Collection̐sȂ̂ŉȂB
		scrolledComposite_.setContent(frame_);
        return group;
	}
	
	/**
	 * ̃plTCYꂽƂɌĂяoA
	 * eՂ̃TCYvZăTCYs܂B
	 */
	private void resized() {
		Point point = Geometry.getSize(scrolledComposite_.getClientArea());
		int width = (point.x / gridLayout_.numColumns) 
				- (gridLayout_.horizontalSpacing * 2 + frame_.getBorderWidth());
		point.x = width;
		point.y = width;
		for (IgoOutlinePanel igoOutlinePanel : list_) {
			igoOutlinePanel.setBoardSize(point);
		}
		frame_.pack();
	}

	/* (non-Javadoc)
	 * @see org.unitarou.swt.WidgetContainer#dispose()
	 */
	public void dispose() {
		for (IgoOutlinePanel igoOutlinePanel : list_) {
			igoOutlinePanel.dispose();
		}
	}
	
	
	/**
	 * collection̔z̒gSĕ\܂B
	 * @param collections
	 */
	public void set(Collection[] collections) {
		ArgumentChecker.throwIfNull((Object)collections);
		frame_.dispose();
		for (IgoOutlinePanel igoOutlinePanel : list_) {
			igoOutlinePanel.dispose();
		}
		list_.clear();
        frame_ = new Composite(scrolledComposite_, SWT.NONE);
		frame_.setLayout(gridLayout_);
		
		int size = 0;
		for (Collection collection : collections) {
			size += collection.size();
		}
		//TODO FileOutlinePanelƓł悤ɁA
		// ʈȏRGTꍇ̓_CAOŃLZł悤ɂB
		for (Collection collection : collections) {
			for (int j = 0 ; j < collection.size(); ++j) {
				T igoOutlinePanel = factory_.create();
				Control control = igoOutlinePanel.createContents(frame_);
				GridData gridData = new GridData(SWT.CENTER, SWT.CENTER, false, false);
				control.setLayoutData(gridData);
				igoOutlinePanel.setRootGameTree(collection.get(j));
				list_.add(igoOutlinePanel);
			}
		}
		resized();
		scrolledComposite_.setContent(frame_);
		scrolledComposite_.setMinSize(frame_.getSize());
	}
	
	/**
	 * ݕ\ĂSpl̔zԂ܂B
	 * @return
	 */
	public T[] getPanels(T[] ts) {
		return list_.toArray(ts);
	}
	
	
	/**
	 * ̃pl̍ŏʂ{@link Composite}Ԃ܂B
	 * @return
	 */
	protected Composite getFrame() {
		return frame_;
	}
	

	/**
	 * w肳ꂽrootGameTreenCCg\܂B
	 * @param rootGameTree
	 */
	protected void setFocus(RootGameTree rootGameTree) {
		for (IgoOutlinePanel igoOutlinePanel : list_) {
			igoOutlinePanel.setFocus(
					rootGameTree.equals(igoOutlinePanel.getRootGameTree()));
		}
	}

	/**
	 * w肳ꂽcollectionnCCg\܂B
	 * @param collection
	 */
	protected void setFocus(Collection collection) {
		ArgumentChecker.throwIfNull(collection);
		
		Set<RootGameTree> set = new HashSet<RootGameTree>();
		for (int i = 0; i < collection.size(); ++i) {
			set.add(collection.get(i));
		}
		
		Point ul = frame_.getSize();
		Point br = new Point(0,0);
		for (IgoOutlinePanel igoOutlinePanel : list_) {
			boolean focused = set.contains(igoOutlinePanel.getRootGameTree()); 
			igoOutlinePanel.setFocus(focused);
			if (!focused) {
				continue;
			}
			
			// tH[JXĂ`߂Ă
			Control control = igoOutlinePanel.getControl();
			Point pul = control.getLocation();
			Point pbr = Geometry.add(pul, control.getSize());
			ul = Geometry.min(ul, pul);
			br = Geometry.max(br, pbr);
		}
		
		// 
		Point sp  = scrolledComposite_.getOrigin();
		Point size = Geometry.getSize(scrolledComposite_.getClientArea());
		if (ul.y < sp.y) {
			scrolledComposite_.setOrigin(ul);
		} else if ((sp.y + size.y) < br.y) {
			Point np = Geometry.subtract(br, size);
			scrolledComposite_.setOrigin(np);
		}
	}
}
