/*  
 * Copyright 2005 unitarou <boss@unitarou.org>. 
 * All rights reserved.
 * 
 * This program and the accompanying materials are made available under the terms of 
 * the Common Public License v1.0 which accompanies this distribution, 
 * and is available at http://opensource.org/licenses/cpl.php
 * 
 * Contributors:
 *     unitarou - initial API and implementation
 */
package org.unitarou.yukinoshita.view.jface.board;

import org.eclipse.swt.SWT;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Label;

import org.unitarou.sgf.PropertyType;
import org.unitarou.sgf.RootGameTree;
import org.unitarou.sgf.type.GameType;
import org.unitarou.sgf.util.provider.crdlp.CoordinatesLabelProvider;
import org.unitarou.sgf.util.provider.crdlp.NoCoordinatesProvider;
import org.unitarou.swt.WidgetContainer;
import org.unitarou.util.ArgumentChecker;
import org.unitarou.yukinoshita.Yukinoshita;
import org.unitarou.yukinoshita.context.CurrentContext;
import org.unitarou.yukinoshita.model.EditableNodeList;
import org.unitarou.yukinoshita.model.NodeEntity;
import org.unitarou.yukinoshita.view.provider.blklp.BlockLabelProvider;
import org.unitarou.yukinoshita.view.provider.blklp.NoBlockLabelProvider;
import org.unitarou.yukinoshita.view.provider.rgtlp.RootGameTreeLabelProvider;
import org.unitarou.yukinoshita.view.provider.vlp.NoVariationProvider;
import org.unitarou.yukinoshita.view.provider.vlp.VariationLabelProvider;

/**
 * {@link org.unitarou.yukinoshita.view.jface.board.IgoBoardPanel}
 * ɑ΂Ame[VȂAEgCp̃plłB<br>
 * 
 * @author unitarou &lt;boss@unitarou.org&gt; 
 */
public class IgoOutlinePanel implements WidgetContainer {
	
	/**
	 * {@link IgoOutlinePanel}Ԃt@Ng[łB
	 */
	static private class FactoryImpl implements IgoOutlinePanelFactory<IgoOutlinePanel> {

		/* (non-Javadoc)
		 * @see org.unitarou.yukinoshita.view.jface.board.IgoOutlinePanelFactory#create()
		 */
		public IgoOutlinePanel create() {
			return new IgoOutlinePanel();
		}
	}
	
	/**
	 * {@link IgoOutlinePanel}쐬t@Ng[Ԃ܂B
	 * @return
	 */
	static public IgoOutlinePanelFactory<IgoOutlinePanel> factory() {
		return new FactoryImpl();
	}
	
	
	/**
	 * Ame[Vzuꏊw肷񋓌^łB
	 */
	public enum Alignment {
		/** 㕔ɃAme[Vzu܂B*/
		TOP, 
		/** ɃAme[Vzu܂B*/
		BOTTOM, 
		/** ɃAme[Vzu܂B*/
		LEFT, 
		/** EɃAme[Vzu܂B*/
		RIGHT
	}
	
	/**
	 * \pReLXgłB
	 */
	static private Object scopeKey_s_ = new Object();
	
	/**
	 * NXŎg܂킷xvoC_[łB
	 */
	static private BlockLabelProvider blockLabelProvider_s_ = new NoBlockLabelProvider();

	/**
	 * NXŎg܂킷xvoC_[łB
	 */
	static private CoordinatesLabelProvider coordinatesLabelProvider_s_ = new NoCoordinatesProvider();
	
	/**
	 * NXŎg܂킷xvoC_[łB
	 */
	static private VariationLabelProvider variationLabelProvider_s_ = new NoVariationProvider();


	/**
	 * ̃pl̍ŏʂ̃t[łB
	 */
	private Composite frame_;
	
	private final Alignment alignment_;
	private Label annotationLabel_;
	private final IgoBoardPanel igoBoardPanel_;
	
	/** Ֆʂ\EBWbgłB */
	private Control boardControl_;
	
	/**
	 * ̃pl`悷ՑS̃sNZTCYێ܂B
	 */
	private Point boardSize_;

	/** 
	 * ۂɕ`ΏۂƂȂ{@link RootGameTree}łB
	 */
	private RootGameTree rootGameTree_;
	
	/**
	 * ǖʂ`ł悤{@link EditableNodeList}ō쐬Ď܂B 
	 */
	private EditableNodeList editableNodeList_;
	
	/**
	 * {@link #setFocus(boolean)}̒lێA
	 * {@link #isFocused()}ŕԂlłB
	 */
	private boolean isFocused_;
	
	/**
	 * Ame[VɔzuRXgN^łB
	 */
	public IgoOutlinePanel() {
		this(Alignment.BOTTOM);
	}

	/**
	 * ̃NX̃vCRXgN^łB
	 * 
	 * @param alignment Ame[Vzuꏊ
	 * @throws org.unitarou.lang.NullArgumentException null̏ꍇ
	 */
	public IgoOutlinePanel(Alignment alignment) {
		super();
		ArgumentChecker.throwIfNull(alignment);
		alignment_ = alignment;
		igoBoardPanel_ = new IgoGraphicalBoardPanel();
		boardSize_ = new Point(150, 150); //TODO }WbNio[
		isFocused_ = false;
	}

	/* (non-Javadoc)
	 * @see org.unitarou.swt.WidgetContainer#createContents(org.eclipse.swt.widgets.Composite)
	 */
	public Control createContents(Composite parent) {
		ArgumentChecker.throwIfNull(parent);
		
		frame_ = new Composite(parent, SWT.NONE);
		switch (alignment_) {
		case TOP:
			frame_.setLayout(new GridLayout(1, true));
			annotationLabel_ = new Label(frame_, SWT.WRAP);
			annotationLabel_.setLayoutData(new GridData(SWT.CENTER, SWT.BOTTOM, true, true));
			boardControl_ = igoBoardPanel_.createContents(frame_);
			break;
			
		case BOTTOM:
			frame_.setLayout(new GridLayout(1, true));
			boardControl_ = igoBoardPanel_.createContents(frame_);
			annotationLabel_ = new Label(frame_, SWT.WRAP | SWT.CENTER);
			annotationLabel_.setLayoutData(new GridData(SWT.CENTER, SWT.TOP, true, true));
			break;
			
		case LEFT:
			frame_.setLayout(new GridLayout(1, false));
			boardControl_ = igoBoardPanel_.createContents(frame_);
			annotationLabel_ = new Label(frame_, SWT.WRAP);
			annotationLabel_.setLayoutData(new GridData(SWT.RIGHT, SWT.TOP, true, true));
			break;

		case RIGHT:
			frame_.setLayout(new GridLayout(1, false));
			annotationLabel_ = new Label(frame_, SWT.WRAP);
			annotationLabel_.setLayoutData(new GridData(SWT.LEFT, SWT.TOP, true, true));
			boardControl_ = igoBoardPanel_.createContents(frame_);
			igoBoardPanel_.createContents(frame_);
			break;

		default:
			assert false : "Unknown alignment type :" + alignment_; //$NON-NLS-1$
		}
		GridData gridData = new GridData(SWT.CENTER, SWT.FILL, true, true);
		gridData.widthHint = boardSize_.x;
		gridData.heightHint = boardSize_.y;
		boardControl_.setLayoutData(gridData);
		return frame_;
	}
	
	/**
	 * ̃pl̍ŏʂ̃Rg[Ԃ܂B
	 * @return
	 */
	public Control getControl() {
		return frame_;
	}
	
	/**
	 * Ղ`悳Rg[Ԃ܂B
	 * @return
	 */
	public Control getBoardControl() {
		return boardControl_;
	}

	/* (non-Javadoc)
	 * @see org.unitarou.swt.WidgetContainer#dispose()
	 */
	public void dispose() {
		// do nothing
	}

	/**
	 * ̃plŕ`悳{@link RootGameTree}ݒ肵܂B
	 * 
	 * @param rootGameTree `ΏۂƂȂRootGameTreeB
	 * @throws org.unitarou.lang.NullArgumentException null̏ꍇ
	 */
	public void setRootGameTree(RootGameTree rootGameTree) {
		ArgumentChecker.throwIfNull(rootGameTree);
		if (rootGameTree_ == rootGameTree) {
			return;
		}
		
		rootGameTree_ = rootGameTree;
		
		CurrentContext context = Yukinoshita.context().getCurrent(scopeKey_s_);
		context.setProvider(BlockLabelProvider.class, blockLabelProvider_s_);
		context.setProvider(CoordinatesLabelProvider.class, coordinatesLabelProvider_s_);
		context.setProvider(VariationLabelProvider.class, variationLabelProvider_s_);
		igoBoardPanel_.setContext(context);
		
		editableNodeList_ = new EditableNodeList(rootGameTree_);
		
		// `
		annotationLabel_.setText(
				RootGameTreeLabelProvider.CONTEXT.defaultProvider().getLabel(rootGameTree_));
			
		if (!rootGameTree.getGameType().equals(GameType.PROBLEM)) {
			igoBoardPanel_.update(editableNodeList_.getLastNodeView());
			return;
		}
		for (int i = 0; i < editableNodeList_.size(); ++i) {
			NodeEntity entity = editableNodeList_.get(i);
			if (entity.getNode().contains(PropertyType.MOVE)) {
				i = (i != 0) ? i - 1 : i;
				igoBoardPanel_.update(editableNodeList_.getNodeView(i));
				return;
			}
		}
		if (0 != editableNodeList_.size()) {
			igoBoardPanel_.update(editableNodeList_.getNodeView(editableNodeList_.size() - 1));
		}
	}

	/**
	 * ̃pl\Ղ̃TCYύX܂B
	 * 
	 * @param boardSize
	 * @throws NullPointerException null̏ꍇ
	 */
	public void setBoardSize(Point boardSize) {
		ArgumentChecker.throwIfNull(boardSize);
		
		boardSize_ = boardSize;
		GridData gridData;
		gridData = (GridData)frame_.getLayoutData();
		gridData.widthHint = boardSize_.x;
		
		gridData = (GridData)boardControl_.getLayoutData();
		gridData.widthHint = boardSize_.x - frame_.getBorderWidth() * 2;
		gridData.heightHint = boardSize_.y - frame_.getBorderWidth() * 2;

		gridData  = (GridData)annotationLabel_.getLayoutData();
		gridData.widthHint = boardSize_.x - frame_.getBorderWidth() * 2;
	}

	/**
	 * ݂{@link RootGameTree}Ԃ܂B
	 * {@link #setRootGameTree(RootGameTree)}Őݒ肵ĂȂꍇnullԂ܂B
	 * @return
	 */
	public RootGameTree getRootGameTree() {
		return rootGameTree_;
	}

	/**
	 * @return
	 */
	public boolean isFocused() {
		return isFocused_;
	}

	/**
	 * ̃plݑIĂ邱Ƃ\s܂B
	 */
	public void setFocus(boolean focused) {
		isFocused_ = focused;
		Display display = frame_.getDisplay();
		frame_.setBackground(
				display.getSystemColor(
						focused ? SWT.COLOR_LIST_SELECTION : SWT.COLOR_WIDGET_BACKGROUND));
		annotationLabel_.setBackground(
				display.getSystemColor(
						focused ? SWT.COLOR_LIST_SELECTION : SWT.COLOR_WIDGET_BACKGROUND));
		annotationLabel_.setForeground(
				display.getSystemColor(
						focused ? SWT.COLOR_LIST_SELECTION_TEXT : SWT.COLOR_WIDGET_FOREGROUND));
	}

}
