/* IgoTextBoardPanel.java
 * 
 * Copyright 2003-2005 unitarou <boss@unitarou.org>. 
 * All rights reserved.
 * 
 * This program and the accompanying materials are made available under the terms of 
 * the Common Public License v1.0 which accompanies this distribution, 
 * and is available at http://opensource.org/licenses/cpl.php
 * 
 * Contributors:
 *     unitarou - initial API and implementation
 */
package org.unitarou.yukinoshita.view.jface.board;

import java.util.Iterator;
import java.util.Map;
import java.util.SortedMap;

import org.eclipse.swt.SWT;
import org.eclipse.swt.graphics.Font;
import org.eclipse.swt.graphics.FontData;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.widgets.Canvas;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Label;

import org.unitarou.lang.NullArgumentException;
import org.unitarou.lang.Strings;
import org.unitarou.sgf.Property;
import org.unitarou.sgf.type.SgfColor;
import org.unitarou.sgf.type.SgfPoint;
import org.unitarou.sgf.type.SgfSize;
import org.unitarou.sgf.util.SgfPointType;
import org.unitarou.sgf.util.Stone;
import org.unitarou.yukinoshita.context.CurrentContext;
import org.unitarou.yukinoshita.model.NodeView;
import org.unitarou.yukinoshita.model.board.IgoBoard;
import org.unitarou.yukinoshita.model.board.IgoBoardView;
import org.unitarou.yukinoshita.model.board.TextViewer;

/**
 * Ձi܂ލWƃAQn}jeLXg`ŕ\NXłB
 * <b>݃eiX~Ă̂Őɓ삵܂B</b>
 * 
 * @author UNITAROU &lt;boss@unitarou.org&gt;
 */
public class IgoTextBoardPanel implements IgoBoardPanel {
//	static private final Messages messages_ = Messages.getInstance(GoTextBoardPanel.class.getPackage());
	
	// modelCX^X
	private final IgoBoard igoBoard_;
	
	// widgetCX^X
	private final Composite parent_; 
	private final Label control_;

	/**
	 * 
	 */
	public IgoTextBoardPanel(Composite parent) {
		super();
		igoBoard_ = new IgoBoard(SgfSize.DEFAULT);

		parent_ = parent;
		// Ղ̍\
		control_ = new Label(parent_, SWT.SINGLE | SWT.BORDER);
		FontData fd = new FontData("lr SVbN", 20, SWT.NORMAL);
		Font font = new Font(parent_.getDisplay(), fd);
		control_.setFont(font);
		draw();
	}
	
	private int boardLength() {
	    return igoBoard_.size().height() * (igoBoard_.size().width() + 1);
	}
	
	public void update(NodeView nodeView) {
		if (nodeView == null) {
			throw new NullArgumentException();
		}
		IgoBoardView newPosition = nodeView.getIgoBoard();
		if (!igoBoard_.size().equals(newPosition.size())) {
			igoBoard_.setSize(newPosition.size());
		}
		updateModel(newPosition);
		draw();
	}
	
	private void updateModel(IgoBoardView newPosition) {
		SortedMap diff = newPosition.diff(igoBoard_);
		for (Iterator ip = diff.entrySet().iterator();
			 ip.hasNext(); ) {
			Map.Entry entry = (Map.Entry)ip.next();
			SgfPoint point = (SgfPoint)entry.getKey();
			SgfColor color = (SgfColor)entry.getValue();

			// ΂ꍇA̕ω̉\̂ŁA
			// UK΂B
			igoBoard_.removeStone(point);
			if (color != null) {
				igoBoard_.setStone(new Stone(color, point, null));
			}
		}
		igoBoard_.setCaptured(newPosition.getCaptured());
	}

	private void draw() {
		StringBuilder text = new StringBuilder(boardLength());
		TextViewer viewer = new TextViewer();
		String [] boardLine = viewer.write(igoBoard_);
		for (int i = 0 ; i < boardLine.length; ++i) {
			text.append(boardLine[i]);
			text.append(Strings.LINE_SEPARATOR);
		}
		text.append(viewer.getCharacter(SgfPointType.BLACK));
		text.append(igoBoard_.getCaptured(SgfColor.BLACK).size());
		text.append(" "); //$NON-NLS-1$
		text.append(viewer.getCharacter(SgfPointType.WHITE));
		text.append(igoBoard_.getCaptured(SgfColor.WHITE).size());
		
		control_.setText(text.toString());
	}

    /* (non-Javadoc)
     * @see org.unitarou.yukinoshita.view.swt.NodeViewer#setEditMode(boolean)
     */
    public void setEditMode(boolean isEditMode) {
        // TODO BҏWƉ{ł̓}EXCxgȂǂ̏Ⴄ͂B
    }

    /* (non-Javadoc)
     * @see org.unitarou.swt.WidgetContainer#createContents(org.eclipse.swt.widgets.Composite)
     */
    public Control createContents(Composite parent) {
        // TODO Auto-generated method stub
        return null;
    }

    /* (non-Javadoc)
     * @see org.unitarou.swt.WidgetContainer#dispose()
     */
    public void dispose() {
        // TODO Auto-generated method stub
        
    }

    /* (non-Javadoc)
     * @see org.unitarou.yukinoshita.view.jface.board.IgoBoardPanel#getCanvas()
     */
    public Canvas getCanvas() {
        // TODO Auto-generated method stub
        return null;
    }


    /* (non-Javadoc)
     * @see org.unitarou.lang.Adaptable#getAdapter(java.lang.Class)
     */
    public Object getAdapter(Class adapter) {
        // TODO Auto-generated method stub
        return null;
    }

    /* (non-Javadoc)
     * @see org.unitarou.yukinoshita.view.jface.board.IgoBoardPanel#getBlockStatus(org.eclipse.swt.graphics.Point)
     */
    public BlockStatus getBlockStatus(Point canvasPoint) {
        // TODO Auto-generated method stub
        return null;
    }

    /* (non-Javadoc)
     * @see org.unitarou.yukinoshita.view.jface.board.IgoBoardPanel#getNodeView()
     */
    public NodeView getNodeView() {
        // TODO Auto-generated method stub
        return null;
    }

    /* (non-Javadoc)
     * @see org.unitarou.yukinoshita.view.jface.board.IgoBoardPanel#setTransient(org.unitarou.sgf.Property[])
     */
    public void paintInTransient(Property property) {
        // TODO Auto-generated method stub
        
    }

	/* (non-Javadoc)
	 * @see org.unitarou.yukinoshita.view.jface.board.IgoBoardPanel#setContext(org.unitarou.yukinoshita.CurrentContext)
	 */
	public void setContext(CurrentContext context) {
		// TODO Auto-generated method stub
		
	}
}
