/*  
 * Copyright 2004, 2005 unitarou <boss@unitarou.org>. 
 * All rights reserved.
 * 
 * This program and the accompanying materials are made available under the terms of 
 * the Common Public License v1.0 which accompanies this distribution, 
 * and is available at http://opensource.org/licenses/cpl.php
 * 
 * Contributors:
 *     unitarou - initial API and implementation
 */
package org.unitarou.yukinoshita.view.jface.board;



import org.eclipse.swt.graphics.GC;
import org.eclipse.swt.graphics.Rectangle;

import org.unitarou.sgf.SgfId;
import org.unitarou.sgf.type.Label;

/**
 * L֌WSʂ`悷C^[tFCXłB
 * 
 * PubNɎ܂L(~ADIM)ɂĂ
 * {@link #paintMarker(GC, Rectangle, SgfId)}p܂B
 * 
 * ARLN̂悤ɕ̃ubNɌׂ`ɂĂ
 * {@link #paintLine(GC, Rectangle, Rectangle, SgfId, boolean)}p܂B
 * 
 * LB̕`{@link #paintLine(GC, Rectangle, Rectangle, SgfId, boolean)}p܂B
 * 
 * @author unitarou &lt;boss@unitarou.org&gt;
 */
public interface MarkPainter extends BlockPainter {

    /**
     * NX{@link #paintMarker(GC, Rectangle, SgfId)}
     * `\ȃvpeB̌^Ԃ܂B
     * Ԃ^{@link SgfId#valueType()}
     * {@link org.unitarou.sgf.ValueType#POINT}łKv܂B
     * ȊǑ^ԂꍇA͕ۏ؂܂B
     * NXłnullԂĂ͂Ȃ܂B
     * nullԂꍇ͕̓ۏ؂܂B
     */
    SgfId[] markerScope();
    
    /**
     * gcɑ΂blockArea͈͓̔
     * sgfTypeŎw肳ꂽACe`悵܂B
     * NXŎ󂯎sgfType
     * Ȃ^łꍇA`Ƀ\bhIĂB
     * 
     * ܂nullȂƂۏ؂܂B
     * ̂ǂꂩɂłnullꍇ́A 
     * {@link org.unitarou.lang.NullArgumentException}𑗏oĂB
     * 
     * @param gc `悷OtBbNReLXgłB
     *         ĂяoŎg܂킷̂ŁA{@link GC#dispose()}
     *         ĂяoȂłBďo͕̓ۏ؂܂B
     * @param blockArea `悷PubN܂B`͐`ł邱Ƃۏ؂܂B
     *         gcɑ΂Ă͈̔͂𒴂ĕ`Ă͂Ȃ܂B
     * @param sgfType `悷^ł{@link #markerScope()}ŕԂ^ȊOw肵ꍇ͕`悳܂B
     * @param isTransient trueɐݒ肷ƁuuṽXe[^Xŕ`悵܂B
     * 
     * @throws org.unitarou.lang.NullArgumentException nullꍇ
     */
    void paintMark(GC gc, Rectangle blockArea, SgfId sgfType, boolean isTransient);
    
    
    /**
     * gcɑ΂startBlockendBlockɌ
     * sgfTypeŎw肳ꂽ`悵܂B
     * NXŎ󂯎sgfType
     * Ȃ^łꍇA`Ƀ\bhIĂB
     * 
     * ܂nullȂƂۏ؂܂B
     * ̂ǂꂩɂłnullꍇ́A 
     * {@link org.unitarou.lang.NullArgumentException}𑗏oĂB
     * 
     * @param gc `悷OtBbNReLXgłB
     *         ĂяoŎg܂킷̂ŁA{@link GC#dispose()}
     *         ĂяoȂłBďo͕̓ۏ؂܂B
     * @param startBlock `JnubN܂B`͐`ł邱Ƃۏ؂܂B
     * @param endBlock `JnubN܂B`͐`ł邱Ƃۏ؂܂B
     * @param sgfType `悷^łB
     * @param isTransient trueɐݒ肷ƁuuṽXe[^Xŕ`悵܂B
     * 
     * @throws org.unitarou.lang.NullArgumentException nullꍇ
     */
    void paintLine(GC gc, Rectangle startBlock, Rectangle endBlock, SgfId sgfType, boolean isTransient);
    
    
    /**
     * gcɑ΂block𒆐Slabel`悵܂B
     *  
     * nullȂƂۏ؂܂B
     * ̂ǂꂩɂłnullꍇ́A 
     * {@link org.unitarou.lang.NullArgumentException}𑗏oĂB
     * 
     * @param gc `悷OtBbNReLXgłB
     *         ĂяoŎg܂킷̂ŁA{@link GC#dispose()}
     *         ĂяoȂłBďo͕̓ۏ؂܂B
     * @param block x`悷钆SubNłBxꍇ͍Eɂ͂ݏo邱Ƃ܂B
     * @param label `悷郉xłB
     * @param isTransient trueɐݒ肷ƁuuṽXe[^Xŕ`悵܂B
     * 
     * @throws org.unitarou.lang.NullArgumentException nullꍇ
     */
    void paintLabel(GC gc, Rectangle block, Label label, boolean isTransient);
    
    
    /**
     * gcɑ΂blockArea͈͓̔
     * labelsŎw肵ω}p̕`悵܂B
     * ꍇ̕`惋[͊ePainterɈˑ܂B
     * 
     * @throws org.unitarou.lang.NullArgumentException nullꍇ
     */
    void paintVariation(GC gc, Rectangle blockArea, String[] labels);
    
    
    /**
     * gcɑ΂blockStatus̓eɉ⑫`悵܂B<br>
     * ł{@link org.unitarou.sgf.util.SgfPointType#OVERLAP}
     * xƂĕ`悷邱Ƃz肵Ă܂B
     * 
     * @param gc
     * @param blockStatus
     */
    void paintStatus(GC gc, BlockStatus blockStatus);
}
	