/* 
 * Copyright 2004, 2005 unitarou <boss@unitarou.org>. 
 * All rights reserved.
 * 
 * This program and the accompanying materials are made available under the terms of 
 * the Common Public License v1.0 which accompanies this distribution, 
 * and is available at http://opensource.org/licenses/cpl.php
 * 
 * Contributors:
 *     unitarou - initial API and implementation
 */
package org.unitarou.yukinoshita.view.jface.board;

import java.util.Set;

import org.eclipse.swt.graphics.GC;
import org.eclipse.swt.graphics.Rectangle;

import org.unitarou.jface.ColorResource;
import org.unitarou.sgf.type.SgfPoint;
import org.unitarou.util.ArgumentChecker;
import org.unitarou.yukinoshita.model.NodeView;

/**
 * PFœhԂPȌՂłB
 * @author unitarou &lt;boss@unitarou.org&gt;
 */
public class SimpleBoardPainter implements BoardPainter {

    /**
     * Ղ̖ؒn̐FłB
     */
    static private final ColorResource COLOR_WOOD = new ColorResource(0xCC, 0x99, 0x00);
    
    private boolean isfirst_;
    /**
     * 
     */
    public SimpleBoardPainter() {
        super();
        isfirst_ = true;
    }

    /**
     * gcrectangle͈̔͂ɌՂ̖ؒn`悵܂B
     * ؖړ쐬ꍇ́Apointŕ`ʒumF܂B
     */
    public void paint(GC gc, SgfPoint point, Rectangle rectangle) {
        gc.setBackground(COLOR_WOOD.get());
        gc.fillRectangle(rectangle);
    }

	/* (non-Javadoc)
	 * @see org.unitarou.yukinoshita.view.jface.board.BlockPainter#getDurablePaintings(org.unitarou.yukinoshita.model.NodeView)
	 */
	public Set<SgfPoint> getDurablePaintings(NodeView now) {
		ArgumentChecker.throwIfNull(now);
		if (isfirst_) {
			isfirst_ = false;
			return now.getSize().all();
		}
		return BlockPainter.EMPTY_SET;
	}

	/* (non-Javadoc)
	 * @see org.unitarou.yukinoshita.view.jface.board.BlockPainter#getTransientPaintings(org.unitarou.yukinoshita.model.NodeView)
	 */
	public Set<SgfPoint> getTransientPaintings(NodeView nodeView) {
		return BlockPainter.EMPTY_SET;
	}
}
