/*  
 * Copyright 2005 unitarou <boss@unitarou.org>. 
 * All rights reserved.
 * 
 * This program and the accompanying materials are made available under the terms of 
 * the Common Public License v1.0 which accompanies this distribution, 
 * and is available at http://opensource.org/licenses/cpl.php
 * 
 * Contributors:
 *     unitarou - initial API and implementation
 */
package org.unitarou.yukinoshita.view.jface.board;

import org.eclipse.jface.resource.FontRegistry;
import org.eclipse.jface.resource.JFaceResources;
import org.eclipse.swt.graphics.FontData;
import org.eclipse.swt.graphics.GC;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.graphics.Rectangle;
import org.eclipse.swt.widgets.Display;

import org.unitarou.jface.ColorResource;
import org.unitarou.lang.Classes;
import org.unitarou.sgf.type.SgfPoint;
import org.unitarou.sgf.type.SgfSize;
import org.unitarou.sgf.util.SgfRectangle;
import org.unitarou.sgf.util.provider.crdlp.CoordinatesLabelProvider;
import org.unitarou.util.ArgumentChecker;
import org.unitarou.yukinoshita.Yukinoshita;

/**
 * @author unitarou &lt;boss@unitarou.org&gt;
 */
public class SimpleCoordinatesPainter implements CoordinatesPainter {
    /** ClassLoaderxŃj[NȋʃtHgWXg[łB */
    static private final FontRegistry fontRegistry_s_ = JFaceResources.getFontRegistry();
    
    static private final ColorResource FONT_COLOR = new ColorResource(0,0,0);
    
    /** ݂̕`pFontFontRegistryQƂۂɕKvƂȂL[łB*/
    private final String FKEY_LABEL; 
    
    private Point labelSize_;
    private CoordinatesLabelProvider provider_;
    
    /**
     * `tHg݂̃VXetHgŏ܂B
     */
    public SimpleCoordinatesPainter() {
        super();
        FKEY_LABEL = Classes.uniqueKey(this, "FKEY_LABEL"); //$NON-NLS-1$
        labelSize_ = null;
        provider_ = Yukinoshita.context().getProvider(
                			CoordinatesLabelProvider.class, null);
    }
    
    /* (non-Javadoc)
     * @see org.unitarou.yukinoshita.view.jface.board.CoordinateLabelPainter#setLabelProvider(org.unitarou.yukinoshita.view.CoordinateLabelProvider)
     */
    public void setLabelProvider(CoordinatesLabelProvider provider) {
        ArgumentChecker.throwIfNull(provider);
        provider_ = provider;
        labelSize_ = null;
    }

    /* (non-Javadoc)
     * @see org.unitarou.yukinoshita.view.jface.board.CoordinateLabelPainter#paint(org.eclipse.swt.graphics.GC, org.eclipse.swt.graphics.Rectangle, org.unitarou.sgf.type.SgfRectangle)
     */
    public void paint(GC gc, Rectangle rectangle, SgfRectangle sgfRectangle, boolean[] visibles) {
        final int BLOCK_X = rectangle.width / sgfRectangle.width();
        final int BLOCK_Y = rectangle.height / sgfRectangle.height();
        SgfSize sgfSize = sgfRectangle.getStart().size();
        gc.setForeground(FONT_COLOR.get());
        if (visibles[0]) {
            for (int y = sgfRectangle.getStart().y(); y <= sgfRectangle.getEnd().y(); ++y) {
                String label = getYaxisLabel(sgfSize, y);
                Point size = gc.stringExtent(label);
                size.x = rectangle.x - size.x;
                size.y = BLOCK_Y * (y - sgfRectangle.getStart().y()) + (BLOCK_Y - size.y) / 2 + rectangle.y;
                gc.drawString(label, size.x, size.y, true);
            }
        }

        if (visibles[1]) {
            for (int x = sgfRectangle.getStart().x(); x <= sgfRectangle.getEnd().x(); ++x) {
                String label = getXaxisLabel(sgfSize, x);
                Point size = gc.stringExtent(label);
                size.x = BLOCK_X * (x - sgfRectangle.getStart().x()) + (BLOCK_X - size.x) / 2 + rectangle.x;
                size.y = rectangle.y - size.y;
                gc.drawString(label, size.x, size.y, true);
            }
        }
        
    }

    /* (non-Javadoc)
     * @see org.unitarou.yukinoshita.view.jface.board.CoordinateLabelPainter#calcLabelSize(org.unitarou.sgf.type.SgfRectangle)
     */
    public Point calcLabelSize(SgfRectangle sgfRectangle) {
        ArgumentChecker.throwIfNull(sgfRectangle);
        if (labelSize_ != null) {
            return new Point(labelSize_.x, labelSize_.y);
        }
        if (fontRegistry_s_.get(FKEY_LABEL) == null) {
            fontRegistry_s_.put(FKEY_LABEL, Display.getCurrent().getSystemFont().getFontData());
        }
        
        GC gc = new GC(Display.getCurrent());
        try {
            SgfSize size = sgfRectangle.getStart().size();
            labelSize_ = new Point(0, 0);
            gc.setFont(fontRegistry_s_.get(FKEY_LABEL));
            for (int x = sgfRectangle.getStart().x(); x <= sgfRectangle.getEnd().x(); ++x) {
            	String label = getXaxisLabel(size, x);
            	if (label.length() == 0) {
            		continue;
            	}
                Point point = gc.stringExtent(label);
                labelSize_.x = Math.max(labelSize_.x, point.x);
                labelSize_.y = Math.max(labelSize_.y, point.y);
            }
            for (int y = sgfRectangle.getStart().y(); y <= sgfRectangle.getEnd().y(); ++y) {
            	String label = getYaxisLabel(size, y);
            	if (label.length() == 0) {
            		continue;
            	}
                Point point = gc.stringExtent(label);
                labelSize_.x = Math.max(labelSize_.x, point.x);
                labelSize_.y = Math.max(labelSize_.y, point.y);
            }
            return new Point(labelSize_.x, labelSize_.y);
        } finally {
            gc.dispose();
        }
    }
    
    private String getXaxisLabel(SgfSize size, int x) {
        return provider_.getXLabel(SgfPoint.create(size, x, 1));
    }
    
    private String getYaxisLabel(SgfSize size, int y) {
        return provider_.getYLabel(SgfPoint.create(size, 1, y));
    }
    /**
     * 
     * @param fontData
     */
    public void setFontData(FontData fontData) {
        ArgumentChecker.throwIfNull(fontData);

        fontRegistry_s_.put(FKEY_LABEL, new FontData[]{fontData});
        labelSize_ = null;
    }
}
