/*  
 * Copyright 2004, 2005 unitarou <boss@unitarou.org>. 
 * All rights reserved.
 * 
 * This program and the accompanying materials are made available under the terms of 
 * the Common Public License v1.0 which accompanies this distribution, 
 * and is available at http://opensource.org/licenses/cpl.php
 * 
 * Contributors:
 *     unitarou - initial API and implementation
 */
package org.unitarou.yukinoshita.view.jface.board;

import java.util.HashMap;
import java.util.Map;
import java.util.Set;

import org.eclipse.swt.SWT;
import org.eclipse.swt.graphics.GC;
import org.eclipse.swt.graphics.Rectangle;

import org.unitarou.jface.ColorResource;
import org.unitarou.sgf.type.SgfPoint;
import org.unitarou.sgf.util.SgfPointType;
import org.unitarou.yukinoshita.model.NodeView;

/**
 * r`悷PainterNXłB
 * TODO ̑傫(ubN̉p[Zgōŏ)߂ 
 * TODO ŊOg̕𑾂
 * @author unitarou &lt;boss@unitarou.org&gt;
 */
public class SimpleRuledLinePainter implements RuledLinePainter {
    /** r`悷ۂ̐FłB*/
    static private final ColorResource COLOR_RULEDLINE = new ColorResource(0x00, 0x00, 0x00);

    /** `悷ۂ̐FłB*/
    static private final ColorResource COLOR_STAR = new ColorResource(0x00, 0x00, 0x00);
    
    /**
     * `ubN̑傫ɑ΂鐯̔a̔łB
     */
    static private final double RADIUS_STAR = 0.10; 
    
    /**
     * rubNTCY̍ŏlłB
     */
    static private final int SIZE_THRESHOLD_RULEDLINE = 5;
    
    /**
     * r̕ꗥPsNZƂubNTCYłB
     */
    static private final int SIZE_THRESHOLD_SINGLE_LINE = 10;

    /** }X̒S獶ɐiސ̑΍W(0.0`1.0)[x1,y1,x2,y2]łB*/
    static private final double[] LEFT_POS = {0.5, 0.5, 0.0, 0.5};

    /** }X̒SEɐiސ̑΍W(0.0`1.0)łB*/
    static private final double[] RIGHT_POS = {1.0, 0.5, 0.5, 0.5}; 

    /** }X̒Sɐiސ̑΍W(0.0`1.0)łB*/
    static private final double[] UP_POS = {0.5, 0.0, 0.5, 0.5}; 

    /** }X̒S牺ɐiސ̑΍W(0.0`1.0)łB*/
    static private final double[] DOWN_POS = {0.5, 0.5, 0.5, 1.0};
    
    
    /** OǗp̍[̑΍W(0.0`1.0)łB*/
    static private final double[] LEFT_OUTER = {0.0, 0.0, 0.0, 1.0};

    /** OǗp̉E[̑΍W(0.0`1.0)łB*/
    static private final double[] RIGHT_OUTER = {1.0, 0.0, 1.0, 1.0}; 

    /** OǗp̏[̑΍W(0.0`1.0)łB*/
    static private final double[] UP_OUTER = {0.0, 0.0, 1.0, 0.0}; 

    /** OǗp̉[̑΍W(0.0`1.0)łB*/
    static private final double[] DOWN_OUTER = {0.0, 1.0, 1.0, 1.0};

    /**
     * }X̌^(ex.E[)ɑΉ̔zi[܂B
     * ^[PointType, double[][]] łB
     */
    static private final Map<SgfPointType, double[][]> pt2PossitionMap_s_;
    
    /**
     * }X̌^(ex.E[)ɑΉ̑(1`)i[܂B
     * ^[PointType, int[]] łB
     * {@link #pt2PossitionMap_s_}Value̗vfƈvKv܂B
     */
    static private final Map<SgfPointType, int[]> pt2LineWidthMap_s_;

    
    /**
     * Ƃ̑`Ă܂B
     */
    static {
        pt2PossitionMap_s_ = new HashMap<SgfPointType, double[][]>(9);
        pt2LineWidthMap_s_ = new HashMap<SgfPointType, int[]>(9);
        
        pt2PossitionMap_s_.put(SgfPointType.TOP_LEFT, new double[][]{RIGHT_POS, DOWN_POS, LEFT_OUTER, UP_OUTER});
        pt2LineWidthMap_s_.put(SgfPointType.TOP_LEFT, new int[]{2, 2, 1, 1});

        pt2PossitionMap_s_.put(SgfPointType.TOP, new double[][]{LEFT_POS, RIGHT_POS, DOWN_POS, UP_OUTER});
        pt2LineWidthMap_s_.put(SgfPointType.TOP, new int[]{2, 2, 1, 1});

        pt2PossitionMap_s_.put(SgfPointType.TOP_RIGHT, new double[][]{LEFT_POS, DOWN_POS, RIGHT_OUTER, UP_OUTER});
        pt2LineWidthMap_s_.put(SgfPointType.TOP_RIGHT, new int[]{2, 2, 1, 1});

        pt2PossitionMap_s_.put(SgfPointType.LEFT, new double[][]{UP_POS, DOWN_POS, RIGHT_POS, LEFT_OUTER});
        pt2LineWidthMap_s_.put(SgfPointType.LEFT, new int[]{2, 2, 1, 1});

        pt2PossitionMap_s_.put(SgfPointType.EMPTY, new double[][]{UP_POS, DOWN_POS, LEFT_POS, RIGHT_POS});
        pt2LineWidthMap_s_.put(SgfPointType.EMPTY, new int[]{1, 1, 1, 1});

        pt2PossitionMap_s_.put(SgfPointType.RIGHT, new double[][]{UP_POS, DOWN_POS, LEFT_POS, RIGHT_OUTER});
        pt2LineWidthMap_s_.put(SgfPointType.RIGHT, new int[]{2, 2, 1, 1});

        pt2PossitionMap_s_.put(SgfPointType.BOTTOM_LEFT, new double[][]{RIGHT_POS, UP_POS, LEFT_OUTER, DOWN_OUTER});
        pt2LineWidthMap_s_.put(SgfPointType.BOTTOM_LEFT, new int[]{2, 2, 1, 1});

        pt2PossitionMap_s_.put(SgfPointType.BOTTOM, new double[][]{LEFT_POS, RIGHT_POS, UP_POS, DOWN_OUTER});
        pt2LineWidthMap_s_.put(SgfPointType.BOTTOM, new int[]{2, 2, 1, 1});

        pt2PossitionMap_s_.put(SgfPointType.BOTTOM_RIGHT, new double[][]{LEFT_POS, UP_POS, RIGHT_OUTER, DOWN_OUTER});
        pt2LineWidthMap_s_.put(SgfPointType.BOTTOM_RIGHT, new int[]{2, 2, 1, 1});
    }

    private boolean isFirst_;
    /**
     * 
     */
    public SimpleRuledLinePainter() {
        super();
        isFirst_ = true;
    }

    /**
     * r`悵܂B
     * @see org.unitarou.yukinoshita.view.jface.board.RuledLinePainter#paint(org.eclipse.swt.graphics.GC, org.unitarou.sgf.type.SgfPoint, org.eclipse.swt.graphics.Rectangle)
     */
    public void paint(GC gc, SgfPoint point, Rectangle rectangle) {
    	drawRuledLine(gc, point, rectangle);
        drawStar(gc, point, rectangle);
    }
    
    private void drawRuledLine(GC gc, SgfPoint point, Rectangle rectangle) {
    	final int size = Math.min(rectangle.width, rectangle.height);
    	if (size < SIZE_THRESHOLD_RULEDLINE) {
    		return;
    	}
        SgfPointType pointType = SgfPointType.classify(point);
        int[][] linePos = createLinePossition(pointType, rectangle);
        int[] lineWidth = pt2LineWidthMap_s_.get(pointType);
        gc.setLineStyle(SWT.LINE_SOLID);
        gc.setForeground(COLOR_RULEDLINE.get());
        for (int i = 0; i < linePos.length; ++i) {
            gc.setLineWidth(size < SIZE_THRESHOLD_SINGLE_LINE ? 1 : lineWidth[i]);
            gc.drawLine(linePos[i][0], linePos[i][1], linePos[i][2], linePos[i][3]);
        }
    }
     
    /**
     * ۂɌr`悷WvZĕԂ܂B
     * @param pointType
     * @param rectangle
     * @return 
     */
    private int[][] createLinePossition(SgfPointType pointType, Rectangle rectangle) {
        double[][] relPos = pt2PossitionMap_s_.get(pointType);
        
        int[][] ret = new int[relPos.length][];
        for (int i = 0; i < ret.length; ++i) {
            ret[i] = new int[relPos[i].length];
            for (int j = 0; j < ret[i].length; j+=2) {
                ret[i][j]     = (int)(relPos[i][j]     * rectangle.width + rectangle.x);
                ret[i][j + 1] = (int)(relPos[i][j + 1] * rectangle.height + rectangle.y);
            }
        }
        return ret;
    }
    
    /**
     * `悵܂B
     * @param gc
     * @param point
     * @param rectangle
     */
    private void drawStar(GC gc, SgfPoint point, Rectangle rectangle) {
        // _𖞂Ė͖
        if (!point.size().isStarPoint(point)) {
        	return;
        }
        // TCYꍇ
        int radius = (int)(rectangle.width * RADIUS_STAR);
        if (radius < 1) {
        	return;
        }
        gc.setForeground(COLOR_STAR.get());
        gc.setBackground(COLOR_STAR.get());
        gc.fillOval(rectangle.x + rectangle.width / 2 - radius, rectangle.y + rectangle.height / 2 - radius,
        		radius * 2 + 1, radius * 2 + 1);
    }

	/* (non-Javadoc)
	 * @see org.unitarou.yukinoshita.view.jface.board.BlockPainter#getDurablePaintings(org.unitarou.yukinoshita.model.NodeView)
	 */
	public Set<SgfPoint> getDurablePaintings(NodeView now) {
		if (isFirst_) {
			isFirst_ = false;
			return now.getSize().all();
		}
		return BlockPainter.EMPTY_SET;
	}

	/* (non-Javadoc)
	 * @see org.unitarou.yukinoshita.view.jface.board.BlockPainter#getTransientPaintings(org.unitarou.yukinoshita.model.NodeView)
	 */
	public Set<SgfPoint> getTransientPaintings(NodeView nodeView) {
		return BlockPainter.EMPTY_SET;
	}
}
