/*  
 * Copyright 2005 unitarou <boss@unitarou.org>. 
 * All rights reserved.
 * 
 * This program and the accompanying materials are made available under the terms of 
 * the Common Public License v1.0 which accompanies this distribution, 
 * and is available at http://opensource.org/licenses/cpl.php
 * 
 * Contributors:
 *     unitarou - initial API and implementation
 */
package org.unitarou.yukinoshita.view.jface.board.eh;

import org.eclipse.swt.events.MouseEvent;
import org.eclipse.swt.graphics.Cursor;

import org.unitarou.sgf.Property;
import org.unitarou.util.ArgumentChecker;
import org.unitarou.yukinoshita.model.NodeView;
import org.unitarou.yukinoshita.view.jface.board.BlockStatus;
import org.unitarou.yukinoshita.view.jface.resource.CanvasCursor;

/**
 * {@link org.unitarou.yukinoshita.view.jface.board.eh.EventDelegator#getBlockSituation(NodeView, BlockStatus, MouseEvent)}
 * Ԃ̃ubNɃJ[\Ƃ̕\ׂJ[\ƁAuׂvpeB
 * ێlNXłB
 * 
 * @author unitarou &lt;boss@unitarou.org&gt;
 */
public class BlockSituation {

    /**
     * \ׂJ[\ێ܂B
     */
    private Cursor cursor_;
    
    /**
     * uuvė~vpeB܂B 
     */
    private Property transientProperty_;
    
    /**
     * J[\{@link CanvasCursor#NORMAL}ŁA
     * {@link #transientProperties_}vfO̔zŏ܂B
     * 
     * @throws org.unitarou.lang.NullArgumentException null̏ꍇB
     */
    public BlockSituation() {
        this (CanvasCursor.NORMAL.getCursor(), null);
    }

    
    /**
     * J[\cursorŁA
     * {@link #transientProperties_}vfO̔zŏ܂B
     * 
     * @throws org.unitarou.lang.NullArgumentException null̏ꍇB
     */
    public BlockSituation(Cursor cursor) {
        this (cursor, null);
    }

    /**
     * J[\cursorŁA
     * {@link #transientProperties_}transientPropertiesŏ܂B
     * ̃NX̃vCRXgN^łB
     * 
     * @throws org.unitarou.lang.NullArgumentException cursornull̏ꍇB
     */
    public BlockSituation(Cursor cursor, Property transientProperty) {
        super();
        ArgumentChecker.throwIfNull(cursor);
        cursor_ = cursor;
        if (transientProperty != null) {
            transientProperty_ = new Property(transientProperty);
        }
        transientProperty_ = null;
    }

    /**
     * @return Returns the cursor.
     */
    public Cursor getCursor() {
        return cursor_;
    }
    
    /**
     * ݂ȂꍇnullԂ܂B
     * @return Returns the property.
     */
    public Property getTransientProperty() {
        if (transientProperty_ == null) {
            return null;
        }
        return new Property(transientProperty_);
    }
    
    /**
     * @param cursor The cursor to set.
     */
    public void setCursor(Cursor cursor) {
        ArgumentChecker.throwIfNull(cursor);
        cursor_ = cursor;
    }
    
    /**
     * @param transientProperties The transientProperties to set.
     */
    public void setTransientProperty(Property transientProperty) {
        ArgumentChecker.throwIfNull(transientProperty);
        
        transientProperty_ = new Property(transientProperty);
    }
}
