/*  
 * Copyright 2005 unitarou <boss@unitarou.org>. 
 * All rights reserved.
 * 
 * This program and the accompanying materials are made available under the terms of 
 * the Common Public License v1.0 which accompanies this distribution, 
 * and is available at http://opensource.org/licenses/cpl.php
 * 
 * Contributors:
 *     unitarou - initial API and implementation
 */
package org.unitarou.yukinoshita.view.jface.board.eh;

import java.util.LinkedHashMap;
import java.util.Map;

import org.eclipse.swt.SWT;
import org.eclipse.swt.events.FocusEvent;
import org.eclipse.swt.events.FocusListener;
import org.eclipse.swt.events.KeyEvent;
import org.eclipse.swt.events.KeyListener;
import org.eclipse.swt.events.MouseAdapter;
import org.eclipse.swt.events.MouseEvent;
import org.eclipse.swt.events.MouseMoveListener;
import org.eclipse.swt.events.MouseTrackListener;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.widgets.Canvas;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.Listener;

import org.unitarou.util.Adaptable;
import org.unitarou.util.ArgumentChecker;
import org.unitarou.yukinoshita.events.EventBroker;
import org.unitarou.yukinoshita.events.StateHandler;
import org.unitarou.yukinoshita.model.NodeView;
import org.unitarou.yukinoshita.model.cmd.SelectVariation;
import org.unitarou.yukinoshita.view.HandlerPhase;
import org.unitarou.yukinoshita.view.jface.board.BlockStatus;
import org.unitarou.yukinoshita.view.jface.board.IgoBoardPanel;

/**
 * {@link org.unitarou.yukinoshita.view.jface.board.IgoBoardPanel}CanvasɃtbNāA
 * }EXJ[\ꏊ{@link org.unitarou.yukinoshita.view.jface.board.BlockStatus}
 * vZĕێ{@link org.unitarou.yukinoshita.events.StateHandler}łB
 * 
 * @author unitarou &lt;boss@unitarou.org&gt;
 */
public abstract class CanvasHookedStateHandler implements Adaptable, StateHandler {

	/**
	 * L[{[hɂĕω}Iۂ̃L[łB
	 */
	static private final char[] variationKeys_s_;
	
	static {
		variationKeys_s_ = new char[26];
		variationKeys_s_[0] = ' ';
		for (int i = 1 ; i < variationKeys_s_.length; ++i) {
			variationKeys_s_[i] = (char)('a' + i - 1);
		}
	}

	
	
    private final IgoBoardPanel igoBoardPanel_;

    /**  */
    private EventBroker eventBroker_;

    private final ListenerForCanvas listenerForCanvas_;

    /** ^[{@link HandlerPhase},{@link EventDelegator}]łB*/
    private final Map<HandlerPhase, EventDelegator> eventDelegatorMap_;

    /** ݑIĂCxg㗝nh-łB*/
    private EventDelegator eventDelegator_;

    /** ݃}EX|C^[ĂubNłB*/
    private BlockStatus blockStatus_;
    

    /**
	 * @param igoBoardPanel
     * @throws org.unitarou.lang.NullArgumentException null̏ꍇ
     */
    protected CanvasHookedStateHandler(IgoBoardPanel igoBoardPanel) {
        super();
        ArgumentChecker.throwIfNull(igoBoardPanel);
        igoBoardPanel_ = igoBoardPanel;
        eventBroker_ = EventBroker.NULL_BROKER;
        listenerForCanvas_ = new ListenerForCanvas();
        eventDelegatorMap_ = new LinkedHashMap<HandlerPhase, EventDelegator>();
        eventDelegator_ = null;
        blockStatus_ = new BlockStatus();
    }

    /**
     * RXgN^Őݒ肵{@link IgoBoardPanel}Ԃ܂B
     * 
     * @return Returns the igoBoardPanel.
     */
    protected final IgoBoardPanel getIgoBoardPanel() {
        return igoBoardPanel_;
    }

    /**
     * @return Returns the eventBroker.
     */
    protected final EventBroker getEventBroker() {
        return eventBroker_;
    }

    /**
     * phaseɑΉdelegatorݒ肵܂B
     * @param phase
     * @param delegator
     * @throws org.unitarou.lang.NullArgumentException null̏ꍇ
     */
    protected final void registerDelegator(HandlerPhase phase, EventDelegator delegator) {
        ArgumentChecker.throwIfNull(phase, delegator);
        eventDelegatorMap_.put(phase, delegator);
    }
    
    /**
     * phaseɑΉ{@link EventDelegator}Ԃ܂B
     * ȂphaseɊY{@link EventDelegator}{@link #registerDelegator(HandlerPhase, EventDelegator)}
     * o^ĂȂꍇnullԂ܂B
     * @param phase
     * @return phaseɑΉEventDelegatorBΉꍇnullB
     * @throws org.unitarou.lang.NullArgumentException null̏ꍇ
     */
    protected final EventDelegator findDelegator(HandlerPhase phase) {
        ArgumentChecker.throwIfNull(phase);
        return eventDelegatorMap_.get(phase);
    }

    /**
     * ݂{@link EventDelegator}Ԃ܂B
     * {@link #setEventDelegator(HandlerPhase)}ɂĕԂCX^X͈قȂ܂B
     * @return Returns the eventDelegator.
     *           {@link #setEventDelegator(HandlerPhase)}őΉEventDelegatorꍇnullB
     */
    protected final EventDelegator getEventDelegator() {
        return eventDelegator_;
    }
    
    /**
     * ݂{@link HandlerPhase}w肵܂B
     * ̃\bhďoA{@link #getEventDelegator()}phaseɑΉ
     * {@link EventDelegator}Ԃ܂B
     * 
     * @throws org.unitarou.lang.NullArgumentException null̏ꍇB
     */
    protected final void setEventDelegator(HandlerPhase phase) {
        ArgumentChecker.throwIfNull(phase);
        eventDelegator_ = findDelegator(phase);
    }

    
    /**
     * ݂̏({@link HandlerPhase}}EXJ[\̈ʒu)ɉ{@link BlockStatus}Ԃ܂B
     * @return Returns the blockStatus.
     */
    protected final BlockStatus getBlockStatus() {
        return blockStatus_;
    }

    /**
     * 
     */
    protected final MouseEvent getMouseEvent() {
    	return listenerForCanvas_.lastMouseEvent_;
	}
    
    /**
     * Wł{@link #registerDelegator(HandlerPhase, EventDelegator)}Ŏw肵SHandlerPhaseԂ܂B
     * 
     * @see org.unitarou.yukinoshita.events.StateHandler#getHandlerPhases()
     */
    public HandlerPhase[] getHandlerPhases() {
        return  eventDelegatorMap_.keySet().toArray(
                		new HandlerPhase[eventDelegatorMap_.size()]);
    }

    /* (non-Javadoc)
     * @see org.unitarou.yukinoshita.events.SelectableViewEventHandler#setModelEventHander(org.unitarou.yukinoshita.events.EventBroker)
     */
    public final void setEventBroker(EventBroker eventBroker) {
        ArgumentChecker.throwIfNull(eventBroker);
        eventBroker_ = eventBroker;
    }


    /* (non-Javadoc)
     * @see org.unitarou.yukinoshita.events.StateHandler#connect()
     */
    public final void connect() {
        Canvas canvas = igoBoardPanel_.getCanvas();
        if (canvas == null) {
            throw new IllegalStateException("IgoBoardPanel#createContents() didn't executed."); //$NON-NLS-1$
        }
        canvas.addMouseListener(listenerForCanvas_);
        canvas.addMouseMoveListener(listenerForCanvas_);
        canvas.addMouseTrackListener(listenerForCanvas_);
        canvas.addKeyListener(listenerForCanvas_);
        canvas.addFocusListener(listenerForCanvas_);
        canvas.addListener(SWT.MouseWheel, listenerForCanvas_);
        eventBroker_.addView(this);
    }

    /* (non-Javadoc)
     * @see org.unitarou.yukinoshita.events.StateHandler#disconnect()
     */
    public final void disconnect() {
        Canvas canvas = igoBoardPanel_.getCanvas();
        if (canvas == null) {
            throw new IllegalStateException("IgoBoardPanel#createContents() didn't executed."); //$NON-NLS-1$
        }
        canvas.removeMouseListener(listenerForCanvas_);
        canvas.removeMouseMoveListener(listenerForCanvas_);
        canvas.removeMouseTrackListener(listenerForCanvas_);
        canvas.removeKeyListener(listenerForCanvas_);
        canvas.removeListener(SWT.MouseWheel, listenerForCanvas_);
        eventBroker_.removeView(this);
    }

    
    
    /**
     * }EẌʒuɍ킹āA
     * ̃ubN̏擾J[\̌`XV܂B 
     * @throws org.unitarou.lang.NullArgumentException null̏ꍇB
     */
    private void updateBlockStatus(MouseEvent e) {
    	ArgumentChecker.throwIfNull(e);
        blockStatus_ = igoBoardPanel_.getBlockStatus(new Point(e.x, e.y));
        updateBlockSituation(e);
    }
    
    /**
     * ݂{@link #blockStatus_}ɉ{@link BlockSituation}ŁA
     * {@link IgoBoardPanel}̃J[\TransientȃvpeBݒ肵܂B
     */
    protected final void updateBlockSituation(MouseEvent e) {
    	if (eventDelegator_ == null) {
    		throw new IllegalStateException("eventDelegator is null. You need call registerDelegator before."); //$NON-NLS-1$
    	}
        BlockSituation situation 
			= eventDelegator_.getBlockSituation(
					igoBoardPanel_.getNodeView(), blockStatus_, e);
        igoBoardPanel_.getCanvas().setCursor(situation.getCursor());
        igoBoardPanel_.paintInTransient(situation.getTransientProperty());
    }

    /**
     * Canvasɑ΂ă}EXNbNƂ̋`܂B
     * @throws org.unitarou.lang.NullArgumentException null̏ꍇB
     */
    protected final void mouseButtonUp(MouseEvent e) {
    	ArgumentChecker.throwIfNull(e);
    	if (eventDelegator_ == null) {
    		throw new IllegalStateException("eventDelegator is null. You need call registerDelegator before."); //$NON-NLS-1$
    	}
        if (eventDelegator_.executeEvent(
        		igoBoardPanel_.getNodeView(), blockStatus_, e, eventBroker_)) {
            // ΂łꂽ̂ŃJ[\XVB
            updateBlockStatus(e);
        }
    }

    /**
     * L[{[hꂽƗꂽɂ̃\bhĂяo܂B<br>
     * ftHg̎ł͊e{@link EventDelegator}̊Y\bhĂяo܂B
     * @param keyCode ݂(ω)L[R[h
     */
    protected void updateKey(int keyCode) {
    	if (eventDelegator_ == null) {
    		throw new IllegalStateException("eventDelegator is null. You need call registerDelegator before."); //$NON-NLS-1$
    	}
		eventDelegator_.updateKey(
				igoBoardPanel_.getNodeView(), eventBroker_, keyCode);
    }
    
    /**
     * ω}Ƃ(Ƃ肠)a,b,cƁA
     * ̕ω}I܂B
     * @see org.unitarou.yukinoshita.view.jface.board.eh.EventDelegator#updateKey(NodeView, EventBroker, int)
     */
    protected void changeVariation(int keyCode) {
    	NodeView[] variations = igoBoardPanel_.getNodeView().getVariations();
    	
    	for (int i = 0; i < variations.length; ++i) {
    		if (keyCode == variationKeys_s_[i]) {
    			eventBroker_.executeCommand(new SelectVariation(i));
    			return;
    		}
    	}
    }

    
    /**
     * }EXzC[]ɂ̃\bhĂяo܂B<br>
     * ftHg̎ł͉܂B
     * @param delta }EXzC[̈ړʁBSWT̕WƂ͋tɉɉ񂷂ƕ̒lԂ܂B
     */
    protected void mouseWheel(int delta) {
    	// Ȃ
    }

    /**
     * {@link IgoBoardPanel#getCanvas()}ɃtbNCxg
     * W񂵂Xi[NXłB
     */
    private class ListenerForCanvas extends MouseAdapter
    	implements MouseMoveListener, MouseTrackListener, KeyListener, FocusListener, Listener {
    	
    	private Control lastFocused_ = null;

        /**
         * Ō̌ĂяoꂽMouseEvenlێ܂B
         */
        private MouseEvent lastMouseEvent_ = null;

        /* (non-Javadoc)
         * @see org.eclipse.swt.events.MouseListener#mouseUp(org.eclipse.swt.events.MouseEvent)
         */
        @Override
		public void mouseUp(MouseEvent e) {
        	lastMouseEvent_ = e;
        	mouseButtonUp(e);
        }
        
        /* (non-Javadoc)
         * @see org.eclipse.swt.events.MouseMoveListener#mouseMove(org.eclipse.swt.events.MouseEvent)
         */
        public void mouseMove(MouseEvent e) {
        	lastMouseEvent_ = e;
            updateBlockStatus(e);
        }

        /* (non-Javadoc)
         * @see org.eclipse.swt.events.KeyListener#keyPressed(org.eclipse.swt.events.KeyEvent)
         */
        public void keyPressed(KeyEvent e) {
            updateKey(e.stateMask | e.keyCode);                
        }

        /* (non-Javadoc)
         * @see org.eclipse.swt.events.KeyListener#keyReleased(org.eclipse.swt.events.KeyEvent)
         */
        public void keyReleased(KeyEvent e) {
            updateKey(e.stateMask ^ e.keyCode);            
        }

        /* (non-Javadoc)
         * @see org.eclipse.swt.events.MouseTrackListener#mouseEnter(org.eclipse.swt.events.MouseEvent)
         */
        public void mouseEnter(MouseEvent e) {
        	lastMouseEvent_ = e;
        	Canvas canvas = (Canvas)e.widget;
        	if (canvas.getShell() == Display.getCurrent().getActiveShell()) {
        		lastFocused_ = Display.getCurrent().getFocusControl();
        		canvas.forceFocus();
        	} else {
        		lastFocused_ = null;
        	}
        }

        /* (non-Javadoc)
         * @see org.eclipse.swt.events.MouseTrackListener#mouseExit(org.eclipse.swt.events.MouseEvent)
         */
        public void mouseExit(MouseEvent e) {
        	lastMouseEvent_ = e;
        	if (lastFocused_ != null) {
        		lastFocused_.forceFocus();
        		lastFocused_ = null;
        	}
        }

        /* (non-Javadoc)
         * @see org.eclipse.swt.events.MouseTrackListener#mouseHover(org.eclipse.swt.events.MouseEvent)
         */
        public void mouseHover(MouseEvent e) {
        	lastMouseEvent_ = e;
            // Ȃ
        }

        /* (non-Javadoc)
         * @see org.eclipse.swt.events.FocusListener#focusGained(org.eclipse.swt.events.FocusEvent)
         */
        public void focusGained(FocusEvent e) {
            // Ȃ
        }

        /* (non-Javadoc)
         * @see org.eclipse.swt.events.FocusListener#focusLost(org.eclipse.swt.events.FocusEvent)
         */
        public void focusLost(FocusEvent e) {
            BlockSituation situation = new BlockSituation();
            igoBoardPanel_.getCanvas().setCursor(situation.getCursor());
            igoBoardPanel_.paintInTransient(situation.getTransientProperty());
        }

		/* (non-Javadoc)
		 * @see org.eclipse.swt.widgets.Listener#handleEvent(org.eclipse.swt.widgets.Event)
		 */
		public void handleEvent(Event event) {
			switch (event.type) {
			case SWT.MouseWheel:
				mouseWheel(-event.count);
				break;
			}
		}
    }
}
