/*  
 * Copyright 2005 unitarou <boss@unitarou.org>. 
 * All rights reserved.
 * 
 * This program and the accompanying materials are made available under the terms of 
 * the Common Public License v1.0 which accompanies this distribution, 
 * and is available at http://opensource.org/licenses/cpl.php
 * 
 * Contributors:
 *     unitarou - initial API and implementation
 */
package org.unitarou.yukinoshita.view.jface.board.eh;

import org.eclipse.swt.events.MouseEvent;

import org.unitarou.yukinoshita.events.EventBroker;
import org.unitarou.yukinoshita.model.NodeView;
import org.unitarou.yukinoshita.view.jface.board.BlockStatus;

/**
 * {@link org.unitarou.yukinoshita.events.StateHandler}
 * s㗝łC^[tFCXłB
 * eNX{@link org.unitarou.yukinoshita.view.HandlerPhase}Ȃǂ
 * ԂɂĐ؂ւ邱Ƃz肵Ă܂B
 * 
 * @author unitarou &lt;boss@unitarou.org&gt;
 */
public interface EventDelegator {
    /**
     * nodeView̏Ԃ\ĂՂ
     * blockStatusAmouseEventɍ킹J[\ƉuׂvpeBԂ܂B
     * ߂l͕K݂AnullɂȂ܂B
     * @param mouseEvent TODO
     * 
     * @throws org.unitarou.lang.NullArgumentException null̏ꍇ
     */
    BlockSituation getBlockSituation(
    		NodeView nodeView, BlockStatus blockStatus,
    		MouseEvent mouseEvent);
    
    /**
     * nodeView̏Ԃ\ĂՂ
     * ݃|CgĂblockStatusɑ΂mouseEventɍ킹
     * eventBrokerɑ΂ăCxgʒm܂B
     * @return eventBrokerɉ炩̃CxgʒmƂtrueA
     *          ̃CxgʒmȂꍇfalseB
     * 
     * @throws org.unitarou.lang.NullArgumentException null̏ꍇ
     */
    boolean executeEvent(
            NodeView nodeView, BlockStatus blockStatus, 
            MouseEvent mouseEvent, EventBroker eventBroker);

    
    /**
     * keyCodeXVꂽɒʒm܂B<br>
     * NX͕KvɉēԂύXĂB
     * 
     * @see org.eclipse.swt.events.KeyEvent#keyCode
     */
    void updateKey(NodeView nodeView, EventBroker eventBroker, int keyCode);
    
    
    /**
     * ԂZbg܂B<br>
     * tF[Y̐؂ւȂǂŌĂяo܂B
     */
    void resetStatus();
}
