/*  
 * Copyright 2005 unitarou <boss@unitarou.org>. 
 * All rights reserved.
 * 
 * This program and the accompanying materials are made available under the terms of 
 * the Common Public License v1.0 which accompanies this distribution, 
 * and is available at http://opensource.org/licenses/cpl.php
 * 
 * Contributors:
 *     unitarou - initial API and implementation
 */
package org.unitarou.yukinoshita.view.jface.board.eh;


import org.unitarou.util.ArgumentChecker;
import org.unitarou.yukinoshita.view.HandlerPhase;
import org.unitarou.yukinoshita.view.cmd.NodeJumpCommand;
import org.unitarou.yukinoshita.view.jface.board.IgoBoardPanel;

/**
 * 
 * @author unitarou &lt;boss@unitarou.org&gt;
 */
public class GameViewStateHandler extends CanvasHookedStateHandler {

    
    /**
     * @throws org.unitarou.lang.NullArgumentException null̏ꍇ
     */
    public GameViewStateHandler(IgoBoardPanel igoBoardPanel) {
        super(igoBoardPanel);
        ArgumentChecker.throwIfNull(igoBoardPanel);
        registerDelegator(HandlerPhase.SELECT, new SelectEventDelegator());
        setEventDelegator(HandlerPhase.SELECT);
    }

    /* (non-Javadoc)
	 * @see org.unitarou.util.Adaptable#getAdapter(java.lang.Class)
	 */
	public Object getAdapter(Class<?> adapter) {
		return null;
	}

	
	/**
	 * {̓L[ƕω}I܂B
	 * @see org.unitarou.yukinoshita.view.jface.board.eh.CanvasHookedStateHandler#updateKey(int)
	 */
	@Override
	protected void updateKey(int keyCode) {
		changeVariation(keyCode);
	}

	/* (non-Javadoc)
	 * @see org.unitarou.yukinoshita.view.jface.board.eh.CanvasHookedStateHandler#mouseWheel(int)
	 */
	@Override
	protected void mouseWheel(int delta) {
		delta = delta / 3;
		if (delta != 0) {
			NodeJumpCommand command = new NodeJumpCommand(delta);
			getEventBroker().executeCommand(command);
		}
	}
}
