/*  
 * Copyright 2005 unitarou <boss@unitarou.org>. 
 * All rights reserved.
 * 
 * This program and the accompanying materials are made available under the terms of 
 * the Common Public License v1.0 which accompanies this distribution, 
 * and is available at http://opensource.org/licenses/cpl.php
 * 
 * Contributors:
 *     unitarou - initial API and implementation
 */
package org.unitarou.yukinoshita.view.jface.board.eh;

import java.util.ArrayList;
import java.util.List;
import java.util.SortedMap;
import java.util.TreeMap;

import org.eclipse.jface.util.Geometry;
import org.eclipse.swt.SWT;
import org.eclipse.swt.events.MouseEvent;
import org.eclipse.swt.graphics.Point;

import org.unitarou.jface.CursorResource;
import org.unitarou.lang.UEnum;
import org.unitarou.sgf.Property;
import org.unitarou.sgf.SgfId;
import org.unitarou.sgf.type.SgfLine;
import org.unitarou.sgf.type.SgfPoint;
import org.unitarou.swt.Line;
import org.unitarou.util.ArgumentChecker;
import org.unitarou.yukinoshita.events.EventBroker;
import org.unitarou.yukinoshita.model.NodeView;
import org.unitarou.yukinoshita.model.cmd.UpdateProperty;
import org.unitarou.yukinoshita.view.jface.board.BlockStatus;
import org.unitarou.yukinoshita.view.jface.resource.CanvasCursor;

/**
 * {@link org.unitarou.yukinoshita.view.HandlerPhase#LINE}
 * Ԃ̂Ƃ{@link org.unitarou.yukinoshita.events.EventBroker}
 * 
 * s㗝NXłB
 *  * @author unitarou &lt;boss@unitarou.org&gt;
 */
public class LineEventDelegator implements EventDelegator {
    
    /**
     * n_Œ肵Ă邩AĂȂێԃNXłB 
     */
    static private class State extends UEnum {
        protected State(String typeName) {
            super(typeName);
        }
    }
   
    /**
     * n_Œ肵ĂȂԂ\܂B
     * ̏Ԃňʒuw肷{@link #BOUND}ɑJڂ܂B
     */
    static private final State FREE = new State("free"); //$NON-NLS-1$

    /** 
     * n_Œ肵Ԃ\܂B
     * ̏Ԃňʒuw肷Ɛ`悵{@link #FREE}ɑJڂ܂B
     */
    static private final State BOUND = new State("bound"); //$NON-NLS-1$

    /** DelegatorŕҏW\MarkɑΉJ[\Ă܂B */
    static private final CursorResource[] decorationCursors_s_;

    /** DelegatorŕҏW\MarkɑΉ{@link SgfId}Ă܂B*/
    static private final SgfId[] markIds_s_;
    
    static {
    	List<CursorResource> list = new ArrayList<CursorResource>(2); //Ƃ肠Ă邾̐
        list.add(CanvasCursor.MARK_LINE);
        list.add(CanvasCursor.MARK_ARROW);
        decorationCursors_s_ = list.toArray(new CursorResource[list.size()]);
        
        List<SgfId> list2 = new ArrayList<SgfId>(2); //Ƃ肠Ă邾̐
        list2.add(SgfId.LINE);
        list2.add(SgfId.ARROW);
        markIds_s_ = list2.toArray(new SgfId[list.size()]);
    }

    /** 
     * ݑIẴCfbNXێ܂B
     */
    private int currentLineIndex_;
    
    /** ݂̏Ԃ܂B*/
    private State state_;
    
    /**
     * C̊Jn_܂B 
     */
    private SgfPoint startPoint_;
    
    /**
     * 
     */
    public LineEventDelegator() {
        super();
        currentLineIndex_ = 0;
        state_ = FREE;
    }

	/* (non-Javadoc)
	 * @see org.unitarou.yukinoshita.view.jface.board.eh.EventDelegator#resetStatus()
	 */
	public void resetStatus() {
        currentLineIndex_ = 0;
        state_ = FREE;
	}

	/* (non-Javadoc)
     * @see org.unitarou.yukinoshita.view.jface.board.eh.EventDelegator#getCursor(org.unitarou.yukinoshita.model.NodeView, org.unitarou.yukinoshita.view.jface.board.BlockStatus)
     */
    public BlockSituation getBlockSituation(
    		NodeView nodeView, BlockStatus blockStatus, MouseEvent mouseEvent) 
    {
        ArgumentChecker.throwIfNull(nodeView, blockStatus, mouseEvent);

        BlockSituation ret = new BlockSituation();
        // Ղ̊Oł͖
        if (blockStatus.getPoint() == null) {
            return ret;
        }
        ret.setCursor(decorationCursors_s_[currentLineIndex_].getCursor());
        if (BOUND.equals(state_)) {
            SgfLine line = new SgfLine(startPoint_, blockStatus.getPoint());
            ret.setTransientProperty(markIds_s_[currentLineIndex_].makeProperty(line));
        } else {
        	Property touchedLine = findTouchedLine(nodeView, blockStatus, mouseEvent);
        	if (touchedLine != null) {
        		ret.setTransientProperty(touchedLine);
        	}
        }
        return ret;
    }


	/**
	 * }EX|C^̈ʒũCɐGĂꍇA
	 * ԋ߂CԂ܂B
	 * @param nodeView
	 * @param mouseEvent
	 * @return
	 */
	private Property findTouchedLine(
			NodeView nodeView, BlockStatus blockStatus, MouseEvent mouseEvent) 
	{
		SortedMap<Double, Property> map = new TreeMap<Double, Property>();
    	for (SgfId id : markIds_s_) {
    		Property property = nodeView.getProperty(id);
    		if (property == null) {
    			continue;
    		}
    		for (String string : property.getStrings()) {
    			SgfLine sgfLine = SgfLine.parseQuietly(nodeView.getSize(), string);
    			if (sgfLine == null) {
    				continue;
    			}
    			
    			Point blockCenter = Geometry.centerPoint(blockStatus.getRectangle());
    			int size = blockStatus.getRectangle().width;
    			Point start =new Point(
    					blockCenter.x - (blockStatus.getPoint().x() - sgfLine.getStart().x()) * size,
    					blockCenter.y - (blockStatus.getPoint().y() - sgfLine.getStart().y()) * size);

    			Point end =new Point(
    					blockCenter.x - (blockStatus.getPoint().x() - sgfLine.getEnd().x()) * size,
    					blockCenter.y - (blockStatus.getPoint().y() - sgfLine.getEnd().y()) * size);
    			double distance = new Line(start, end).distance(new Point(mouseEvent.x, mouseEvent.y));
    			map.put(new Double(distance), new Property(id, string));
    		}
    	}
    	if (map.isEmpty()) {
    		return null;
    	}
    	if (map.firstKey().doubleValue() < 6.0) { //TODO 6.0̓}WbNio[
    		Property property = map.get(map.firstKey());
    		return property;
    	}
		return null;
	}

	/* (non-Javadoc)
     * @see org.unitarou.yukinoshita.view.jface.board.eh.EventDelegator#executeEvent(org.unitarou.yukinoshita.model.NodeView, org.unitarou.yukinoshita.view.jface.board.BlockStatus, org.eclipse.swt.events.MouseEvent, org.unitarou.yukinoshita.events.EventBroker)
     */
    public boolean executeEvent(
            NodeView nodeView, BlockStatus blockStatus, 
            MouseEvent mouseEvent, EventBroker eventBroker) 
    {
        ArgumentChecker.throwIfNull(nodeView, blockStatus, mouseEvent, eventBroker);
        // Ղ̊Oł͖
        if (blockStatus.getPoint() == null) {
            return false;
        }
        
        if (FREE.equals(state_)) {
            return executeEventInFree(nodeView, blockStatus, mouseEvent, eventBroker);
            
        } else if (BOUND.equals(state_)) {
            return executeEventInBound(nodeView, blockStatus, mouseEvent, eventBroker);
            
        } else {
            assert false : "Unknown state: " + state_; //$NON-NLS-1$
        }
        return false;
    }
    
    /**
     * {@link #state_}{@link #FREE}̂Ƃ̃CxgnhłB 
     * NbNŁA̓_L^ABOUNDɐi݂܂B
     * ENbNł̃Cɂ郉C܂B
     * ȂAꍇ͑I܂(n_EI_̓_CAOI΂)B
     */
    private boolean executeEventInFree(
            NodeView nodeView, BlockStatus blockStatus, 
            MouseEvent mouseEvent, EventBroker eventBroker) 
    {
        if (mouseEvent.button == 1) {
            startPoint_ = blockStatus.getPoint();
            state_ = BOUND;
            return false;

        } else if (mouseEvent.button == 3) {
        	Property property = findTouchedLine(nodeView, blockStatus, mouseEvent);
        	if (property != null) {
                eventBroker.executeCommand(
                		new UpdateProperty(new Property[]{property}, null, null));
                return true;
        	}
        }
        return false;
    }

    /**
     * {@link #state_}{@link #BOUND}̂Ƃ̃CxgnhłB
     * ȑỎĂ獡̒n_܂ł̉
     * (J[\ŏAB؂蕪āAOɕ`̂H
     * @\̏ꍇIgoBoardPanel̃C^[tFCX
     * ƂŃLoX󂯎ĕ`قH
     * @\̏ꍇ͂̃\bh̃C^[tFCXς)
     * ENbNŃLZB
     * xNbNŊm肵FREEɐiށBn_EI_̑gAR,LN
     */
    private boolean executeEventInBound(
            NodeView nodeView, BlockStatus blockStatus, 
            MouseEvent mouseEvent, EventBroker eventBroker) 
    {
        if (mouseEvent.button == 1) {
            SgfLine line = new SgfLine(startPoint_, blockStatus.getPoint());
            Property property 
            		= new Property(markIds_s_[currentLineIndex_],
            						line.getString());
            eventBroker.executeCommand(
            		new UpdateProperty(new Property[0], property, null));
            
            state_ = FREE;
            startPoint_ = null;
            return true;
            
        } else if (mouseEvent.button == 3) {
            state_ = FREE;
            startPoint_ = null;
            return true;
        }
        return false;
    }

    /**
     * SHIFTL[CTRLL[ŕҏWLς܂B
     * 
     * @see org.unitarou.yukinoshita.view.jface.board.eh.EventDelegator#updateKey(NodeView, EventBroker, int)
     */
    public void updateKey(NodeView nodeView, EventBroker eventBroker, int keyCode) {
        switch (keyCode) {
        case SWT.SHIFT:
            --currentLineIndex_;
        	if (currentLineIndex_ < 0) {
        	    currentLineIndex_ = decorationCursors_s_.length - 1;
        	}
        
        	break;
        	
        case SWT.CTRL:
            currentLineIndex_ = (++currentLineIndex_) % decorationCursors_s_.length;
        	break;
        }
    }
}
