/*  
 * Copyright 2005 unitarou <boss@unitarou.org>. 
 * All rights reserved.
 * 
 * This program and the accompanying materials are made available under the terms of 
 * the Common Public License v1.0 which accompanies this distribution, 
 * and is available at http://opensource.org/licenses/cpl.php
 * 
 * Contributors:
 *     unitarou - initial API and implementation
 */
package org.unitarou.yukinoshita.view.jface.board.eh;

import java.util.ArrayList;
import java.util.List;

import org.eclipse.jface.dialogs.InputDialog;
import org.eclipse.jface.window.Window;
import org.eclipse.swt.SWT;
import org.eclipse.swt.events.MouseEvent;
import org.eclipse.swt.widgets.Display;

import org.unitarou.jface.CursorResource;
import org.unitarou.lang.Strings;
import org.unitarou.ml.Messages;
import org.unitarou.sgf.Property;
import org.unitarou.sgf.SgfId;
import org.unitarou.sgf.ValueType;
import org.unitarou.sgf.type.Label;
import org.unitarou.sgf.type.SgfPoint;
import org.unitarou.sgf.type.SimpleText;
import org.unitarou.util.ArgumentChecker;
import org.unitarou.yukinoshita.events.EventBroker;
import org.unitarou.yukinoshita.model.NodeView;
import org.unitarou.yukinoshita.model.cmd.UpdateProperty;
import org.unitarou.yukinoshita.view.jface.board.BlockStatus;
import org.unitarou.yukinoshita.view.jface.resource.CanvasCursor;

/**
 * {@link org.unitarou.yukinoshita.view.HandlerPhase#MARKUP}
 * Ԃ̂Ƃ{@link org.unitarou.yukinoshita.events.EventBroker}
 * s㗝NXłB
 * 
 * @author unitarou &lt;boss@unitarou.org&gt;
 */
public class MarkupEventDelegator implements EventDelegator {
	static private final Messages msg_s_ 
			= Messages.createByPackage(MarkupEventDelegator.class);
    /** ux̃eLXgwv */
	static private final String NT_REQUEST_LABEL_TEXT
			= Messages.createKey(MarkupEventDelegator.class, "ntRequestLabelText"); //$NON-NLS-1$
	/** uՂɏރx̃eLXg͂ĂBv*/
	static private final String MSG_REQUEST_LABEL_TEXT
			= Messages.createKey(MarkupEventDelegator.class, "msgRequestLabelText"); //$NON-NLS-1$
    
    /** DelegatorŕҏW\MarkɑΉJ[\Ă܂B */
    static private final CursorResource[] decorationCursors_s_;
    
    /** DelegatorŕҏW\MarkɑΉ{@link SgfId}Ă܂B*/
    static private final SgfId[] markTypes_s_;
    static {
        List<CursorResource> list = new ArrayList<CursorResource>(9); //Ƃ肠Ă邾̐
        list.add(CanvasCursor.MARK_CROSS);
        list.add(CanvasCursor.MARK_CIRCLE);
        list.add(CanvasCursor.MARK_SQUARE);
        list.add(CanvasCursor.MARK_TRIANGLE);
        list.add(CanvasCursor.MARK_SELECT);
        list.add(CanvasCursor.MARK_LABEL);
        list.add(CanvasCursor.MARK_TERRITORY_WHITE);
        list.add(CanvasCursor.MARK_TERRITORY_BLACK);
        list.add(CanvasCursor.MARK_DIMMED);
        decorationCursors_s_ = list.toArray(new CursorResource[list.size()]);
        
        List<SgfId> list2 = new ArrayList<SgfId>(9); //Ƃ肠Ă邾̐
        list2.add(SgfId.MARK_WITH_X);
        list2.add(SgfId.CIRCLE);
        list2.add(SgfId.SQUARE);
        list2.add(SgfId.TRIANGLE);
        list2.add(SgfId.SELECTED);
        list2.add(SgfId.LABEL);
        list2.add(SgfId.TERRITORY_WHITE);
        list2.add(SgfId.TERRITORY_BLACK);
        list2.add(SgfId.DIM_POINTS);
        markTypes_s_ = list2.toArray(new SgfId[list.size()]);
    }
    
    /**
     * ݑIĂL̔ԍ܂B 
     */
    private int currentMarkIndex_;
    /**
     * 
     */
    public MarkupEventDelegator() {
        super();
        currentMarkIndex_ = 0;
    }

    /* (non-Javadoc)
	 * @see org.unitarou.yukinoshita.view.jface.board.eh.EventDelegator#resetStatus()
	 */
	public void resetStatus() {
		currentMarkIndex_ = 0;
	}

    /* (non-Javadoc)
     * @see org.unitarou.yukinoshita.view.jface.board.eh.EventDelegator#getCursor(org.unitarou.yukinoshita.model.NodeView, org.unitarou.yukinoshita.view.jface.board.BlockStatus)
     */
    public BlockSituation getBlockSituation(NodeView nodeView, BlockStatus blockStatus, MouseEvent mouseEvent) {
        ArgumentChecker.throwIfNull(nodeView, blockStatus);

        BlockSituation ret = new BlockSituation();
        if (blockStatus.getPoint() == null) {
            // Ղ̊Oł͌邪ADD̏ꍇ̂݃I[NAɂȂB
        	if (markTypes_s_[currentMarkIndex_].equals(SgfId.DIM_POINTS)) {
        		ret.setCursor(CanvasCursor.MARK_DIMMED_ERASE.getCursor());
        		ret.setTransientProperty(
        				SgfId.DIM_POINTS.makeProperty(
        						SgfPoint.createPass(nodeView.getSize())));
        	}
            return ret;
        }
        ret.setCursor(decorationCursors_s_[currentMarkIndex_].getCursor());
        if (markTypes_s_[currentMarkIndex_].valueType().equals(ValueType.POINT)) {
            ret.setTransientProperty(markTypes_s_[currentMarkIndex_].makeProperty(blockStatus.getPoint()));
        } else if (markTypes_s_[currentMarkIndex_].equals(SgfId.LABEL)) {
        	String label = getLabel(nodeView, blockStatus.getPoint());
        	if (label.length() != 0) {
                ret.setTransientProperty(SgfId.LABEL.makeProperty(
                    	new Label(blockStatus.getPoint(), new SimpleText(label))));
        	}
        }
        return ret;
    }

    /**
     * NbNŌݕ\ĂJ[\Marko܂B
     * ꏊɕʂ̋Lꍇ͈ȑŐL͏܂B
     * ENbNŌ݃J[\ꏊMark폜܂B
     * ݃J[\Ƃ͈ႤMarkłĂ폜܂B
     * 
     * @see org.unitarou.yukinoshita.view.jface.board.eh.EventDelegator#executeEvent(org.unitarou.yukinoshita.model.NodeView, org.unitarou.yukinoshita.view.jface.board.BlockStatus, org.eclipse.swt.events.MouseEvent, org.unitarou.yukinoshita.events.EventBroker)
     */
    public boolean executeEvent(
            NodeView nodeView, BlockStatus blockStatus, 
            MouseEvent mouseEvent, EventBroker eventBroker)
    {
        ArgumentChecker.throwIfNull(nodeView, blockStatus, mouseEvent, eventBroker);
        if (blockStatus.getPoint() == null) {
            // Ղ̊Oł͌邪ADD̏ꍇ̂݃I[NAɂȂB
        	if (markTypes_s_[currentMarkIndex_].equals(SgfId.DIM_POINTS)) {
                // ̏ɋL𑫂āAȊŐL폜Ώ̂ɉ񂷁B
                Property property 
                	= SgfId.DIM_POINTS.makeProperty(
                			SgfPoint.createPass(nodeView.getSize()));
                eventBroker.executeCommand(
                		new UpdateProperty(new Property[0], property, null));
                return true;
        	}
            return false;
        }

        SgfPoint point = blockStatus.getPoint();
        if (mouseEvent.button == 1) {
            // ̏ɋL𑫂āAȊŐL폜Ώ̂ɉ񂷁B
            SgfId sgfType = markTypes_s_[currentMarkIndex_];
            Property property;
            boolean removeOnly = false;
            if (!SgfId.LABEL.equals(sgfType)) {
                property = new Property(sgfType, point.getString());
            } else {
            	// x̏ꍇ̓_CAOLZꂽꍇ̏sA
            	// ̏ŋw肵Ƀx폜悤ƂĂB
            	String label = askLabelText(nodeView, point);
            	if (label == null) {
            		return false;
            	}
            	if (label.equals(Strings.EMPTY)) {
            		property = null;
            		removeOnly = true;
            	} else {
                	Label lb = new Label(point, new SimpleText(label));
                	property = new Property(sgfType, lb.getString());
            	}
            }
            Property[] removeProperties = composeRemoveMark(nodeView, point, !removeOnly);
            eventBroker.executeCommand(
            		new UpdateProperty(removeProperties, property, null));
            return true;

        } else if (mouseEvent.button == 3) {
            // SL폜Ώۂɉ񂷁B
            Property[] removeProperties = composeRemoveMark(nodeView, point, false);
            eventBroker.executeCommand(
            		new UpdateProperty(removeProperties, null, null));
            return true;
        }
        return false;
    }
    
    /**
     * LBpɃx̕[UɎw肳܂B<br>
     * _CAOœ͊mFƂɃLZꍇ̂nullԂ܂B
	 * @return
	 */
	private String askLabelText(NodeView nodeView, SgfPoint point) {
        // ȑO̓ꏊɂ郉x擾B
        String lastLabel = getLabel(nodeView, point);
        InputDialog dialog
        		= new InputDialog(Display.getCurrent().getActiveShell(),
        					msg_s_.get(NT_REQUEST_LABEL_TEXT), 
        					msg_s_.get(MSG_REQUEST_LABEL_TEXT), 
        					lastLabel, null);

        if (dialog.open() == Window.OK) { 
        	return dialog.getValue(); 
        	
        }
        return null;
	}
	
	/**
	 * pointɃxꍇɂ̃x̃eLXgԂ܂B
	 * Ȃꍇ{@link Strings#EMPTY}Ԃ܂B
	 * @param point
	 * @return
	 */
	private String getLabel(NodeView nodeView, SgfPoint point) {
        Property property = nodeView.getProperty(SgfId.LABEL);
        if (property == null) {
        	return Strings.EMPTY;
        }
        String[] data = property.getStrings();
        for (int i = 0; i < data.length; ++i) {
            Label label = Label.parseQuietly(point.size(), data[i]);
            if (label != null && label.getPoint().equals(point)) {
                return label.getLabel().getText();
            }
        }
        return Strings.EMPTY;
	}

    
    private Property[] composeRemoveMark(NodeView nodeView, SgfPoint point, boolean ignoreCurrentMark) {
        List<Property> ret = new ArrayList<Property>(markTypes_s_.length);
        for (int i = 0; i < markTypes_s_.length; ++i) {
            if (ignoreCurrentMark && i == currentMarkIndex_) {
                continue;
            }
            if (SgfId.LABEL.equals(markTypes_s_[i])) {
                Label lb = new Label(point, new SimpleText(getLabel(nodeView, point)));
                ret.add(markTypes_s_[i].makeProperty(lb));
            } else {
                ret.add(markTypes_s_[i].makeProperty(point));
            }
        }
        return ret.toArray(new Property[ret.size()]);
    }

    /**
     * SHIFTL[CTRLL[ŕҏWLς܂B
     * 
     * @see org.unitarou.yukinoshita.view.jface.board.eh.EventDelegator#updateKey(NodeView, EventBroker, int)
     */
    public void updateKey(NodeView nodeView, EventBroker eventBroker, int keyCode) {
        switch (keyCode) {
        case SWT.SHIFT:
            --currentMarkIndex_;
        	if (currentMarkIndex_ < 0) {
        	    currentMarkIndex_ = decorationCursors_s_.length - 1;
        	}
        
        	break;
        	
        case SWT.CTRL:
            currentMarkIndex_ = (++currentMarkIndex_) % decorationCursors_s_.length;
        	break;
        }
    }
}
