/*  
 * Copyright 2005 unitarou <boss@unitarou.org>. 
 * All rights reserved.
 * 
 * This program and the accompanying materials are made available under the terms of 
 * the Common Public License v1.0 which accompanies this distribution, 
 * and is available at http://opensource.org/licenses/cpl.php
 * 
 * Contributors:
 *     unitarou - initial API and implementation
 */
package org.unitarou.yukinoshita.view.jface.board.eh;

import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

import org.unitarou.util.ArgumentChecker;
import org.unitarou.yukinoshita.model.ProblemStatus;
import org.unitarou.yukinoshita.view.HandlerPhase;
import org.unitarou.yukinoshita.view.jface.board.IgoBoardPanel;
import org.unitarou.yukinoshita.view.monitor.ControllerStatusMonitor;
import org.unitarou.yukinoshita.view.monitor.ProblemStatusMonitor;

/**
 * lĂ鎞̏ԊǗNXłB
 * 
 * @author unitarou &lt;boss@unitarou.org&gt;
 */
public class ProblemViewStateHandler extends CanvasHookedStateHandler {
    /** ̃NX̃K[łB*/
	static private final Log log_s_ = LogFactory.getLog(ProblemViewStateHandler.class);

	/** ̃NX̃A_v^[łB*/
    private final Adapter adapter_;

    /**
     * @throws org.unitarou.lang.NullArgumentException null̏ꍇB
     */
    public ProblemViewStateHandler(IgoBoardPanel igoBoardPanel) {
        super(igoBoardPanel);

        registerDelegator(HandlerPhase.SOLVE, new SolveEventDelegator());
        registerDelegator(HandlerPhase.SOLVE_END, new SolveEndEventDelegator());
        registerDelegator(HandlerPhase.ANSWER, new AnswerEventDelegator());
        setEventDelegator(HandlerPhase.SOLVE);

        adapter_ = new Adapter();
    }

    /* (non-Javadoc)
     * @see org.unitarou.lang.Adaptable#getAdapter(java.lang.Class)
     */
    public Object getAdapter(Class<?> adapter) {
        if (adapter == null) {
            return null;
        }
        if (adapter.isAssignableFrom(adapter_.getClass())) {
            return adapter_;
        }
        return null;
    }

    /* (non-Javadoc)
     * @see org.unitarou.yukinoshita.events.StateHandler#getHandlerStatuses()
     */
    @Override
	public HandlerPhase[] getHandlerPhases() {
        return new HandlerPhase[]{HandlerPhase.SOLVE};
    }



    private class Adapter implements ControllerStatusMonitor, ProblemStatusMonitor {

        /* (non-Javadoc)
         * @see org.unitarou.yukinoshita.view.ControllerStatusMonitor#setEditMode(boolean)
         */
        public void setEditMode(boolean isEditMode) {
            // Ȃ
        }

        /**
         * statusm̗vf̏ꍇ́A
         * {@link HandlerPhase#SOLVE}ɂĂ܂B
         * @see org.unitarou.yukinoshita.view.monitor.ControllerStatusMonitor#changeHandlerPhase(org.unitarou.yukinoshita.view.HandlerPhase)
         */
        public void changeHandlerPhase(HandlerPhase phase) {
            ArgumentChecker.throwIfNull(phase);
            if (findDelegator(phase) == null) {
                log_s_.warn("Unknown HandlerStatus, use " + HandlerPhase.SOLVE  //$NON-NLS-1$
                        	+" insted. status=" + phase); //$NON-NLS-1$
                phase = HandlerPhase.SOLVE;
            }

            setEventDelegator(phase);
            updateBlockSituation(getMouseEvent());
        }

        /* (non-Javadoc)
         * @see org.unitarou.yukinoshita.view.ProblemStatusMonitor#update(org.unitarou.yukinoshita.model.ProblemStatus)
         */
        public void update(ProblemStatus problemStatus) {
            ArgumentChecker.throwIfNull(problemStatus);
            if (ProblemStatus.SOLVE.equals(problemStatus)) {
                setEventDelegator(HandlerPhase.SOLVE);
                
            } else if (ProblemStatus.CORRECT.equals(problemStatus)
                    || ProblemStatus.QUASI_CORRECT.equals(problemStatus)
                    || ProblemStatus.WRONG.equals(problemStatus)) {
                setEventDelegator(HandlerPhase.SOLVE_END);
                
            } else if (ProblemStatus.ANSWER.equals(problemStatus)) {
                setEventDelegator(HandlerPhase.ANSWER);
                
            } else {
                log_s_.debug("Unknown status:" + problemStatus); //$NON-NLS-1$
            }
        }
    }
}
