/*  
 * Copyright 2005 unitarou <boss@unitarou.org>. 
 * All rights reserved.
 * 
 * This program and the accompanying materials are made available under the terms of 
 * the Common Public License v1.0 which accompanies this distribution, 
 * and is available at http://opensource.org/licenses/cpl.php
 * 
 * Contributors:
 *     unitarou - initial API and implementation
 */
package org.unitarou.yukinoshita.view.jface.board.eh;

import org.eclipse.swt.events.MouseEvent;

import org.unitarou.lang.Objects;
import org.unitarou.sgf.type.SgfPoint;
import org.unitarou.sgf.util.SgfPointType;
import org.unitarou.util.ArgumentChecker;
import org.unitarou.yukinoshita.events.EventBroker;
import org.unitarou.yukinoshita.model.NodeEntity;
import org.unitarou.yukinoshita.model.NodeView;
import org.unitarou.yukinoshita.model.cmd.SelectVariation;
import org.unitarou.yukinoshita.view.cmd.NodeJumpCommand;
import org.unitarou.yukinoshita.view.jface.board.BlockStatus;
import org.unitarou.yukinoshita.view.jface.resource.CanvasCursor;

/**
 * {@link org.unitarou.yukinoshita.view.HandlerPhase#SELECT}
 * Ԃ̂Ƃ{@link org.unitarou.yukinoshita.events.EventBroker}
 * s㗝NXłB
 * 
 * @author unitarou &lt;boss@unitarou.org&gt;
 */
public class SelectEventDelegator implements EventDelegator {
    /**
     * 
     */
    public SelectEventDelegator() {
        super();
    }

    /* (non-Javadoc)
	 * @see org.unitarou.yukinoshita.view.jface.board.eh.EventDelegator#resetStatus()
	 */
	public void resetStatus() {
		//ȂĂ悢
	}

	/**
     * ł{@link CanvasCursor#NORMAL}ɕԂ܂B
     * 
     * @throws org.unitarou.lang.NullArgumentException null̏ꍇ
     * @see org.unitarou.yukinoshita.view.jface.board.eh.CursorSelector#get(org.unitarou.yukinoshita.view.jface.board.BlockStatus)
     */
    public BlockSituation getBlockSituation
    		(NodeView nodeView, 
    		BlockStatus blockStatus, 
    		MouseEvent mouseEvent) 
    {
        ArgumentChecker.throwIfNull(nodeView, blockStatus);

        BlockSituation ret = new BlockSituation();
        return ret;
    }

    /* (non-Javadoc)
     * @see org.unitarou.yukinoshita.view.jface.board.eh.CursorSelector#executeEvent(org.unitarou.yukinoshita.view.jface.board.BlockStatus, org.eclipse.swt.events.MouseEvent, org.unitarou.yukinoshita.events.EventBroker)
     */
    public boolean executeEvent(
            NodeView nodeView, BlockStatus blockStatus, 
            MouseEvent mouseEvent, EventBroker eventBroker) 
    {
        ArgumentChecker.throwIfNull(nodeView, blockStatus, mouseEvent, eventBroker);
        
        // blockStatus̍W`FbNāAω}̏ꍇ͂̕ω}ɑJڂB
        switch(mouseEvent.button) {
        case 3:
			eventBroker.executeCommand(new NodeJumpCommand(-1));
            return true;

        case 1:
            int variationIndex = findVariationIndex(nodeView, blockStatus.getPoint());
            if (variationIndex == -1) {
    			eventBroker.executeCommand(new NodeJumpCommand(+1));
                return true;
            }
            eventBroker.executeCommand(new SelectVariation(variationIndex));

            // eqX^C̏ꍇÂ܂܂PXebvi߂B
            if (nodeView.isChildrenStyle()) {
    			eventBroker.executeCommand(new NodeJumpCommand(+1));
            }
            return true;
        }
        return false;
    }

    /**
	 * sgfPointɊYω}IndexԂ܂B
	 * ω}ꍇAYωȂꍇ
	 * {@link NodeEntity#NO_VARIATION}Ԃ܂B
	 * 
	 * sgfPointnull̏ꍇ(肪ꍇ)pX̒T܂B
	 * ω}|Cgɕꍇ́A݂̕ω}̎̕ω}Ԃ܂B
	 */
	private int findVariationIndex(NodeView nodeView, SgfPoint sgfPoint) {
	    int currentIndex = nodeView.getSelectedVariationIndex();
	    if (currentIndex == NodeEntity.NO_VARIATION) {
	        return NodeEntity.NO_VARIATION;
	    }
	    
	    NodeView variations[] = nodeView.getVariations();
	    for (int i = currentIndex + 1; i < variations.length; i++) {
            if (isMatchMove(sgfPoint, variations[i].getMove().getPoint())) {
                return i;
            }
        }
	    for (int i = 0; i <= currentIndex; i++) {
            if (isMatchMove(sgfPoint, variations[i].getMove().getPoint())) {
                return i;
            }
        }
	    return NodeEntity.NO_VARIATION;
	}
	
	/**
	 * }EX̃|Cgƕω}̒肪A
	 * }EXՂ̊Oŕω}pX薳̂ƂtrueԂ܂B
	 * 
	 * @param mousePoint }EX|CgĂՂ̍W
	 * @param variationPoint ω}̒̔Ղ̍WBω}Ƃnull
	 * @return
	 */
	private boolean isMatchMove(SgfPoint mousePoint, SgfPoint variationPoint) {
	    return Objects.equalsIncludeNull(mousePoint, variationPoint)
	    		|| ((mousePoint == null)
                        && variationPoint.condition().equals(SgfPointType.PASS));
	}

	/* (non-Javadoc)
	 * @see org.unitarou.yukinoshita.view.jface.board.eh.EventDelegator#updateKey(org.unitarou.yukinoshita.model.NodeView, org.unitarou.yukinoshita.events.EventBroker, int)
	 */
	public void updateKey(NodeView nodeView, EventBroker eventBroker, int keyCode) {
		// Ȃ
	}
}
