/*  
 * Copyright 2005 unitarou <boss@unitarou.org>. 
 * All rights reserved.
 * 
 * This program and the accompanying materials are made available under the terms of 
 * the Common Public License v1.0 which accompanies this distribution, 
 * and is available at http://opensource.org/licenses/cpl.php
 * 
 * Contributors:
 *     unitarou - initial API and implementation
 */
package org.unitarou.yukinoshita.view.jface.board.eh;

import org.eclipse.swt.SWT;
import org.eclipse.swt.events.MouseEvent;

import org.unitarou.sgf.SgfId;
import org.unitarou.sgf.type.SgfColor;
import org.unitarou.sgf.util.SgfPointType;
import org.unitarou.util.ArgumentChecker;
import org.unitarou.yukinoshita.events.EventBroker;
import org.unitarou.yukinoshita.model.NodeView;
import org.unitarou.yukinoshita.model.cmd.Command4NodeList;
import org.unitarou.yukinoshita.model.cmd.SetStone;
import org.unitarou.yukinoshita.view.jface.board.BlockStatus;
import org.unitarou.yukinoshita.view.jface.resource.CanvasCursor;

/**
 * {@link org.unitarou.yukinoshita.view.HandlerPhase#SETUP}
 * Ԃ̂Ƃ{@link org.unitarou.yukinoshita.events.EventBroker}
 * s㗝NXłB
 * 
 * @author unitarou &lt;boss@unitarou.org&gt;
 */
public class SetupEventDelegator implements EventDelegator {

    /** ݑIĂ鑀(΂uE΂uE΂͂)̃CfbNXĂ܂B*/
    private int currentTypeIndex_;
    
    /**
     * 
     */
    public SetupEventDelegator() {
        super();
        currentTypeIndex_ = 0;
    }
    
    /* (non-Javadoc)
	 * @see org.unitarou.yukinoshita.view.jface.board.eh.EventDelegator#resetStatus()
	 */
	public void resetStatus() {
		currentTypeIndex_ = 0;
	}

    /* (non-Javadoc)
     * @see org.unitarou.yukinoshita.view.jface.board.eh.EventDelegator#getCursor(org.unitarou.yukinoshita.model.NodeView, org.unitarou.yukinoshita.view.jface.board.BlockStatus)
     */
    public BlockSituation getBlockSituation(NodeView nodeView, BlockStatus blockStatus, MouseEvent mouseEvent) {
        ArgumentChecker.throwIfNull(nodeView, blockStatus);

        BlockSituation ret = new BlockSituation();
        // Ղ̊Oł͖
        if (blockStatus.getPoint() == null) {
            return ret;
        }
        
        switch (currentTypeIndex_) {
        case 0: // ΂u(ɍ΂ꍇ͖B)
            if (!blockStatus.getPointTypes().contains(SgfPointType.BLACK)) {
                ret.setCursor(CanvasCursor.SET_BLACK.getCursor());
                ret.setTransientProperty(SgfId.ADD_BLACK.makeProperty(blockStatus.getPoint()));
            }
            break;

        case 1: // ΂u(ɔ΂ꍇ͖)
            if (!blockStatus.getPointTypes().contains(SgfPointType.WHITE)) {
                ret.setCursor(CanvasCursor.SET_WHITE.getCursor());
                ret.setTransientProperty(SgfId.ADD_WHITE.makeProperty(blockStatus.getPoint()));
            }
            break;
            
        case 2: // ΂͂(΂Ȃꍇ͖B)
            if (blockStatus.getPointTypes().contains(SgfPointType.BLACK)) {
                ret.setCursor(CanvasCursor.SET_BLACK_ERASE.getCursor());
                ret.setTransientProperty(SgfId.ADD_EMPTY.makeProperty(blockStatus.getPoint()));
            } else if (blockStatus.getPointTypes().contains(SgfPointType.WHITE)) {
                ret.setCursor(CanvasCursor.SET_WHITE_ERASE.getCursor());
                ret.setTransientProperty(SgfId.ADD_EMPTY.makeProperty(blockStatus.getPoint()));
            }
            break;

        default:
            assert false;
        }
        return ret;
    }

    /* (non-Javadoc)
     * @see org.unitarou.yukinoshita.view.jface.board.eh.EventDelegator#executeEvent(org.unitarou.yukinoshita.model.NodeView, org.unitarou.yukinoshita.view.jface.board.BlockStatus, org.eclipse.swt.events.MouseEvent, org.unitarou.yukinoshita.events.EventBroker)
     */
    public boolean executeEvent(
            NodeView nodeView, BlockStatus blockStatus, 
            MouseEvent mouseEvent, EventBroker eventBroker) 
    {
        ArgumentChecker.throwIfNull(nodeView, blockStatus, mouseEvent, eventBroker);
        // Ղ̊Oł͖
        if (blockStatus.getPoint() == null) {
            return false;
        }
        
        // {^̂ݑΉ
        if (mouseEvent.button != 1) {
            return false;
        }
        
        SgfColor color = null;
        switch (currentTypeIndex_) {
        case 0: // ΂u(ɍ΂ꍇ͖B)
            if (blockStatus.getPointTypes().contains(SgfPointType.BLACK)) {
                return false;
            }
            color = SgfColor.BLACK;
            break;

        case 1: // ΂u(ɔ΂ꍇ͖)
            if (blockStatus.getPointTypes().contains(SgfPointType.WHITE)) {
                return false;
            }
            color = SgfColor.WHITE;
            break;
            
        case 2: // ΂͂(΂Ȃꍇ͖B)
            if (blockStatus.getPointTypes().contains(SgfPointType.EMPTY)) {
                return false;
            }
            break;

        default:
            assert false;
        }
        Command4NodeList command = new SetStone(blockStatus.getPoint(), color);
        eventBroker.executeCommand(command);
        return true;
    }

    /**
     * SHIFTL[CTRLL[ŕҏWLς܂B
     * 
     * @see org.unitarou.yukinoshita.view.jface.board.eh.EventDelegator#updateKey(NodeView, EventBroker, int)
     */
    public void updateKey(NodeView nodeView, EventBroker eventBroker, int keyCode) {
        switch (keyCode) {
        case SWT.SHIFT:
            --currentTypeIndex_;
        	if (currentTypeIndex_ < 0) {
        	    currentTypeIndex_ = 2;
        	}
        
        	break;
        	
        case SWT.CTRL:
            currentTypeIndex_ = (++currentTypeIndex_) % 3;
        	break;
        }
    }
}
