/*  
 * Copyright 2005 unitarou <boss@unitarou.org>. 
 * All rights reserved.
 * 
 * This program and the accompanying materials are made available under the terms of 
 * the Common Public License v1.0 which accompanies this distribution, 
 * and is available at http://opensource.org/licenses/cpl.php
 * 
 * Contributors:
 *     unitarou - initial API and implementation
 */
package org.unitarou.yukinoshita.view.jface.board.eh;

import java.util.EnumSet;

import org.eclipse.swt.events.MouseEvent;

import org.unitarou.sgf.type.SgfPoint;
import org.unitarou.sgf.util.SgfPointType;
import org.unitarou.util.ArgumentChecker;
import org.unitarou.yukinoshita.events.EventBroker;
import org.unitarou.yukinoshita.model.NodeView;
import org.unitarou.yukinoshita.view.cmd.MoveInProblemCommand;
import org.unitarou.yukinoshita.view.jface.board.BlockStatus;
import org.unitarou.yukinoshita.view.jface.resource.CanvasCursor;

/**
 * {@link org.unitarou.yukinoshita.view.HandlerPhase#SOLVE}
 * Ԃ̂Ƃ{@link org.unitarou.yukinoshita.events.EventBroker}
 * s㗝NXłB
 * 
 * @author unitarou &lt;boss@unitarou.org&gt;
 */
public class SolveEventDelegator implements EventDelegator {

    /**
     * 
     */
    public SolveEventDelegator() {
        super();
    }

    /* (non-Javadoc)
	 * @see org.unitarou.yukinoshita.view.jface.board.eh.EventDelegator#resetStatus()
	 */
	public void resetStatus() {
		// ԂȂ̂ŉȂĂ悢B
	}

    /* (non-Javadoc)
     * @see org.unitarou.yukinoshita.view.jface.board.eh.EventDelegator#getBlockSituation(org.unitarou.yukinoshita.model.NodeView, org.unitarou.yukinoshita.view.jface.board.BlockStatus)
     */
    public BlockSituation getBlockSituation(NodeView nodeView, BlockStatus blockStatus, MouseEvent mouseEvent) {
        ArgumentChecker.throwIfNull(nodeView, blockStatus);
        
        BlockSituation ret = new BlockSituation();
        if (!isValidMovePoint(blockStatus, nodeView)) {
            return ret;
        }
        
        ret.setCursor(CanvasCursor.MOVE.get(nodeView.getNextMoveColor()));
        ret.setTransientProperty(
                nodeView.getNextMoveColor().moveType().makeProperty(blockStatus.getPoint()));
        return ret;
    }

    /* (non-Javadoc)
     * @see org.unitarou.yukinoshita.view.jface.board.eh.EventDelegator#executeEvent(org.unitarou.yukinoshita.model.NodeView, org.unitarou.yukinoshita.view.jface.board.BlockStatus, org.eclipse.swt.events.MouseEvent, org.unitarou.yukinoshita.events.EventBroker)
     */
    public boolean executeEvent(
            NodeView nodeView, BlockStatus blockStatus, 
            MouseEvent mouseEvent, EventBroker eventBroker) 
    {
        ArgumentChecker.throwIfNull(nodeView, blockStatus, mouseEvent, eventBroker);

        
        // Փ̒\_Ń}EXNbN邱ƂŒm 
        if (!isValidMovePoint(blockStatus, nodeView)) {
            return false;
        }
        SgfPoint movePoint = blockStatus.getPoint();
    	eventBroker.executeCommand(new MoveInProblemCommand(movePoint));
        return true;
    }

    /**
     * ̏Ԃ̎ɁA肪\ƂtrueԂ܂B
     * E΂Ȃ(SgfPointType.EMPTY)
     * E֎~n_ł͂Ȃ(!set.contains(SgfPointType.FORBIDDEN))
     * EOł͂Ȃ(blockStatus.getPoint() != nul)
     * E̒肪肵Ă(nodeView.getNextMoveColor() != null)
     * 
     * @param blockStatus
     * @param nodeView
     * @return
     */
    private boolean isValidMovePoint(BlockStatus blockStatus, NodeView nodeView) {
    	EnumSet<SgfPointType> set = blockStatus.getPointTypes();
    	return (set.contains(SgfPointType.EMPTY)
    			&& !set.contains(SgfPointType.FORBIDDEN)
     			&& (blockStatus.getPoint() != null)
     			&& (nodeView.getNextMoveColor() != null));
    }
    /* (non-Javadoc)
     * @see org.unitarou.yukinoshita.view.jface.board.eh.EventDelegator#updateKey(NodeView, EventBroker, int)
     */
    public void updateKey(NodeView nodeView, EventBroker eventBroker, int keyCode) {
        // ɉȂB
    }
}
