/*  
 * Copyright 2005 unitarou <boss@unitarou.org>. 
 * All rights reserved.
 * 
 * This program and the accompanying materials are made available under the terms of 
 * the Common Public License v1.0 which accompanies this distribution, 
 * and is available at http://opensource.org/licenses/cpl.php
 * 
 * Contributors:
 *     unitarou - initial API and implementation
 */
package org.unitarou.yukinoshita.view.jface.board.eh.ver1;



import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.eclipse.swt.SWT;

import org.unitarou.lang.Objects;
import org.unitarou.sgf.PropertyType;
import org.unitarou.util.ArgumentChecker;
import org.unitarou.yukinoshita.events.EventBroker;
import org.unitarou.yukinoshita.model.NodeView;
import org.unitarou.yukinoshita.view.HandlerPhase;
import org.unitarou.yukinoshita.view.cmd.ChangeHandlerPhaseCommand;
import org.unitarou.yukinoshita.view.cmd.NodeJumpCommand;
import org.unitarou.yukinoshita.view.jface.board.IgoBoardPanel;
import org.unitarou.yukinoshita.view.jface.board.eh.BlockSituation;
import org.unitarou.yukinoshita.view.jface.board.eh.CanvasHookedStateHandler;
import org.unitarou.yukinoshita.view.jface.board.eh.EventDelegator;
import org.unitarou.yukinoshita.view.jface.board.eh.LineEventDelegator;
import org.unitarou.yukinoshita.view.jface.board.eh.MarkupEventDelegator;
import org.unitarou.yukinoshita.view.jface.board.eh.SelectEventDelegator;
import org.unitarou.yukinoshita.view.jface.board.eh.SetupEventDelegator;
import org.unitarou.yukinoshita.view.monitor.ControllerStatusMonitor;
import org.unitarou.yukinoshita.view.monitor.NodeMonitor;

/**
 * LmV^Version1.xEditor
 * Cxgnh[łB
 * 
 * @author unitarou &lt;boss@unitarou.org&gt;
 */
public class EditorStateHandlerVer1 extends CanvasHookedStateHandler {
    
    /**
     * ̃NX̃K[łB
     */
	static private final Log log_s_ = LogFactory.getLog(EditorStateHandlerVer1.class);

    
    
    /**
     * L[{[h̘AłŏԂZԂŕςȂ悤ɁA
     * ÕL[R[hێĂ܂B
     */
    private int lastKeyCode_;
    
    private final Adapter adapter_;
   
    
    /**
     * 
     */
    public EditorStateHandlerVer1(IgoBoardPanel igoBoardPanel) {
        super(igoBoardPanel);
        
        registerDelegator(HandlerPhase.SELECT, new SelectEventDelegator());
        registerDelegator(HandlerPhaseVer1.MOVE, new MoveEventDelegatorVer1());
        registerDelegator(HandlerPhaseVer1.VARIATION, new VariationEventDelegatorVer1());
        registerDelegator(HandlerPhase.SETUP, new SetupEventDelegator());
        registerDelegator(HandlerPhase.MARKUP, new MarkupEventDelegator());
        registerDelegator(HandlerPhase.LINE, new LineEventDelegator());
        setEventDelegator(HandlerPhase.SELECT);
        
        lastKeyCode_ = 0;
        adapter_ = new Adapter();
    }

    

    
    /* (non-Javadoc)
     * @see org.unitarou.lang.Adaptable#getAdapter(java.lang.Class)
     */
    public Object getAdapter(Class<?> adapter) {
        if (adapter == null) {
            return null;
        }
        if (adapter.isAssignableFrom(adapter_.getClass())) {
            return adapter_;
        }
        return null;
    }
    
    /**
     * LmV^ver1̓Č邽߁A
     * fR[VAz΁AȊOŏԑJڂ𕪂Ă܂B<br> 
     * ɕω}̑Is܂B
     */
    @Override
	protected void updateKey(int keyCode) {
        if (lastKeyCode_ == keyCode) {
            return;
        }
        EventBroker eventBroker = getEventBroker();
        lastKeyCode_ = keyCode;
        EventDelegator delegator = getEventDelegator();
        if (MarkupEventDelegator.class.equals(delegator.getClass())) {
            switch (keyCode) {
            case SWT.ALT + 'd':
            	eventBroker.executeCommand(new ChangeHandlerPhaseCommand(HandlerPhase.SELECT));
            	break;
            }
            
        } else if (LineEventDelegator.class.equals(delegator.getClass())) {
            switch (keyCode) {
            case SWT.ALT + 's':
            	eventBroker.executeCommand(new ChangeHandlerPhaseCommand(HandlerPhase.SELECT));
            	break;
            }

        } else if (SetupEventDelegator.class.equals(delegator.getClass())) {
            switch (keyCode) {
            case SWT.ALT + 's':
            	eventBroker.executeCommand(new ChangeHandlerPhaseCommand(HandlerPhase.SELECT));
            	break;
            }

        } else {
            switch (keyCode) {
            case SWT.SHIFT:
            	eventBroker.executeCommand(new ChangeHandlerPhaseCommand(HandlerPhaseVer1.MOVE));
            	break;
            	
            case SWT.CTRL + SWT.SHIFT:
            	eventBroker.executeCommand(new ChangeHandlerPhaseCommand(HandlerPhaseVer1.VARIATION));
            	break;
            	
            case SWT.ALT + 's':
            	eventBroker.executeCommand(new ChangeHandlerPhaseCommand(HandlerPhase.SETUP));
            	break;
            	
            case SWT.ALT + 'd':
            	eventBroker.executeCommand(new ChangeHandlerPhaseCommand(HandlerPhase.MARKUP));
            	break;
            	
            case SWT.ALT + 'l':
            	eventBroker.executeCommand(new ChangeHandlerPhaseCommand(HandlerPhase.LINE));
            	break;

            default:
//            	eventBroker.executeCommand(new ChangeHandlerPhaseCommand(HandlerPhase.SELECT));
        		break;
            }
        }
        
        changeVariation(keyCode);
        super.updateKey(keyCode);
        BlockSituation situation 
				= delegator.getBlockSituation(
						getIgoBoardPanel().getNodeView(), getBlockStatus(), getMouseEvent());
        getIgoBoardPanel().getCanvas().setCursor(situation.getCursor());
        getIgoBoardPanel().paintInTransient(situation.getTransientProperty());
    }

    
	/* (non-Javadoc)
	 * @see org.unitarou.yukinoshita.view.jface.board.eh.CanvasHookedStateHandler#mouseWheel(int)
	 */
	@Override
	protected void mouseWheel(int delta) {
		delta = delta / 3;
		if (delta != 0) {
			NodeJumpCommand command = new NodeJumpCommand(delta);
			getEventBroker().executeCommand(command);
		}
	}

	
	private class Adapter implements ControllerStatusMonitor, NodeMonitor {

		private HandlerPhase currentHandlerPhase_;
        /* (non-Javadoc)
         * @see org.unitarou.yukinoshita.view.ControllerStatusMonitor#setEditMode(boolean)
         */
        public void setEditMode(boolean isEditMode) {
            // Ȃ
        }

        /**
         * statusm̗vf̏ꍇ́A
         * {@link HandlerPhase#SELECT}ɂĂ܂B
         * @see org.unitarou.yukinoshita.view.monitor.ControllerStatusMonitor#changeHandlerPhase(org.unitarou.yukinoshita.view.HandlerPhase)
         */
        public void changeHandlerPhase(HandlerPhase status) {
            ArgumentChecker.throwIfNull(status);
            if (status.equals(currentHandlerPhase_)) {
            	return;
            }
            if (findDelegator(status) == null) {
                log_s_.warn("Unknown HandlerStatus, use " + HandlerPhase.SELECT  //$NON-NLS-1$
                        	+" insted. status=" + status); //$NON-NLS-1$
                status = HandlerPhase.SELECT;
            }

            setEventDelegator(status);
            getEventDelegator().resetStatus();

            BlockSituation situation 
            	= getEventDelegator().getBlockSituation(
            	        getIgoBoardPanel().getNodeView(), getBlockStatus(), getMouseEvent());
            getIgoBoardPanel().getCanvas().setCursor(situation.getCursor());
            currentHandlerPhase_ = status;
        }

		/**
		 * NodeView̑ɍ킹āAHandlerPhase؂ւ܂B
		 * 
		 * @see org.unitarou.yukinoshita.view.monitor.NodeMonitor#currentChanged(org.unitarou.yukinoshita.model.NodeView)
		 */
		public void currentChanged(NodeView nodeView) {
			ArgumentChecker.throwIfNull(nodeView);
			
			if (HandlerPhase.SELECT.equals(currentHandlerPhase_)) {
				return;
			}
					
			EventBroker broker = getEventBroker();
			HandlerPhase newPhase = currentHandlerPhase_;
			if (HandlerPhase.LINE.equals(currentHandlerPhase_)) {
				newPhase = currentHandlerPhase_;
				
			} else if (HandlerPhase.MARKUP.equals(currentHandlerPhase_)) {
				newPhase = currentHandlerPhase_;

			} else if (nodeView.containsPropertyType(PropertyType.SETUP)) {
				newPhase = HandlerPhase.SETUP;
				
			} else if (nodeView.containsPropertyType(PropertyType.MOVE) && nodeView.isLast()) {
				newPhase = HandlerPhaseVer1.MOVE;

			} else if (nodeView.containsPropertyType(PropertyType.MOVE) && !nodeView.isLast()) {
				newPhase = HandlerPhaseVer1.VARIATION;
			}
			
			//HandlerPhase؂ւƂʒmB
			if (!Objects.equalsIncludeNull(newPhase, currentHandlerPhase_)) {
				changeHandlerPhase(newPhase);
				broker.executeCommand(new ChangeHandlerPhaseCommand(newPhase));
			}
		}
    }
}
