/*  
 * Copyright 2005 unitarou <boss@unitarou.org>. 
 * All rights reserved.
 * 
 * This program and the accompanying materials are made available under the terms of 
 * the Common Public License v1.0 which accompanies this distribution, 
 * and is available at http://opensource.org/licenses/cpl.php
 * 
 * Contributors:
 *     unitarou - initial API and implementation
 */
package org.unitarou.yukinoshita.view.jface.board.eh.ver1;

import java.util.EnumSet;

import org.eclipse.swt.SWT;
import org.eclipse.swt.events.MouseEvent;

import org.unitarou.sgf.Property;
import org.unitarou.sgf.SgfId;
import org.unitarou.sgf.Value;
import org.unitarou.sgf.type.SgfColor;
import org.unitarou.sgf.type.SgfPoint;
import org.unitarou.sgf.util.SgfPointType;
import org.unitarou.util.ArgumentChecker;
import org.unitarou.yukinoshita.events.EventBroker;
import org.unitarou.yukinoshita.model.NodeView;
import org.unitarou.yukinoshita.model.cmd.AddMove;
import org.unitarou.yukinoshita.model.cmd.Command4NodeList;
import org.unitarou.yukinoshita.model.cmd.RemoveLastNode;
import org.unitarou.yukinoshita.model.cmd.UpdateProperty;
import org.unitarou.yukinoshita.view.jface.board.BlockStatus;
import org.unitarou.yukinoshita.view.jface.board.eh.BlockSituation;
import org.unitarou.yukinoshita.view.jface.board.eh.EventDelegator;
import org.unitarou.yukinoshita.view.jface.resource.CanvasCursor;

/**
 * {@link org.unitarou.yukinoshita.view.jface.board.eh.ver1.HandlerPhaseVer1#MOVE}
 * Ԃ̂Ƃ{@link org.unitarou.yukinoshita.events.EventBroker}
 * s㗝NXłB
 * 
 * @author unitarou &lt;boss@unitarou.org&gt;
 */
class MoveEventDelegatorVer1 implements EventDelegator {

	/**
	 * ̒肪s(ǂłǂ)ɁAIĂԂ܂B
	 */
	private SgfColor selectedColor_;
	
    /**
     * 
     */
    public MoveEventDelegatorVer1() {
        super();
        selectedColor_ = SgfColor.BLACK;
    }

    /* (non-Javadoc)
	 * @see org.unitarou.yukinoshita.view.jface.board.eh.EventDelegator#resetStatus()
	 */
	public void resetStatus() {
		selectedColor_ = SgfColor.BLACK;
	}

	/* (non-Javadoc)
     * @see org.unitarou.yukinoshita.view.jface.board.eh.CursorSelector#get(org.unitarou.yukinoshita.view.jface.board.BlockStatus)
     */
    public BlockSituation getBlockSituation(
    		NodeView nodeView, BlockStatus blockStatus, MouseEvent mouseEvent) 
    {
        ArgumentChecker.throwIfNull(nodeView, blockStatus);
        
        BlockSituation ret = new BlockSituation();
        // ֎~_Ɗɐ΂邩̃`FbN
        EnumSet<SgfPointType> set = blockStatus.getPointTypes();
        if (set.contains(SgfPointType.FORBIDDEN)
                || !set.contains(SgfPointType.EMPTY)
                || !nodeView.isLast()) {
            return ret;
        }
        
        //Ղ̊Ȍꍇ̓pXɂB
        SgfColor nextColor = nodeView.getNextMoveColor();
        if (blockStatus.getPoint() == null) {
            ret.setCursor(CanvasCursor.PASS.get(nextColor));
        } else {
            ret.setCursor(CanvasCursor.MOVE.get(nextColor));
            if (nextColor == null) {
            	nextColor = selectedColor_;
            }
            ret.setTransientProperty(nextColor.moveType().makeProperty(blockStatus.getPoint()));
        }
        return ret;
    }
    
    /* (non-Javadoc)
     * @see org.unitarou.yukinoshita.view.jface.board.eh.CursorSelector#executeEvent(org.unitarou.yukinoshita.view.jface.board.BlockStatus, org.eclipse.swt.events.MouseEvent, org.unitarou.yukinoshita.events.EventBroker)
     */
    public boolean executeEvent(
            NodeView nodeView, BlockStatus blockStatus, 
            MouseEvent mouseEvent, EventBroker eventBroker) 
    {
        ArgumentChecker.throwIfNull(nodeView, blockStatus, mouseEvent, eventBroker);

        /**
         * ŏIm[hB̃m[hłȂꍇɉENbNƃm[h폜
         */
    	if (mouseEvent.button == 3 && nodeView.isLast() && !nodeView.isFirst()) {
    		Command4NodeList command = new RemoveLastNode();
    		eventBroker.executeCommand(command);
            return true;
        }
    	
    	EnumSet<SgfPointType> set = blockStatus.getPointTypes();
        if (set.contains(SgfPointType.FORBIDDEN)
                || !set.contains(SgfPointType.EMPTY)) {
            return false;
        }
        SgfColor next = nodeView.getNextMoveColor();
        if (mouseEvent.button == 1 && nodeView.isLast()) {
            SgfPoint point = blockStatus.getPoint();
            if (point == null) {
                point = SgfPoint.createPass(nodeView.getSize());
            }
            
            if (next == null) {
            	next = selectedColor_;
                Property pl = new Property();
                pl.setId(SgfId.PLAYER_TO_PLAY.id());
                pl.setValue(new Value(next.getString()));
                eventBroker.executeCommand(new UpdateProperty(new Property[0], pl, null));
            }
    	    AddMove command = new AddMove(next, point);
    	    eventBroker.executeCommand(command);
            return true;
        }
        return false;
    }

    /**
     * SHIFTL[CTRLL[ŕҏWLς܂B
     * 
     * @see org.unitarou.yukinoshita.view.jface.board.eh.EventDelegator#updateKey(NodeView, EventBroker, int)
     */
    public void updateKey(NodeView nodeView, EventBroker eventBroker, int keyCode) {
        switch (keyCode) {
        case SWT.SHIFT:
        	selectedColor_ = selectedColor_.opposite();
        	break;
        	
        case SWT.CTRL:
        	selectedColor_ = selectedColor_.opposite();
        	break;
        }
    }
}
