/*  
 * Copyright 2005 unitarou <boss@unitarou.org>. 
 * All rights reserved.
 * 
 * This program and the accompanying materials are made available under the terms of 
 * the Common Public License v1.0 which accompanies this distribution, 
 * and is available at http://opensource.org/licenses/cpl.php
 * 
 * Contributors:
 *     unitarou - initial API and implementation
 */
package org.unitarou.yukinoshita.view.jface.board.eh.ver1;

import org.eclipse.swt.SWT;
import org.eclipse.swt.events.MouseEvent;

import org.unitarou.sgf.Property;
import org.unitarou.sgf.type.SgfColor;
import org.unitarou.sgf.type.SgfPoint;
import org.unitarou.sgf.util.SgfPointType;
import org.unitarou.util.ArgumentChecker;
import org.unitarou.yukinoshita.events.EventBroker;
import org.unitarou.yukinoshita.model.NodeView;
import org.unitarou.yukinoshita.model.cmd.AddVariation;
import org.unitarou.yukinoshita.view.cmd.NodeJumpCommand;
import org.unitarou.yukinoshita.view.jface.board.BlockStatus;
import org.unitarou.yukinoshita.view.jface.board.eh.BlockSituation;
import org.unitarou.yukinoshita.view.jface.board.eh.EventDelegator;
import org.unitarou.yukinoshita.view.jface.resource.CanvasCursor;

/**
 * {@link org.unitarou.yukinoshita.view.jface.board.eh.ver1.HandlerPhaseVer1#VARIATION}
 * Ԃ̂Ƃ{@link org.unitarou.yukinoshita.events.EventBroker}
 * s㗝NXłB
 * 
 * @author unitarou &lt;boss@unitarou.org&gt;
 */
class VariationEventDelegatorVer1 implements EventDelegator {

	/**
	 * ̒肪s(ǂłǂ)ɁAIĂԂ܂B
	 */
	private SgfColor selectedColor_;

	/**
     * 
     */
    public VariationEventDelegatorVer1() {
        super();
        selectedColor_ = SgfColor.BLACK;
    }

    /* (non-Javadoc)
	 * @see org.unitarou.yukinoshita.view.jface.board.eh.EventDelegator#resetStatus()
	 */
	public void resetStatus() {
        selectedColor_ = SgfColor.BLACK;
	}

	/**
     * ω}[hɂ킹J[\Ԃ܂B
     * ̓Iɂ͍ŏIł͕ҏWs({@link CanvasCursor#NORMAL})A
     * ȊOł{@link NodeView#isChildrenStyle()}ɉ
     * ̐FǉJ[\Ԃ܂B
     * 
     * @see org.unitarou.yukinoshita.view.jface.board.eh.CursorSelector#get(org.unitarou.yukinoshita.view.jface.board.BlockStatus)
     */
    public BlockSituation getBlockSituation(
    		NodeView nodeView, BlockStatus blockStatus, MouseEvent mouseEvent) 
    {
        ArgumentChecker.throwIfNull(nodeView, blockStatus);

        BlockSituation ret = new BlockSituation();
        if (nodeView.isChildrenStyle() && nodeView.isLast()) {
            return ret;
        }
        
        SgfPoint sgfPoint = blockStatus.getPoint();
        // ՊȌꍇ̓pX̕ω}ǉ̂Ń`FbNȂ
        if (sgfPoint == null) {
            sgfPoint = SgfPoint.createPass(nodeView.getSize());
            
        } else { // Փ̏ꍇ̂݁A֎~_𒲍B
            SgfPointType type = nodeView.getPointTypes4Variation(blockStatus.getPoint());
            if (type.equals(SgfPointType.FORBIDDEN)) {
                return ret;
            }
        }
        SgfColor sgfColor = nodeView.getOppositeColor();
        ret.setCursor(CanvasCursor.VARIATION.get(sgfColor));
        if (sgfColor == null) {
        	sgfColor = selectedColor_;
        }
        Property property = sgfColor.moveType().makeProperty(sgfPoint);
        ret.setTransientProperty(property);
        return ret;
    }
    

    /* (non-Javadoc)
     * @see org.unitarou.yukinoshita.view.jface.board.eh.CursorSelector#executeEvent(org.unitarou.yukinoshita.view.jface.board.BlockStatus, org.eclipse.swt.events.MouseEvent, org.unitarou.yukinoshita.events.EventBroker)
     */
    public boolean executeEvent(
            NodeView nodeView, BlockStatus blockStatus, 
            MouseEvent mouseEvent, EventBroker eventBroker)
    {
        ArgumentChecker.throwIfNull(nodeView, blockStatus, mouseEvent, eventBroker);

        if (mouseEvent.button != 1) {
            return false;
        }
        if (nodeView.isChildrenStyle() && nodeView.isLast()) {
            return false;
        }

        // ՊȌꍇ̓pX̕ω}ǉ̂Ń`FbNȂ
        if (blockStatus.getPoint() != null) {
            SgfPointType type = nodeView.getPointTypes4Variation(blockStatus.getPoint());
            if (type.equals(SgfPointType.FORBIDDEN)) {
                return false;
            }
        }

        SgfPoint point = blockStatus.getPoint();
        if (point == null) {
            point = SgfPoint.createPass(nodeView.getSize());
        }

        if (nodeView.isChildrenStyle()) {
        	SgfColor sgfColor = nodeView.getNextMoveColor();
        	if (sgfColor == null) {
        		sgfColor = selectedColor_;
        	}
        	eventBroker.executeCommand(new AddVariation(sgfColor, point));

        } else {
        	SgfColor sgfColor = nodeView.getMove().getColor();
        	if (sgfColor == null) {
        		sgfColor = selectedColor_;
        	}
			eventBroker.executeCommand(new NodeJumpCommand(-1));
            eventBroker.executeCommand(new AddVariation(sgfColor, point));
        }
		eventBroker.executeCommand(new NodeJumpCommand(+1));
        return true;
    }
    
    /* (non-Javadoc)
     * @see org.unitarou.yukinoshita.view.jface.board.eh.EventDelegator#updateKey(NodeView, EventBroker, int)
     */
    public void updateKey(NodeView nodeView, EventBroker eventBroker, int keyCode) {
        switch (keyCode) {
        case SWT.SHIFT:
        	selectedColor_ = selectedColor_.opposite();
        	break;
        	
        case SWT.CTRL:
        	selectedColor_ = selectedColor_.opposite();
        	break;
        }
    }
}
