/*  
 * Copyright 2005 unitarou <boss@unitarou.org>. 
 * All rights reserved.
 * 
 * This program and the accompanying materials are made available under the terms of 
 * the Common Public License v1.0 which accompanies this distribution, 
 * and is available at http://opensource.org/licenses/cpl.php
 * 
 * Contributors:
 *     unitarou - initial API and implementation
 */
package org.unitarou.yukinoshita.view.jface.board.mp;

import org.eclipse.jface.util.Geometry;
import org.eclipse.swt.graphics.GC;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.graphics.ImageData;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.graphics.Rectangle;

import org.unitarou.swt.AlphaBlender;
import org.unitarou.swt.Rectangles;
import org.unitarou.swt.Swts;
import org.unitarou.util.ArgumentChecker;

/**
 * @author unitarou &lt;boss@unitarou.org&gt;
 */
abstract class AbstractPainter implements Painter {

    /** ݕێĂC[W̃TCYłB */
    private Point size_;
    
    /**
     * `p̐}`łB
     */
    private ImageData mark_;
    
    /**
     * wux`p̐}`łB
     */
    private ImageData transientMark_;

    /**
     * 
     */
    AbstractPainter() {
        super();
        size_ = null;
        mark_ = null;
        transientMark_ = null;
    }

    /**
     * {@link #createImageData()}ŕԂC[W`悵܂B
     * isTransienttrue̎́ATO߂ŕ`悵܂B
     * 
     * @see org.unitarou.yukinoshita.view.jface.board.mp.Painter#paint(org.eclipse.swt.graphics.GC, org.eclipse.swt.graphics.Rectangle, boolean)
     */
    public void paint(GC gc, Rectangle block, boolean isTransient) {
        ArgumentChecker.throwIfNull(gc, block);
        
        Point newSize = Geometry.getSize(block);
        if (!newSize.equals(size_)) {
            size_ = newSize;
            mark_ = createImageData();
            transientMark_ = AlphaBlender.createTransparent(mark_, 0x80);
        }

        Image img = null;
        Rectangle drawBlock = Rectangles.createScaled(block, 0.95);
        try {
            if (isTransient) {
                img = new Image(null, transientMark_);
            } else {
                img = new Image(null, mark_);
            }
            gc.drawImage(img, drawBlock.x, drawBlock.y);
        } finally {
        	Swts.disposeQuietly(img);
        }
    }
    
    /**
     * ݂̃ubÑTCYԂ܂B
     */
    protected Point getSize() {
        return size_;
    }

    /**
     * `悷C[W쐬܂B
     * {@link ImageData#transparentPixel}Kw肵ĉB
     */
    abstract protected ImageData createImageData();
}
