/* 
 * Copyright 2004, 2005 unitarou <boss@unitarou.org>. 
 * All rights reserved.
 * 
 * This program and the accompanying materials are made available under the terms of 
 * the Common Public License v1.0 which accompanies this distribution, 
 * and is available at http://opensource.org/licenses/cpl.php
 * 
 * Contributors:
 *     unitarou - initial API and implementation
 */
package org.unitarou.yukinoshita.view.jface.board.mp;

import org.eclipse.jface.util.Geometry;
import org.eclipse.swt.SWT;
import org.eclipse.swt.graphics.GC;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.graphics.ImageData;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.graphics.Rectangle;

import org.unitarou.jface.ColorResource;
import org.unitarou.swt.Rectangles;

/**
 * @author unitarou &lt;boss@unitarou.org&gt;
 */
class CrossPainter extends AbstractPainter {

    /** CROSS̋EFł*/
    static private final ColorResource BODY = new ColorResource(0x00, 0x99, 0x00);
    
    /** ߐFł*/
    static private final ColorResource TRANSPARENT = new ColorResource(0x00, 0xFF, 0x00);

    /** W̃TCY(ubN̔A0.4)łB */
    static private double sizeRatio_s_ = 0.4;
    
    /** (ubN̔A0.1)łB */
    static private double lineRatio_s_ = 0.1;
    
    
    static public void setSizeRatio(double newSizeRatio) {
        sizeRatio_s_ = newSizeRatio;
    }
    
    static public double getSizeRatio() {
        return sizeRatio_s_;
    }

    /**
     * 
     */
    CrossPainter() {
        super();
    }

    /* (non-Javadoc)
     * @see org.unitarou.yukinoshita.view.jface.board.mp.AbstractPainter#createImageData()
     */
    @Override
	protected ImageData createImageData() {
        Image img = null;
        GC imgGc = null;
        try {
            Point size = getSize();
            img = new Image(null, size.x, size.y);
            imgGc = new GC(img);

            Rectangle area = Geometry.createRectangle(new Point(0, 0), size);
            area = Rectangles.createScaled(area, sizeRatio_s_);

            imgGc.setBackground(TRANSPARENT.get());
            imgGc.fillRectangle(img.getBounds());
            
            imgGc.setLineWidth(Rectangles.resize(size.x, lineRatio_s_, 1, Integer.MAX_VALUE));
            imgGc.setLineStyle(SWT.LINE_SOLID);
            imgGc.setForeground(BODY.get());
            imgGc.drawLine(area.x, area.y, area.x + area.width, area.y + area.height);
            imgGc.drawLine(area.x + area.width, area.y, area.x, area.y + area.height);

            ImageData ret = img.getImageData();
            //̃sNZ𓧉ߐFɎwB
            ret.transparentPixel = ret.getPixel(0,0);
            return ret;
            
        } finally {
            if (imgGc != null) {
                imgGc.dispose();
            }
            if (img != null) {
                img.dispose();
            }
        }
    }

}
