/* 
 * Copyright 2004, 2005 unitarou <boss@unitarou.org>. 
 * All rights reserved.
 * 
 * This program and the accompanying materials are made available under the terms of 
 * the Common Public License v1.0 which accompanies this distribution, 
 * and is available at http://opensource.org/licenses/cpl.php
 * 
 * Contributors:
 *     unitarou - initial API and implementation
 */
package org.unitarou.yukinoshita.view.jface.board.mp;

import org.eclipse.jface.resource.ColorRegistry;
import org.eclipse.jface.resource.JFaceResources;
import org.eclipse.jface.util.Geometry;
import org.eclipse.swt.graphics.GC;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.graphics.ImageData;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.graphics.RGB;
import org.eclipse.swt.graphics.Rectangle;

import org.unitarou.lang.Classes;
import org.unitarou.swt.Swts;
import org.unitarou.util.ArgumentChecker;

/**
 * DD`悷yC^[łB
 * ƂƔȂ̂ŁA{@link org.unitarou.yukinoshita.view.jface.board.mp.AbstractPainter}Ƃ
 * ʂɎĂ܂B
 * 
 * @author unitarou &lt;boss@unitarou.org&gt;
 */
class DimPointsPainter implements Painter {
    static private ColorRegistry colorRegistry_s_;

    /** DIM_POINTS̔wip̐FL[ł*/
    static public final String CKEY_DIM 
    		= Classes.uniqueKey(DimPointsPainter.class, "CKEY_DIM"); //$NON-NLS-1$
    
    /** At@uhl(0x80)łB */
    static private int alpha_s_ = 0x80;

    static  {
        colorRegistry_s_ = JFaceResources.getColorRegistry();
        colorRegistry_s_.put(CKEY_DIM, new RGB(0x66, 0x33, 0x00));
    }


    static public int getAlpha() {
        return alpha_s_;
    }
    
    static public void setAlpha(int alpha) {
        alpha_s_ = alpha;
    }

    /** 
     * ݂̃nb`O̊Ĝ̂łB
     * {@link #create()}ōXV܂B
     */
    private ImageData dimData_;
    
    /**
     * wux`p̐}`łB
     * {@link #create()}ōXV܂B
     */
    private ImageData transientDimData_;

    /**
     * ݂̃nb`ÕsNZi[܂B
     * {@link #paint(GC, Rectangle)}ōXV܂B
     */
    private Point boxSize_;
    
    public DimPointsPainter() {
        super();
        dimData_ = null;
        transientDimData_ = null;
        boxSize_ = new Point(0,0);
    }
    
    /* (non-Javadoc)
     * @see org.unitarou.yukinoshita.view.jface.board.mp.Painter#paint(org.eclipse.swt.graphics.GC, org.eclipse.swt.graphics.Rectangle, boolean)
     */
    public void paint(GC gc, Rectangle blockArea, boolean isTransient) {
        ArgumentChecker.throwIfNull(gc, blockArea);
        
        Point newBoxSize_ = Geometry.getSize(blockArea);
        
        if (!boxSize_.equals(newBoxSize_)) {
            boxSize_ = newBoxSize_;
            create();
        }
        Image img = null;
        try {
            if (isTransient) {
                img = new Image(null, transientDimData_);
            } else {
                img = new Image(null, dimData_);
            }
            gc.drawImage(img, blockArea.x, blockArea.y);
        } finally {
        	Swts.disposeQuietly(img);
        }
    }

    /**
     * 
     */
    private void create() {
        Image dim = null;
        GC dimGc = null;
        try {
            dim = new Image(null, boxSize_.x, boxSize_.y);
            dimGc = new GC(dim);
            dimGc.setBackground(colorRegistry_s_.get(CKEY_DIM));
            dimGc.fillRectangle(dim.getBounds());
            dimData_ = dim.getImageData();
            dimData_.alpha = alpha_s_;
            
            transientDimData_ = dim.getImageData();
            transientDimData_.alpha = alpha_s_ / 2; // u͎ۂ̕`蓧x{ƂB
            
        } finally {
        	Swts.disposeQuietly(dimGc);
        	Swts.disposeQuietly(dim);
        }
    }
}