/*  
 * Copyright 2005 unitarou <boss@unitarou.org>. 
 * All rights reserved.
 * 
 * This program and the accompanying materials are made available under the terms of 
 * the Common Public License v1.0 which accompanies this distribution, 
 * and is available at http://opensource.org/licenses/cpl.php
 * 
 * Contributors:
 *     unitarou - initial API and implementation
 */
package org.unitarou.yukinoshita.view.jface.board.sp;

import java.util.HashSet;
import java.util.Set;
import java.util.TreeSet;

import org.eclipse.jface.util.Geometry;
import org.eclipse.swt.graphics.GC;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.graphics.ImageData;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.graphics.Rectangle;

import org.unitarou.jface.ColorResource;
import org.unitarou.lang.Strings;
import org.unitarou.sgf.type.SgfColor;
import org.unitarou.sgf.type.SgfPoint;
import org.unitarou.sgf.util.Stone;
import org.unitarou.swt.AlphaBlender;
import org.unitarou.swt.Rectangles;
import org.unitarou.util.ArgumentChecker;
import org.unitarou.yukinoshita.model.NodeView;

/**
 * @author unitarou &lt;boss@unitarou.org&gt; 
 */
abstract public class AbstractStonePainter implements StonePainter {

    /** ߐFŒl0x00FFFFłB */
    static protected final ColorResource COLOR_TRANSPARENT = new ColorResource(0x00, 0xFF, 0xFF);

    /** 
     * Ōɕ`悵΂̃TCY(`)ێ܂B 
     */
    private Point boxSize_;
    
    /** 
     * ݂̍΂̊Ĝ̂łB
     */
    private ImageData blackStone_;

    /** 
     * ݂̉̍΂̊Ĝ̂łB
     */
    private ImageData blackTransitStone_;

    /** 
     * ݂̍΂̊Ĝ̂łB
     */
    private ImageData whiteStone_;

    /** 
     * ݂̉̍΂̊Ĝ̂łB
     */
    private ImageData whiteTransitStone_;
    
    /**
     * {@link #getDurablePaintings(NodeView)}ōXVA
     * ΂̏WłB
     */
    private final Set<SgfPoint> lastBlacks_;

    /**
     * {@link #getDurablePaintings(NodeView)}ōXVA
     * ΂̏WłB
     */
    private final Set<SgfPoint> lastWhites_;

    /**
     * {@link #getDurablePaintings(NodeView)}ōXVA
     * AQn}̏WłB
     */
    private final Set<SgfPoint> lastCaptured_;

    /**
	 * 
	 */
	public AbstractStonePainter() {
		super();
        boxSize_ = new Point(0, 0);
        blackStone_ = null; 
        blackTransitStone_ = null;
        whiteStone_ = null;
        whiteTransitStone_ = null;

        lastBlacks_ = new HashSet<SgfPoint>();
        lastWhites_ = new HashSet<SgfPoint>();
        lastCaptured_ = new HashSet<SgfPoint>();
	}

	/* (non-Javadoc)
	 * @see org.unitarou.yukinoshita.view.jface.board.sp.StonePainter#paintStone(org.eclipse.swt.graphics.GC, org.eclipse.swt.graphics.Rectangle, org.unitarou.yukinoshita.view.jface.board.StonePainterParameter)
	 */
	final public void paintStone(GC gc, Rectangle r, StonePainterParameter parameter) {
        ArgumentChecker.throwIfNull(gc, r, parameter);
        
        r = Rectangles.createScaled(r, 0.95);
        checkAndCreateStones(Geometry.getSize(r));
        Image img = null;
        ImageData transit, stone;
        if (SgfColor.WHITE.equals(parameter.getSgfColor())) {
        	transit = whiteTransitStone_;
        	stone = whiteStone_;
        	
        } else if (SgfColor.BLACK.equals(parameter.getSgfColor())) {
        	transit = blackTransitStone_;
        	stone = blackStone_;
        	
        } else {
        	return;
        }
            
        
        try {
            if (parameter.isTransient()) {
                img = new Image(null, transit);
            } else {
                img = new Image(null, stone);
            }
            gc.drawImage(img, r.x, r.y);
        } finally {
            if (img != null) {
                img.dispose();
            }
        }
        
        
        String mn = parameter.getLabel();
        if (mn != null && !Strings.EMPTY.equals(mn)) {
        	paintLabel(
                    gc, r, parameter.getLabel(), 
                    parameter.getSgfColor(),
                    parameter.isLastMove());
            
        } else if (parameter.isLastMove()) {
        	paintLastMoveMark(gc, r, parameter.getSgfColor());
        } 
	}


	private void checkAndCreateStones(Point newBoxSize) {
        if (!newBoxSize.equals(boxSize_)) {
            boxSize_ = newBoxSize;
            whiteStone_ = createWhiteStone(boxSize_);
            whiteTransitStone_ = AlphaBlender.createTransparent(whiteStone_, 0x80);

            blackStone_ = createBlackStone(boxSize_);
            blackTransitStone_ = AlphaBlender.createTransparent(blackStone_, 0x80);
        }
    }
	
	
	/**
	 * TuNX͔΂boxSizȇ傫ŕ`悵ImageData쐬ĂB
	 */
	abstract protected ImageData createWhiteStone(Point boxSize); 

	/**
	 * TuNX͍΂boxSizȇ傫ŕ`悵ImageData쐬ĂB
	 */
	abstract protected ImageData createBlackStone(Point boxSize); 
	
	/**
	 * TuNXgcgr̘glabelĂB
	 * ȂAcolor͂̉ɂ΂̐FAisLastMove͍ŏȈꍇtrueŌĂяo܂B
	 */
	abstract protected void paintLabel(
			GC gc, Rectangle r, String label, SgfColor color, boolean isLastMove);

	/**
	 * TuNXgcgr̘gɍŏIł邱ƂLĂB
	 * ȂAcolor͂̉ɂ΂̐F܂B
	 */
	abstract protected void paintLastMoveMark (GC gc, Rectangle r, SgfColor color);

	/* (non-Javadoc)
	 * @see org.unitarou.yukinoshita.view.jface.board.BlockPainter#getDurablePaintings(org.unitarou.yukinoshita.model.NodeView)
	 */
	public Set<SgfPoint> getDurablePaintings(NodeView now) {
		ArgumentChecker.throwIfNull(now);
		
		Set<SgfPoint> ret = new HashSet<SgfPoint>();
		
		// O̕`悪ꍇA
		// lastnow̔r_a(last  now) - (last  now)ԂB
		// n}̕ǉ(RÊƂBlockLabelProvider΍)
		Set<SgfPoint> nowBlacks = now.getIgoBoard().position(SgfColor.BLACK);
		Set<SgfPoint> nowWhites = now.getIgoBoard().position(SgfColor.WHITE);
		Set<SgfPoint> nowCaptured = new TreeSet<SgfPoint>();
		for (Stone stone : now.getCaptured(SgfColor.WHITE)) {
			if (stone.isValid()) {
				nowCaptured.add(stone.getPoint());
			}
		}
		for (Stone stone : now.getCaptured(SgfColor.BLACK)) {
			if (stone.isValid()) {
				nowCaptured.add(stone.getPoint());
			}
		}
		
		Set<SgfPoint> tmp = new HashSet<SgfPoint>();
		addUpdateSet(ret, lastCaptured_, nowCaptured, tmp);
		addUpdateSet(ret, lastBlacks_, nowBlacks, tmp);
		addUpdateSet(ret, lastWhites_, nowWhites, tmp);
		return ret;
	}

	private void addUpdateSet(
			Set<SgfPoint> target, Set<SgfPoint> last, Set<SgfPoint> now, Set<SgfPoint> tmp)
	{
		tmp.clear();
		tmp.addAll(last);
		tmp.addAll(now);
		last.retainAll(now);
		tmp.removeAll(last);
		last.clear();
		last.addAll(now);
		target.addAll(tmp);
	}

	/* (non-Javadoc)
	 * @see org.unitarou.yukinoshita.view.jface.board.BlockPainter#getTransientPaintings(org.unitarou.yukinoshita.model.NodeView)
	 */
	public Set<SgfPoint> getTransientPaintings(NodeView nodeView) {
		Set<SgfPoint> ret = new HashSet<SgfPoint>(1);
		if (nodeView.getMove().getPoint() != null) {
			ret.add(nodeView.getMove().getPoint());
		}
		return ret;
	}
}
