/* 
 * Copyright 2004, 2005 unitarou <boss@unitarou.org>. 
 * All rights reserved.
 * 
 * This program and the accompanying materials are made available under the terms of 
 * the Common Public License v1.0 which accompanies this distribution, 
 * and is available at http://opensource.org/licenses/cpl.php
 * 
 * Contributors:
 *     unitarou - initial API and implementation
 */
package org.unitarou.yukinoshita.view.jface.board.sp;

import org.eclipse.swt.SWT;
import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.graphics.GC;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.graphics.ImageData;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.graphics.Rectangle;

import org.unitarou.jface.ColorResource;
import org.unitarou.jface.FontResource;
import org.unitarou.ml.MessageResource;
import org.unitarou.sgf.type.SgfColor;
import org.unitarou.swt.Rectangles;
import org.unitarou.swt.Swts;

/**
 * Ђɂ悤Ȍ݂̂Ȃ΂`悷yC^[łB
 * TODO ΂̑傫(ubN̉p[Zg)p^
 * TODO tHgp^
 * TODO tHgTCYԍɂĕς邩p^
 * 
 * @author unitarou &lt;boss@unitarou.org&gt;
 */
public class SimpleStonePainter extends AbstractStonePainter {
    /** uPFv*/
    static private final MessageResource LB_DISPLAY_NAME
    		= new MessageResource(SimpleStonePainter.class, "lbDisplayName"); //$NON-NLS-1$
    
    /** ΂̒ghԂFŒl0xFFFFFFłB  */
    static private final ColorResource COLOR_WHITE_BODY = new ColorResource(0xFF, 0xFF, 0xFF);
    
    /** ΂̕`悷FŒl0x000000ł */
    static private final ColorResource COLOR_WHITE_BORDER  = new ColorResource(0x00, 0x00, 0x00);

    
    /** ΂̒ԍ̐FŒl0x000000łB */
    static private final ColorResource COLOR_WHITE_NUMBER  = new ColorResource(0x00, 0x00, 0x00);

    
    /** ΂̒ghԂFŒl0x000000łB */
    static private final ColorResource COLOR_BLACK_BODY = new ColorResource(0x00, 0x00, 0x0);
    
    /** ΂̕`悷FŒl0x000000łB */
    static private final ColorResource COLOR_BLACK_BORDER = new ColorResource(0x00, 0x00, 0x0);

    /** ΂̒ԍ̐FŒl0xFFFFFFłB */
    static private final ColorResource COLOR_BLACK_NUMBER  = new ColorResource(0xFF, 0xFF, 0xFF);
    
    /** ŏIۂ̒ԍ̐FŒl0xFF0000łB*/
    static private final ColorResource COLOR_LAST_NUMBER  = new ColorResource(0xFF, 0x00, 0x00);
    
    /** ŏIׂ̋L̐FŒl0xCC0000łB*/
    static private final ColorResource COLOR_LAST = new ColorResource(0xCC, 0x00, 0x00);
    
    /** ΂̏ɍڂ鐔ɗptHg\[XłB */
    static private final FontResource FONT_MOVE_NUMBER = new FontResource("Helvetica", 10, SWT.BOLD); //$NON-NLS-1$
    
    /**
     * 
     */
    public SimpleStonePainter() {
        super();
    }

	/* (non-Javadoc)
	 * @see org.unitarou.yukinoshita.view.provider.Provider#getDisplayName()
	 */
	public String displayName() {
		return LB_DISPLAY_NAME.get();
	}

	/* (non-Javadoc)
	 * @see org.unitarou.yukinoshita.view.jface.board.sp.AbstractStonePainter#createWhiteStone(org.eclipse.swt.graphics.Point)
	 */
	@Override
	protected ImageData createWhiteStone(Point boxSize) {
		return createStoneImage(boxSize, COLOR_WHITE_BODY.get(), COLOR_WHITE_BORDER.get());
	}



	/* (non-Javadoc)
	 * @see org.unitarou.yukinoshita.view.jface.board.sp.AbstractStonePainter#createBlackStone(org.eclipse.swt.graphics.Point)
	 */
	@Override
	protected ImageData createBlackStone(Point boxSize) {
		return createStoneImage(boxSize, COLOR_BLACK_BODY.get(), COLOR_BLACK_BORDER.get());
	}


    /**
     * @param color
     * @param color2
     */
    private ImageData createStoneImage(Point boxSize_, Color body, Color border) {
        Image img = null;
        GC imgGc = null;
        try {
            img = new Image(null, boxSize_.x, boxSize_.y);
            imgGc = new GC(img);

            imgGc.setBackground(COLOR_TRANSPARENT.get());
            imgGc.fillRectangle(img.getBounds());

            imgGc.setBackground(body);
            imgGc.fillOval(0, 0, boxSize_.x, boxSize_.y);

            imgGc.setLineWidth(1);
            imgGc.setLineStyle(SWT.LINE_SOLID);
            imgGc.setForeground(border);
            imgGc.drawOval(0, 0, boxSize_.x - 1, boxSize_.y - 1);
            
            ImageData ret = img.getImageData();
            //̃sNZ𓧉ߐFɎwB
            ret.transparentPixel = ret.getPixel(0,0);
            return ret;
            
        } finally {
        	Swts.disposeQuietly(imgGc);
        	Swts.disposeQuietly(img);
        }
    }

	/* (non-Javadoc)
	 * @see org.unitarou.yukinoshita.view.jface.board.sp.AbstractStonePainter#paintLabel(org.eclipse.swt.graphics.GC, org.eclipse.swt.graphics.Rectangle, java.lang.String, org.unitarou.sgf.type.SgfColor, boolean)
	 */
	@Override
	protected void paintLabel(GC gc, Rectangle r, String label, SgfColor color, boolean isLastMove) {
        gc.setFont(FONT_MOVE_NUMBER.getInCircle(gc, label, r.width));
        //TODO vQtextExtentĂł̂Ŗ
        Point p = gc.textExtent(label);
        Color fontColor;
        if (isLastMove) {
        	fontColor = COLOR_LAST_NUMBER.get(); 
        } else {
        	fontColor = SgfColor.BLACK.equals(color) ? COLOR_BLACK_NUMBER.get() : COLOR_WHITE_NUMBER.get(); 
        }
        gc.setForeground(fontColor);
        gc.drawText(label, r.x + r.width / 2 - p.x / 2, r.y + r.height / 2 - p.y / 2, true);
	}



	/* (non-Javadoc)
	 * @see org.unitarou.yukinoshita.view.jface.board.sp.AbstractStonePainter#paintLastMoveMark(org.eclipse.swt.graphics.GC, org.eclipse.swt.graphics.Rectangle, org.unitarou.sgf.type.SgfColor)
	 */
	@Override
	protected void paintLastMoveMark(GC gc, Rectangle r, SgfColor color) {
        gc.setLineWidth(2);
        gc.setLineStyle(SWT.LINE_SOLID);
        gc.setBackground(COLOR_LAST.get());
        Rectangle lastrect = Rectangles.createScaled(r, 0.4);
        gc.fillOval(lastrect.x, lastrect.y, lastrect.width, lastrect.height);
	}
}
