/*  
 * Copyright 2005 unitarou <boss@unitarou.org>. 
 * All rights reserved.
 * 
 * This program and the accompanying materials are made available under the terms of 
 * the Common Public License v1.0 which accompanies this distribution, 
 * and is available at http://opensource.org/licenses/cpl.php
 * 
 * Contributors:
 *     unitarou - initial API and implementation
 */
package org.unitarou.yukinoshita.view.jface.board.sp;

import org.unitarou.sgf.type.SgfColor;

/**
 * {@link org.unitarou.yukinoshita.view.jface.board.sp.StonePainter}
 * ɗp`p[^łB
 * @author unitarou &lt;boss@unitarou.org&gt;
 */
public class StonePainterParameter {
    
	/**
	 * `悷΂̐FłB
	 */
	private SgfColor sgfColor_;
	
    /**
     * ԍȂǃx\ꍇɐݒ肵܂B<br>
     * 󕶎w肷ƕ`悵܂B
     */
    private String label_;
    
    /**
     * trueɐݒ肷ƍŏI}[N`悵܂B
     */
    private boolean isLastMove_;
    
    /**
     * trueɐݒ肷Ǝb蒅ƂĔȂǂŕ`悵܂B
     */
    private boolean isTransient_;

    /**
     * 
     */
    public StonePainterParameter() {
        super();
        sgfColor_ = null;
        label_ = null;
        isLastMove_ = false;
        isTransient_ = false;
    }

    /**
	 * @return Returns the sgfColor.
	 */
	public SgfColor getSgfColor() {
		return sgfColor_;
	}

	/**
     * @return Returns the isLastMove.
     */
    public boolean isLastMove() {
        return isLastMove_;
    }
    /**
     * @return Returns the isTransient.
     */
    public boolean isTransient() {
        return isTransient_;
    }
    /**
     * @return Returns the moveNumber.
     */
    public String getLabel() {
        return label_;
    }
    
    /**
	 * @param sgfColor The sgfColor to set.
	 */
	public void setSgfColor(SgfColor sgfColor) {
		sgfColor_ = sgfColor;
	}

	/**
     * @param isLastMove The isLastMove to set.
     */
    public void setLastMove(boolean isLastMove) {
        isLastMove_ = isLastMove;
    }
    /**
     * @param isTransient The isTransient to set.
     */
    public void setTransient(boolean isTransient) {
        isTransient_ = isTransient;
    }
    /**
     * @param moveNumber The moveNumber to set.
     */
    public void setLabel(String moveNumber) {
        label_ = moveNumber;
    }
}
