/*  
 * Copyright 2005 unitarou <boss@unitarou.org>. 
 * All rights reserved.
 * 
 * This program and the accompanying materials are made available under the terms of 
 * the Common Public License v1.0 which accompanies this distribution, 
 * and is available at http://opensource.org/licenses/cpl.php
 * 
 * Contributors:
 *     unitarou - initial API and implementation
 */
package org.unitarou.yukinoshita.view.jface.dlg;

import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;

import org.eclipse.swt.SWT;
import org.eclipse.swt.events.PaintEvent;
import org.eclipse.swt.events.PaintListener;
import org.eclipse.swt.graphics.GC;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.graphics.Rectangle;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Shell;

import org.unitarou.jface.FontResource;
import org.unitarou.jface.ImageResource;
import org.unitarou.lang.Runtimes;
import org.unitarou.ml.MessageResource;
import org.unitarou.yukinoshita.Yukinoshita;

/**
 * o[W\邽߂̃_CAOłB
 * 
 * @author unitarou &lt;boss@unitarou.org&gt;
 */
public class AboutDialog {

	/** LmV^ɂ */
	static private final MessageResource NT_ABOUT_YUKINOSHITA
			= new MessageResource(AboutDialog.class, "ntAboutYukinoshita"); //$NON-NLS-1$

	/** Yukinoshita version: */
	static private final MessageResource LB_YUKI_VERSION
			= new MessageResource(AboutDialog.class, "lbYukiVersion"); //$NON-NLS-1$
	
	/** Last update: */
	static private final MessageResource LB_YUKI_UPDATE
			= new MessageResource(AboutDialog.class, "lbYukiUpdate"); //$NON-NLS-1$

	/** SWT: */
	static private final MessageResource LB_SWT_VERSION
			= new MessageResource(AboutDialog.class, "lbSwtVersion"); //$NON-NLS-1$

	/** Available memory: */
	static private final MessageResource LB_AVAILABLE_MEMORY
			= new MessageResource(AboutDialog.class, "lbAvailableMemory"); //$NON-NLS-1$

	
	/** ʂɕ\oi[łB*/
    static private final ImageResource BANNER 
    		= new ImageResource(AboutDialog.class, "banner.png"); //$NON-NLS-1$ 
    
    static private final FontResource FONT_VERSION
    		= new FontResource("Helvetica", 10, SWT.BOLD); //$NON-NLS-1$
 
    /**
     * {@link AboutDialog#statusList_}ŕێ^NXłB 
     */
    static private class Status {
        private final String label_;
        private final String value_;
        private Point labelSize_;
        private Status(String label, String value) {
            super();
            label_ = label;
            value_ = value;
        }
    }
    
    /**
     * \Xe[^XɊ֘Aێ郊XgłB
     * ^[{@link AboutDialog.Status}]łB
     */
    private final List<AboutDialog.Status> statusList_;

    /**
     * 
     */
    public AboutDialog() {
        super();
        statusList_ = new ArrayList<AboutDialog.Status>();
    }
    
    /**
     * _CAO\܂B
     */
    public void open() {
        setStatus();
        Shell shell =  
            	new Shell(Display.getCurrent().getActiveShell(), 
            	        	SWT.APPLICATION_MODAL | SWT.DIALOG_TRIM);
        try {
            createShell(shell);
            shell.open();
            while(!shell.isDisposed()) {
                shell.getDisplay().sleep();
                shell.getDisplay().readAndDispatch();
            }
        } finally {
            if (shell != null) {
                shell.dispose();
            }
        }
    }
    
    private void setStatus() {
        statusList_.clear();
        statusList_.add(new Status(LB_YUKI_VERSION.get(), Yukinoshita.instance().getVersion()));
        statusList_.add(new Status(LB_YUKI_UPDATE.get(), Yukinoshita.instance().getLastUpdate()));
        statusList_.add(new Status(LB_SWT_VERSION.get(), String.valueOf(SWT.getVersion())));
        statusList_.add(new Status(LB_AVAILABLE_MEMORY.get(), 
                		String.valueOf(Runtimes.byteToMegabyte(Runtimes.availableMemory())) + "MB [" //$NON-NLS-1$
                		+ String.valueOf(Runtimes.byteToMegabyte(Runtime.getRuntime().totalMemory()))
                		+ "MB used]")); //$NON-NLS-1$
        
    }
    
    private void createShell(Shell shell) {
        // W𒼐ڎw肷̂ŃCAEg͎gȂ
        shell.setText(NT_ABOUT_YUKINOSHITA.get());
        Label image = new Label(shell, SWT.NONE);
        image.setImage(BANNER.get());
        image.setBounds(image.getImage().getBounds());
        image.addPaintListener(new PaintListener() {
            public void paintControl(PaintEvent e) {
                paintLabel(e.gc);
            }
        });
        shell.pack();
        setLocation(shell);
    }
    
    /**
     * shellDisplay̘gɎ܂͈͓
     * eWindow̒ɎĂ܂B
     */
    private void setLocation(Shell shell) {
        Point pSize = shell.getParent().getSize();
        Point pLocation = shell.getParent().getLocation();
        Point size = shell.getSize();
        Point location = new Point((pSize.x - size.x) / 2 + pLocation.x,
                					(pSize.y - size.y) / 2 + pLocation.y);
        Rectangle displayBounds = Display.getCurrent().getBounds();

        // _CAODisplayőSĕ\ł悤ɁA
        // locationw肳ꂽg(0`displayBounds - size)Ɏ߂ĂB
        location.x = Math.min(Math.max(location.x, 0), displayBounds.width - size.x);
        location.y = Math.min(Math.max(location.y, 0), displayBounds.height - size.y);

        shell.setLocation(location);                			
    }
    
    private void paintLabel(GC gc) {
        gc.setFont(FONT_VERSION.get());
        
        // ɂ邽߂ɁAx̍őTCY߂ĂB
        Point size = new Point(0, 0);
        for (Iterator ip = statusList_.iterator(); ip.hasNext(); ) {
            Status status = (Status)ip.next();
            status.labelSize_ = gc.stringExtent(status.label_); 
            size.x = Math.max(size.x, status.labelSize_.x);
            size.y = Math.max(size.y, status.labelSize_.y);
        }
        
        // ۂ̕`
        int y = 80;
        for (Iterator ip = statusList_.iterator(); ip.hasNext(); ) {
            Status status = (Status)ip.next();
            // x͉E
            gc.drawString(status.label_, 5 + size.x - status.labelSize_.x, y, true);
            
            // l͍񂹁A4̓}[W
            gc.drawString(status.value_, 5 + size.x + 4, y, true);
            y = y + size.y;
        }
    }
}
