/*  
 * Copyright 2005 unitarou <boss@unitarou.org>. 
 * All rights reserved.
 * 
 * This program and the accompanying materials are made available under the terms of 
 * the Common Public License v1.0 which accompanies this distribution, 
 * and is available at http://opensource.org/licenses/cpl.php
 * 
 * Contributors:
 *     unitarou - initial API and implementation
 */
package org.unitarou.yukinoshita.view.jface.dlg;

import java.io.File;

import org.eclipse.jface.dialogs.IDialogConstants;
import org.eclipse.jface.dialogs.TitleAreaDialog;
import org.eclipse.jface.viewers.ILabelProviderListener;
import org.eclipse.jface.viewers.IStructuredContentProvider;
import org.eclipse.jface.viewers.ITableLabelProvider;
import org.eclipse.jface.viewers.TableViewer;
import org.eclipse.jface.viewers.Viewer;
import org.eclipse.swt.SWT;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Table;
import org.eclipse.swt.widgets.TableColumn;

import org.unitarou.lang.Strings;
import org.unitarou.ml.MessageResource;
import org.unitarou.sgf.Collection;
import org.unitarou.sgf.RootGameTree;
import org.unitarou.sgf.SgfId;
import org.unitarou.sgf.type.GameType;
import org.unitarou.util.ArgumentChecker;
import org.unitarou.yukinoshita.FileManager;
import org.unitarou.yukinoshita.Yukinoshita;
import org.unitarou.yukinoshita.view.GameFrameController;
import org.unitarou.yukinoshita.view.provider.rgtlp.RootGameTreeLabelProvider;

/**
 * {@link org.unitarou.yukinoshita.view.GameFrameController}
 * 󂯎AύXĂEĂȂGameTreëꗗ\
 * [Uɕۑ𑣂_CAOłB
 * 
 * @author unitarou &lt;boss@unitarou.org&gt;
 */
public class AskSaveDialog extends TitleAreaDialog {
	/** u㏑ۑvƂɕԂIDłB */
    static public final int SAVE_ID = IDialogConstants.CLIENT_ID;

    /** uʖŕۑvƂɕԂIDłB */
    static public final int SAVEAS_ID = IDialogConstants.CLIENT_ID + 1;
    
    /** uύXĵŕۑȂvƂɕԂIDłB */
    static public final int NOSAVE_ID = IDialogConstants.CLIENT_ID + 2;
    
    /** uLZvƂɕԂIDłBv */
    static public final int CANCEL_ID = IDialogConstants.CANCEL_ID;


	/** ut@C̕ۑmFv */
	static private final MessageResource LB_CONFIRM_SAVE_FILE
			= new MessageResource(AskSaveDialog.class, "lbConfirmSaveFile"); //$NON-NLS-1$

	/** u͕ҏWĂ܂Bۑ܂Hv */
	static private final MessageResource LB_ASK_SAVE_FILE 
			= new MessageResource(AskSaveDialog.class, "lbAskSaveFile"); //$NON-NLS-1$

	/** ut@CFg{0}hv */
	static private final MessageResource LB_SAVE_FILE_PATH 
			= new MessageResource(AskSaveDialog.class, "lbSaveFilePath"); //$NON-NLS-1$

	/** u(VKt@C)v */
	static private final MessageResource LB_NEW_FILE
			= new MessageResource(AskSaveDialog.class, "lbNewFile"); //$NON-NLS-1$

	/** u㏑ۑ(&S)v */
	static private final MessageResource CLB_SAVE 
			= new MessageResource(AskSaveDialog.class, "clbSave"); //$NON-NLS-1$

	/** uʖŕۑ(&A)v */
	static private final MessageResource CLB_SAVEAS 
			= new MessageResource(AskSaveDialog.class, "clbSaveAs"); //$NON-NLS-1$

	/** uύXĵŕۑȂ(&N)v */
	static private final MessageResource CLB_NOSAVE 
			= new MessageResource(AskSaveDialog.class, "clbNoSave"); //$NON-NLS-1$

	/** uLZ(&C)v */
	static private final MessageResource CLB_CANCEL
			= new MessageResource(AskSaveDialog.class, "clbCancel"); //$NON-NLS-1$

	/** u*vL */
	static private final MessageResource LB_CHANGE_MARK
			= new MessageResource(AskSaveDialog.class, "lbChangeMark"); //$NON-NLS-1$

	/** u(Ȃ)v */
	static private final MessageResource LB_NO_NAME
			= new MessageResource(AskSaveDialog.class, "lbNoName"); //$NON-NLS-1$

	/** uNo.v */
	static private final MessageResource LB_NUMBER
			= new MessageResource(AskSaveDialog.class, "lbNumber"); //$NON-NLS-1$

	/** uύXv */
	static private final MessageResource LB_CHANGE
			= new MessageResource(AskSaveDialog.class, "lbChange"); //$NON-NLS-1$

	/** uv */
	static private final MessageResource LB_GAME
			= new MessageResource(AskSaveDialog.class, "lbGame"); //$NON-NLS-1$

	/** {^̕\񐔂ݒ肵܂(W2) */
    static private final int COLS_BUTTON = 2;
    
    /** ۑΏۂƂȂCollectionǗController */
    private final GameFrameController gfc_;
    
    /**
     * ̒iKgfcƑΉt@CXibvVbgƁA
     * iK̃XibvVbgrāA
     * قꍇ͏㏑ۑ֎~܂B
     * 
     * @param parentShell
     * @param gfc
     * @throws org.unitarou.lang.NullArgumentException controllernull̏ꍇ
     */
    public AskSaveDialog(Shell parentShell, GameFrameController gfc) {
        super(parentShell);
        setShellStyle(SWT.TITLE | SWT.RESIZE | SWT.APPLICATION_MODAL);
        ArgumentChecker.throwIfNull(parentShell, gfc);
        gfc_ = gfc;
        if (!FileManager.instance().checkOverwritable(gfc_.getCollection())) {
        	gfc_.getCollection().setFile(null);
        }
    }
    
    
    
    /**
     * @see org.eclipse.jface.window.Window#createContents(org.eclipse.swt.widgets.Composite)
     */
    @Override
	protected Control createContents(Composite parent) {
        File file = gfc_.getCollection().getFile();
        String filePath = (file != null) ? file.getPath() : LB_NEW_FILE.get();
        Control control = super.createContents(parent);
        setTitle(LB_ASK_SAVE_FILE.get());
        setMessage(LB_SAVE_FILE_PATH.get(filePath));
        Shell shell = getShell();
        shell.setText(LB_CONFIRM_SAVE_FILE.get());
        int height = Math.min(gfc_.getCollection().size() * 10 + 200, 320); // 200--320
        shell.setSize(480,height);//TODO }WbNio[
        return control;
    }
    
    
    
    /* (non-Javadoc)
     * @see org.eclipse.jface.dialogs.Dialog#createDialogArea(org.eclipse.swt.widgets.Composite)
     */
    @Override
	protected Control createDialogArea(Composite parent) {
        Composite composite = (Composite)super.createDialogArea(parent);
        
        TableViewer tableViewer = new TableViewer(composite, SWT.FULL_SELECTION);
        tableViewer.setContentProvider(new CollectionContentsProvider());
        tableViewer.setLabelProvider(new CollectionLabelProvier());

        Table table = tableViewer.getTable();
        table.setLayoutData(new GridData(GridData.FILL_BOTH));
        table.setHeaderVisible(true);
        table.setLinesVisible(true);
        
        new TableColumn(table, SWT.LEFT).setText(LB_CHANGE.get());
        new TableColumn(table, SWT.CENTER).setText(LB_NUMBER.get());
        new TableColumn(table, SWT.CENTER).setText(SgfId.GAME_TYPE.displayName());
        new TableColumn(table, SWT.LEFT).setText(LB_GAME.get());
        tableViewer.setInput(gfc_);

        TableColumn[] columns = table.getColumns();
        for (int i = 0; i < columns.length; ++i) {
            columns[i].pack();
        }
        return composite;
    }
    /**
     * {^̈s̕\񐔂{@link #COLS_BUTTON}ɌŒ肵܂B
     * 
     * @see org.eclipse.jface.dialogs.Dialog#createButton(org.eclipse.swt.widgets.Composite, int, java.lang.String, boolean)
     */
    @Override
	protected Button createButton(Composite parent, int id, String label, boolean defaultButton) {
        Button button = super.createButton(parent, id, label, defaultButton);
        ((GridLayout)parent.getLayout()).numColumns = COLS_BUTTON;
        return button;
    }
    
    /* (non-Javadoc)
     * @see org.eclipse.jface.dialogs.Dialog#createButtonsForButtonBar(org.eclipse.swt.widgets.Composite)
     */
    @Override
	protected void createButtonsForButtonBar(Composite parent) {
        // ㏑ۑFileCX^X݂ꍇ̂EnableɂB
        Button button = createButton(parent, SAVE_ID, CLB_SAVE.get(), false);
        button.setEnabled(gfc_.getCollection().getFile() != null);

        createButton(parent, SAVEAS_ID, CLB_SAVEAS.get(), true);
        createButton(parent, NOSAVE_ID, CLB_NOSAVE.get(), false);
        createButton(parent, CANCEL_ID, CLB_CANCEL.get(), false);
    }
    
    
    /* (non-Javadoc)
     * @see org.eclipse.jface.dialogs.Dialog#buttonPressed(int)
     */
    @Override
	protected void buttonPressed(int buttonId) {
        setReturnCode(buttonId);
        close();
    }

    private class CollectionContentsProvider implements IStructuredContentProvider {

        /* (non-Javadoc)
         * @see org.eclipse.jface.viewers.IStructuredContentProvider#getElements(java.lang.Object)
         */
        public Object[] getElements(Object inputElement) {
            GameFrameController gfc = (GameFrameController)inputElement;
            
            // W̏ꍇ͓WJĂl͕\ȂB
            if (GameType.DRILL.equals(
            		gfc.getCollectionEditor().getCollection().get(0).getGameType())) 
            {
                return new Integer[]{new Integer(0)};
            }
            Integer[] ret = new Integer[gfc.getCollection().size()];
            for (int i = 0; i < ret.length; ++i) {
                ret[i] = new Integer(i);
            }
            return ret;
        }

        /* (non-Javadoc)
         * @see org.eclipse.jface.viewers.IContentProvider#dispose()
         */
        public void dispose() {
            // Ȃ
            
        }

        /* (non-Javadoc)
         * @see org.eclipse.jface.viewers.IContentProvider#inputChanged(org.eclipse.jface.viewers.Viewer, java.lang.Object, java.lang.Object)
         */
        public void inputChanged(Viewer viewer, Object oldInput, Object newInput) {
            // Ȃ
        }
    }
    
    private class CollectionLabelProvier implements ITableLabelProvider {

        /* (non-Javadoc)
         * @see org.eclipse.jface.viewers.ITableLabelProvider#getColumnImage(java.lang.Object, int)
         */
        public Image getColumnImage(Object element, int columnIndex) {
            return null;
        }

        /* (non-Javadoc)
         * @see org.eclipse.jface.viewers.ITableLabelProvider#getColumnText(java.lang.Object, int)
         */
        public String getColumnText(Object element, int columnIndex) {
            int index = ((Number)element).intValue();
    	    Collection collection = gfc_.getCollection();
    	    RootGameTreeLabelProvider provider = 
    	    		Yukinoshita.context().getProvider(
    	    					RootGameTreeLabelProvider.class, collection);
            RootGameTree rgt = collection.get(index);
            switch (columnIndex) {
    			case 0:
    			    boolean[] flags = gfc_.getChangedFlags();
    			    return flags[index] ? LB_CHANGE_MARK.get() : Strings.EMPTY;

    			case 1: 
            	    return String.valueOf(index + 1);

            	case 2:
            	    return rgt.getGameType().displayName();


        		case 3:
            	    String gn = provider.getLabel(rgt);
            	    return Strings.EMPTY.equals(gn) ? LB_NO_NAME.get() : gn;

            }
            return Strings.EMPTY;
        }

        /* (non-Javadoc)
         * @see org.eclipse.jface.viewers.IBaseLabelProvider#addListener(org.eclipse.jface.viewers.ILabelProviderListener)
         */
        public void addListener(ILabelProviderListener listener) {
            // Ȃ
            
        }

        /* (non-Javadoc)
         * @see org.eclipse.jface.viewers.IBaseLabelProvider#dispose()
         */
        public void dispose() {
            // Ȃ
        }

        /* (non-Javadoc)
         * @see org.eclipse.jface.viewers.IBaseLabelProvider#isLabelProperty(java.lang.Object, java.lang.String)
         */
        public boolean isLabelProperty(Object element, String property) {
            return false;
        }

        /* (non-Javadoc)
         * @see org.eclipse.jface.viewers.IBaseLabelProvider#removeListener(org.eclipse.jface.viewers.ILabelProviderListener)
         */
        public void removeListener(ILabelProviderListener listener) {
            // Ȃ
        }
    }
}
