/*  
 * Copyright 2005 unitarou <boss@unitarou.org>. 
 * All rights reserved.
 * 
 * This program and the accompanying materials are made available under the terms of 
 * the Common Public License v1.0 which accompanies this distribution, 
 * and is available at http://opensource.org/licenses/cpl.php
 * 
 * Contributors:
 *     unitarou - initial API and implementation
 */
package org.unitarou.yukinoshita.view.jface.dlg;

import java.net.MalformedURLException;
import java.net.URI;
import java.net.URISyntaxException;
import java.net.URL;

import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.eclipse.jface.dialogs.IDialogConstants;
import org.eclipse.jface.dialogs.TitleAreaDialog;
import org.eclipse.swt.SWT;
import org.eclipse.swt.events.ModifyEvent;
import org.eclipse.swt.events.ModifyListener;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.layout.FillLayout;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.layout.RowLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Combo;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Group;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.ProgressBar;
import org.eclipse.swt.widgets.Shell;

import org.unitarou.lang.Exceptions;
import org.unitarou.lang.Strings;
import org.unitarou.ml.MessageResource;
import org.unitarou.sgf.Collection;
import org.unitarou.sgf.io.dl.HttpDownloadEvent;
import org.unitarou.sgf.io.dl.HttpDownloader;
import org.unitarou.sgf.io.dl.HttpDownloaderException;
import org.unitarou.sgf.io.dl.HttpDownloaderListener;
import org.unitarou.yukinoshita.Yukinoshita;
import org.unitarou.yukinoshita.Application.MessageLevel;

/**
 * URLw肵ăt@C_E[hA
 * {@link org.unitarou.sgf.Collection}쐬_CAOłB
 * 
 * @author unitarou &lt;boss@unitarou.org&gt; 
 */
public class DownloadDialog extends TitleAreaDialog {
	static private final Log log_s_ = LogFactory.getLog(DownloadDialog.class);
	
	/**uWebTCgǂݍށv*/
	static private final MessageResource LB_LOAD_FROM_WEB_SITE
			= new MessageResource(DownloadDialog.class, "lbLoadFromWebSite"); //$NON-NLS-1$
	
	/**u_E[hURLw肵ĂBv*/
	static private final MessageResource MSG_SPECIFY_URL_FOR_DOWNLOAD
			= new MessageResource(DownloadDialog.class, "msgSpecifyUrlForDownload"); //$NON-NLS-1$

	/**u_E[hURLw肵܂(http://`)Bv*/
	static private final MessageResource NT_TOOL_TIP_SPECIFY_URL
			= new MessageResource(DownloadDialog.class, "ntToolTipSpecifyUrl"); //$NON-NLS-1$
	
	/**uURL:v*/
	static private final MessageResource LB_URL
			= new MessageResource(DownloadDialog.class, "lbUrl"); //$NON-NLS-1$
	
	/**utB^[:v*/
	static private final MessageResource LB_FILTER
			= new MessageResource(DownloadDialog.class, "lbFilter"); //$NON-NLS-1$

	/**uʁv*/
	static private final MessageResource LB_AUTO_DETECT
			= new MessageResource(DownloadDialog.class, "lbAutoDetect"); //$NON-NLS-1$

	/**uXe[^X:v*/
	static private final MessageResource LB_STATUS
			= new MessageResource(DownloadDialog.class, "lbStatus"); //$NON-NLS-1$

	/**u_E[hɎs܂Bv*/
	static private final MessageResource NT_DOWNLOAD_ERROR
			= new MessageResource(DownloadDialog.class, "ntDownloadError"); //$NON-NLS-1$
	
	/**u_E[hf[^Ɋ񂪌܂łBv*/
	static private final MessageResource MSG_NO_CONTENTS
			= new MessageResource(DownloadDialog.class, "msgNoContents"); //$NON-NLS-1$
	
	/**u_E[hɃlbg[NG[܂B\nڍׂȌF{0}v*/
	static private final MessageResource MSG_NETWORK_ERROR
			= new MessageResource(DownloadDialog.class, "msgNetworkError"); //$NON-NLS-1$

	private Combo urlCombo_;
	private Button autoDetectButton_;
	private Combo filterCombo_;
	private Label statusLabel_;
	private ProgressBar progressBar_;
	
	private HttpDownloader[] downloaders_;
	private String url_;
	
	private Collection collection_;
	
	private DownloadThread downloadThread_;

	/**
	 * @param parentShell
	 */
	public DownloadDialog(Shell parentShell) {
		super(parentShell);
		downloaders_ = new HttpDownloader[0];
		url_ = Strings.EMPTY;
		downloadThread_ = null;
        setShellStyle(SWT.TITLE | SWT.RESIZE | SWT.APPLICATION_MODAL);
    }
	
	/* (non-Javadoc)
	 * @see org.eclipse.jface.dialogs.Dialog#createButtonsForButtonBar(org.eclipse.swt.widgets.Composite)
	 */
	@Override
	protected void createButtonsForButtonBar(Composite parent) {
		super.createButtonsForButtonBar(parent);
		getButton(IDialogConstants.OK_ID).setEnabled(false);
	}

	/* (non-Javadoc)
	 * @see org.eclipse.jface.dialogs.TitleAreaDialog#createDialogArea(org.eclipse.swt.widgets.Composite)
	 */
	@Override
	protected Control createDialogArea(Composite parent) {
		Composite areaBase = (Composite)super.createDialogArea(parent);
		Composite area = new Composite(areaBase, SWT.NONE);
		area.setLayoutData(new GridData(SWT.FILL, SWT.TOP, true, false));
		createUrlArea(area);
		createFilterArea(area);
		createStatusArea(area);
		setTitle(LB_LOAD_FROM_WEB_SITE.get());
		setMessage(MSG_SPECIFY_URL_FOR_DOWNLOAD.get());
		return areaBase;
	}
	
	
	private void createUrlArea(Composite area) {
		area.setLayout(new GridLayout(2, false));
		Label urlLabel = new Label(area, SWT.NONE);
		urlLabel.setText(LB_URL.get());
		urlLabel.setLayoutData(new GridData(SWT.RIGHT, SWT.BOTTOM, false, false));
		
		urlCombo_ = new Combo(area, SWT.DROP_DOWN);
		urlCombo_.setLayoutData(new GridData(SWT.FILL, SWT.BOTTOM, true, false));
		urlCombo_.setToolTipText(NT_TOOL_TIP_SPECIFY_URL.get());
		urlCombo_.add("http://"); //$NON-NLS-1$
		urlCombo_.select(0);
		urlCombo_.addModifyListener(new ModifyListener() {
			public void modifyText(ModifyEvent e) {
				updateFilterSelection();
				checkValidUrl();
			}
		});
	}
	
	/**
	 * ݂URLɍvtB^[I܂B
	 * autoDetectButton_falsȅꍇ͉܂B
	 */
	private void updateFilterSelection() {
		if (!autoDetectButton_.getSelection()) {
			return;
		}
		
		url_ = urlCombo_.getText();
		int index = 0;
		int point = downloaders_[index].matches(url_);
		for (int i = 1; i < downloaders_.length; ++i) {
			int p = downloaders_[i].matches(url_);
			if (point < p) {
				index = i;
				point = p;
			}
		}
		filterCombo_.select(index);
	}
	
	/**
	 * {@link #urlCombo_}`IɃ`FbN
	 */
	private void checkValidUrl() {
		try {
			new URL(urlCombo_.getText());
			new URI(urlCombo_.getText());
			getButton(IDialogConstants.OK_ID).setEnabled(true);
			
		} catch (MalformedURLException e) {
			getButton(IDialogConstants.OK_ID).setEnabled(false);

		} catch (URISyntaxException e) {
			getButton(IDialogConstants.OK_ID).setEnabled(false);
	 	}
	}
	
	private void createFilterArea(Composite area) {
		Label filterLabel = new Label(area, SWT.NONE);
		filterLabel.setText(LB_FILTER.get());
		GridData gdFilter = new GridData(SWT.RIGHT, SWT.TOP, false, false);
		gdFilter.verticalIndent = 8;
		filterLabel.setLayoutData(gdFilter);
		Group group = new Group(area, SWT.SHADOW_IN);
		group.setLayoutData(new GridData(SWT.LEFT, SWT.TOP, false, true));
		group.setLayout(new RowLayout(SWT.VERTICAL));

		autoDetectButton_ = new Button(group, SWT.CHECK);
		autoDetectButton_.setText(LB_AUTO_DETECT.get());
		autoDetectButton_.setSelection(true);
		autoDetectButton_.addSelectionListener(new SelectionAdapter() {
			/* (non-Javadoc)
			 * @see org.eclipse.swt.events.SelectionAdapter#widgetSelected(org.eclipse.swt.events.SelectionEvent)
			 */
			@Override
			public void widgetSelected(SelectionEvent e) {
				filterCombo_.setEnabled(!autoDetectButton_.getSelection());
				updateFilterSelection();
			}
		});
		
		filterCombo_ = new Combo(group, SWT.READ_ONLY | SWT.DROP_DOWN);
		filterCombo_.setEnabled(false);
		
		downloaders_ = Yukinoshita.context().getProviders(HttpDownloader.class);
		for (HttpDownloader downloader : downloaders_) {
			filterCombo_.add(downloader.displayName());
		}
		filterCombo_.select(0);
	}

	
	private void createStatusArea(Composite area) {
		Label label = new Label(area, SWT.NONE);
		label.setText(LB_STATUS.get());
		GridData gdFilter = new GridData(SWT.RIGHT, SWT.TOP, false, false);
		gdFilter.verticalIndent = 8;
		label.setLayoutData(gdFilter);
		
		Group group = new Group(area, SWT.SHADOW_IN);
		group.setLayoutData(new GridData(SWT.FILL, SWT.TOP, true, true));
		group.setLayout(new FillLayout(SWT.VERTICAL));
		
		statusLabel_ = new Label(group, SWT.NONE);
		progressBar_ = new ProgressBar(group, SWT.HORIZONTAL);
		progressBar_.setMinimum(0);
		progressBar_.setMaximum(100);
		progressBar_.setSelection(0);
	}

	/* (non-Javadoc)
	 * @see org.eclipse.jface.dialogs.Dialog#buttonPressed(int)
	 */
	@Override
	protected void buttonPressed(int buttonId) {
		if (buttonId == IDialogConstants.CANCEL_ID) {
			downloadThread_ = null;
			super.buttonPressed(buttonId);
			return;
		}
		url_ = urlCombo_.getText();
		getButton(IDialogConstants.OK_ID).setEnabled(false);
		downloadThread_ = new DownloadThread(downloaders_[filterCombo_.getSelectionIndex()]);
		downloadThread_.start();
	}
	
	/**
	 * @return
	 */
	public Collection getCollection() {
		return collection_;
	}
	
	/**
	 * SWT̎dlwidgitւ̃bZ[W͓ĂKv̂ł̑΍B
	 */
	private void syncShowMessageDialog(
			final MessageLevel level, 
			final String title, 
			final String message) 
	{
		if (downloadThread_ == null) {
			return;
		}
		Display.getDefault().syncExec(new Runnable() {
			public void run() {
		    	Yukinoshita.application().openMessageDialog(level, title , message);
			}
		});
	}

	/**
	 * SWT̎dlwidgitւ̃bZ[W͓ĂKv̂ł̑΍B
	 */
	private void syncStatusLabelUpdate(final String text) {
		if (downloadThread_ == null) {
			return;
		}
		Display.getDefault().syncExec(new Runnable() {
			public void run() {
				DownloadDialog.this.statusLabel_.setText(text);
			}
		});
	}

	/**
	 * SWT̎dlwidgitւ̃bZ[W͓ĂKv̂ł̑΍B
	 */
	private void syncIncrementProgressBar(final int delta) {
		if (downloadThread_ == null) {
			return;
		}
		Display.getDefault().syncExec(new Runnable() {
			public void run() {
				int count = DownloadDialog.this.progressBar_.getSelection();
				count = (count + delta) % DownloadDialog.this.progressBar_.getMaximum();
				DownloadDialog.this.progressBar_.setSelection(count);
			}
		});
	}

	/**
	 * SWT̎dlwidgitւ̃bZ[W͓ĂKv̂ł̑΍B
	 * @param buttonId
	 */
	private void syncButtonPressed(final int buttonId) {
		if (downloadThread_ == null) {
			return;
		}
		Display.getDefault().syncExec(new Runnable() {
			public void run() {
				DownloadDialog.super.buttonPressed(buttonId);
			}
		});
	}
	
	
	/**
	 * _E[hʃXbhŊJn܂B
	 * IƁA{@link org.eclipse.jface.dialogs.Dialog#buttonPressed(int)}
	 * {@link org.eclipse.jface.dialogs.IDialogConstants#OK_ID}w肵
	 * ĂяoƂŃ_CAO悤Ƃ܂B
	 */
	private class DownloadThread extends Thread {

		private HttpDownloader downloader_;
		private DownloadThread(HttpDownloader downloader) {
			assert downloader != null;
			
			downloader_ = downloader;
		}
		/* (non-Javadoc)
		 * @see java.lang.Thread#run()
		 */
		@Override
		public void run() {
			downloader_.addListener(new HttpDownloaderListener() {
				public void changeStatus(HttpDownloadEvent event) {
					syncStatusLabelUpdate(event.getStatus());
					syncIncrementProgressBar(event.getDelta());
				}
			});
			try {
				collection_ = downloader_.download(url_);
				if (collection_ != null && collection_.size() != 0) {
					syncButtonPressed(IDialogConstants.OK_ID);
					return;
				}
				syncShowMessageDialog(
	        			MessageLevel.INFORMATION,
	        			NT_DOWNLOAD_ERROR.get(),
	        			MSG_NO_CONTENTS.get());
			} catch (HttpDownloaderException e) {
				log_s_.info(Exceptions.getRootMessage(e));
				syncShowMessageDialog(
		    			MessageLevel.WARNING,
		    			NT_DOWNLOAD_ERROR.get(),
		    			MSG_NETWORK_ERROR.get(Exceptions.getRootMessage(e)));
			}
		}
		
	}
}