/*  
 * Copyright 2005 unitarou <boss@unitarou.org>. 
 * All rights reserved.
 * 
 * This program and the accompanying materials are made available under the terms of 
 * the Common Public License v1.0 which accompanies this distribution, 
 * and is available at http://opensource.org/licenses/cpl.php
 * 
 * Contributors:
 *     unitarou - initial API and implementation
 */
package org.unitarou.yukinoshita.view.jface.dlg;


import java.io.File;
import java.util.ArrayList;
import java.util.List;
import java.util.StringTokenizer;

import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.eclipse.jface.dialogs.Dialog;
import org.eclipse.jface.dialogs.IDialogConstants;
import org.eclipse.swt.SWT;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Combo;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Text;

import org.unitarou.jface.FileFolderListener;
import org.unitarou.jface.FilesTableViewer;
import org.unitarou.jface.FolderListener;
import org.unitarou.jface.FolderTreeViewer;
import org.unitarou.lang.Strings;
import org.unitarou.ml.MessageResource;
import org.unitarou.swt.USashForm;
import org.unitarou.util.ArgumentChecker;
import org.unitarou.yukinoshita.Yukinoshita;
import org.unitarou.yukinoshita.context.CurrentContext;
import org.unitarou.yukinoshita.context.IntContextValue;
import org.unitarou.yukinoshita.view.jface.util.WidgetFactory;

/**
 * GNXv[ɋ߂X^C̃t@C_CAOłB
 * 
 * @author unitarou &lt;boss@unitarou.org&gt; 
 */
class ExplorerLikeFileChooser extends Dialog implements IgoFileChooser {
	
	static private final Log log_s_ = LogFactory.getLog(ExplorerLikeFileChooser.class);
	
	/**
	 * _CAO̕肷ReLXgL[łB
	 * ftHgł640pxłB
	 */
	static private final IntContextValue DLG_WIDTH 
			= new IntContextValue(ExplorerLikeFileChooser.class, "dlgWidth", 200, 640, 1000); //$NON-NLS-1$

	/**
	 * _CAO̍肷ReLXgL[łB
	 * ftHgł480pxłB
	 */
	static private final IntContextValue DLG_HEIGHT
			= new IntContextValue(ExplorerLikeFileChooser.class, "dlgHeight",100, 400, 1000); //$NON-NLS-1$
	
	/**
	 * tH_IGA̕肷ReLXgL[łB
	 * ftHgł200pxłB
	 */
	static private final IntContextValue FOLDER_WIDTH
			= new IntContextValue(ExplorerLikeFileChooser.class, "folderWidth",100, 200, 1000); //$NON-NLS-1$
	
	/**
	 * Ղ̕肷ReLXgL[łB
	 * ftHgł200pxłB
	 */
	static private final IntContextValue BOARD_WIDTH
			= new IntContextValue(ExplorerLikeFileChooser.class, "boardWidth",100, 200, 1000); //$NON-NLS-1$
	
	/** t@C(&N): */
	static private final MessageResource CLB_FILENAME 
			= new MessageResource(ExplorerLikeFileChooser.class, "clbFilename"); //$NON-NLS-1$
	
	/** t@C̎(&T): */
	static private final MessageResource CLB_FILETYPE
			= new MessageResource(ExplorerLikeFileChooser.class, "clbFiletype"); //$NON-NLS-1$
	
	/** J(&O) */
	static private final MessageResource CLB_OPEN
			= new MessageResource(ExplorerLikeFileChooser.class, "clbOpen"); //$NON-NLS-1$

	/** ۑ(&S) */
	static private final MessageResource CLB_SAVE
			= new MessageResource(ExplorerLikeFileChooser.class, "clbSave"); //$NON-NLS-1$

	/** LZ */
	static private final MessageResource LB_CANCEL
			= new MessageResource(ExplorerLikeFileChooser.class, "lbCancel"); //$NON-NLS-1$

	/** uJvƂɕԂIDłB */
    static private final int OPEN_ID = IDialogConstants.CLIENT_ID;

    /** uۑvƂɕԂIDłB */
    static private final int SAVE_ID = IDialogConstants.CLIENT_ID;
    
    /** uLZvƂɕԂIDłBv */
    static private final int CANCEL_ID = IDialogConstants.CANCEL_ID;
    
    /** t@CeLXg{bNXł̃f~^łB*/
    static private final String DELIMITER = "\""; //$NON-NLS-1$
    
    /**
     * _CAOŌɊJƂ̃[gێ܂B
     */
    static private File lastRoot_s_ = null;
    
    /**
     * _CAOŌɊJƂ̃tH_[ێ܂B
     */
    static private File lastFolder_s_ = null;
    
    /**
     * 
     */
    private final Style style_;
    
    /**
     * _CAÕCێt[łB 
     */
    private Composite frame;
	/**
	 * fBNgc[\
	 * {@link org.eclipse.jface.viewers.TreeViewer}bvĂ܂B
	 */
	private final FolderTreeViewer folderTreeViewer_;

	
	/**
	 * t@CXg\
	 * {@link org.eclipse.jface.viewers.TableViewer}bvĂ܂B
	 */
	private final FilesTableViewer filesTableViewer_;
	
	
	/**
	 * ̃t@CɂăAEgC\plłB
	 */
	private final FilesOutlinePanel collectionOutlinePanel_;

	/**
	 * t@C(̏ꍇ̓_uNH[e[Vf~^)
	 * i[eLXgGAłB
	 */
	private Text txFilename_;
	
	
	/**
	 * t@CtB^[i[R{łB
	 */
	private Combo coFilter_;
	
	
	
	/**
	 * _CAO\t@CtB^[łB
	 */
	private NamedFileFilter[] fileFilters_;
	
	/**
	 * ŏIʂƂȂt@CłB
	 */
	private File[] files_;
	
	
	/**
	 * @throws org.unitarou.lang.NullArgumentException null̏ꍇ
	 * @throws IllegalArgumentException styleSWT.OPEN, SWT.SAVE, SWT.MULTIȊOݒ肵ꍇB 
	 */
	public ExplorerLikeFileChooser(Shell parent, Style style) {
		super(parent);
		ArgumentChecker.throwIfNull(parent, style);
        setShellStyle(SWT.TITLE | SWT.RESIZE | SWT.APPLICATION_MODAL);
        style_ = style;
        folderTreeViewer_ = new FolderTreeViewer();
        folderTreeViewer_.addListener(new FolderTreeListener());
        filesTableViewer_ = new FilesTableViewer(SWT.MULTI | SWT.BORDER | SWT.FULL_SELECTION);
        filesTableViewer_.addListener(new FileListListener());
        collectionOutlinePanel_ = new FilesOutlinePanel(1);// 
        txFilename_ = null;
        coFilter_ = null;
        fileFilters_ = new NamedFileFilter[0];
        files_ = new File[0];
        create();
	}
	
	
	
	/* (non-Javadoc)
	 * @see org.eclipse.jface.dialogs.Dialog#createDialogArea(org.eclipse.swt.widgets.Composite)
	 */
	@Override
	protected Control createDialogArea(Composite parent) {
		ArgumentChecker.throwIfNull(parent);
		frame = (Composite)super.createDialogArea(parent);
		GridData gridData = (GridData)frame.getLayoutData();

		CurrentContext context = Yukinoshita.context().getCurrent(null);
		gridData.widthHint = context.getInteger(DLG_WIDTH);
		gridData.heightHint = context.getInteger(DLG_HEIGHT);
		
		USashForm sashForm = WidgetFactory.createUSashForm(frame, SWT.HORIZONTAL);
		gridData = new GridData(SWT.FILL, SWT.FILL, true, true);
		sashForm.setLayoutData(gridData);
		folderTreeViewer_.createContents(sashForm);
		
		
		Composite filesFrame = new Composite(sashForm, SWT.NONE);
		filesFrame.setLayout(new GridLayout(2, false));

		// t@Ce[uƃAEgC̍쐬
		USashForm sash = WidgetFactory.createUSashForm(filesFrame, SWT.HORIZONTAL);
		gridData = new GridData(SWT.FILL, SWT.FILL, true, true);
		gridData.horizontalSpan = 2;
		sash.setLayoutData(gridData);
		filesTableViewer_.createContents(sash);
		collectionOutlinePanel_.createContents(sash);
		sash.setWeights(new int[]{1, -context.getInteger(BOARD_WIDTH)});
		sash.setDragMinimums(new int[]{0, BOARD_WIDTH.minInt()});

		txFilename_ = createFilenameText(filesFrame);
		createFiletypeCombo(filesFrame);

		sashForm.setWeights(new int[] {-context.getInteger(FOLDER_WIDTH), 1});
		
		if (lastRoot_s_ != null) {
			folderTreeViewer_.setRoot(lastRoot_s_);
		}
		if (lastFolder_s_ != null) {
			folderTreeViewer_.setFolder(lastFolder_s_);
			filesTableViewer_.setFolder(lastFolder_s_);
		} 
		return frame;
	}
	
	/**
	 * t@C̕ҏWGÃEBWbg쐬܂B
	 * @param parent
	 */
	private Text createFilenameText(Composite parent) {
		assert parent != null;
		
		Label label = new Label(parent, SWT.NONE);
		label.setText(CLB_FILENAME.get());
		label.setLayoutData(new GridData(SWT.RIGHT, SWT.TOP, false, false));
		Text text = new Text(parent, SWT.BORDER);
		text.setLayoutData(new GridData(SWT.FILL, SWT.TOP, true, false));
		return text;
	}
	
	/**
	 * t@C^Cv̑IGÃEBWbg쐬܂B
	 * @param parent
	 */
	private void createFiletypeCombo(Composite parent) {
		assert parent != null;
		
		Label lb3 = new Label(parent, SWT.NONE);
		lb3.setText(CLB_FILETYPE.get());
		lb3.setLayoutData(new GridData(SWT.RIGHT, SWT.TOP, false, false));
		coFilter_ = new Combo(parent, SWT.READ_ONLY);
		coFilter_.setLayoutData(new GridData(SWT.FILL, SWT.TOP, true, false));
		coFilter_.addSelectionListener(new CoFilterListener());
		updateFilter();
	}


	/* (non-Javadoc)
     * @see org.eclipse.jface.dialogs.Dialog#createButtonsForButtonBar(org.eclipse.swt.widgets.Composite)
     */
    @Override
	protected void createButtonsForButtonBar(Composite parent) {
    	if (style_.equals(Style.SAVE_FILE)) {
            createButton(parent, SAVE_ID, CLB_SAVE.get(), true);
    	} else {
            createButton(parent, OPEN_ID, CLB_OPEN.get(), true);
    	}
        createButton(parent, CANCEL_ID, LB_CANCEL.get(), false);
    }
    
    /* (non-Javadoc)
     * @see org.eclipse.jface.dialogs.Dialog#buttonPressed(int)
     */
    @Override
	protected void buttonPressed(int buttonId) {
    	lastRoot_s_ = folderTreeViewer_.getRoot();
		lastFolder_s_ = filesTableViewer_.getFolder();
		log_s_.debug("lastRoot_s_:" + lastRoot_s_); //$NON-NLS-1$
		log_s_.debug("lastFolder_s_:" + lastFolder_s_); //$NON-NLS-1$

		CurrentContext context = Yukinoshita.context().getCurrent(null);
		Point point = frame.getSize();
		context.setInteger(DLG_WIDTH.id(), point.x);
		context.setInteger(DLG_HEIGHT.id(), point.y);
		context.setInteger(FOLDER_WIDTH.id(), folderTreeViewer_.getControl().getSize().x);
		context.setInteger(BOARD_WIDTH.id(), collectionOutlinePanel_.getControl().getSize().x);

		setReturnCode(buttonId);
        if (buttonId == CANCEL_ID) {
        	close();
        	return;
        }
        
        File folder = filesTableViewer_.getFolder();
		List<File> filenameList = new ArrayList<File>();
		StringTokenizer tokenizer = new StringTokenizer(txFilename_.getText(), DELIMITER);
		while (tokenizer.hasMoreTokens()) {
			String token = tokenizer.nextToken().trim();
			if (token.length() != 0) {
				filenameList.add(new File(folder, token));
			}
		}
		files_ = filenameList.toArray(new File[filenameList.size()]);
		close();
    }

	/* (non-Javadoc)
	 * @see org.unitarou.yukinoshita.view.jface.dlg.IgoFileChooser#open()
	 */
	public boolean chooseFile() {
		return (open() != CANCEL_ID) && (files_.length != 0);
	}

	/* (non-Javadoc)
	 * @see org.unitarou.yukinoshita.view.jface.dlg.IgoFileChooser#getFolder()
	 */
	public File getFolder() {
		return filesTableViewer_.getFolder();
	}

	/* (non-Javadoc)
	 * @see org.unitarou.yukinoshita.view.jface.dlg.IgoFileChooser#getFile()
	 */
	public File getFile() {
		return (files_.length != 0) ? files_[0] : null;
	}

	/* (non-Javadoc)
	 * @see org.unitarou.yukinoshita.view.jface.dlg.IgoFileChooser#getFiles()
	 */
	public File[] getFiles() {
		File[] ret = new File[files_.length];
		System.arraycopy(files_, 0, ret, 0, ret.length);
		return ret;
	}
	/* (non-Javadoc)
	 * @see org.unitarou.yukinoshita.view.jface.dlg.IgoFileChooser#setFile(java.io.File)
	 */
	public void setFile(File file) {
		ArgumentChecker.throwIfNull(file);
		
		files_ = new File[1];
		files_[0] = file;
	}

	/* (non-Javadoc)
	 * @see org.unitarou.yukinoshita.view.jface.dlg.IgoFileChooser#setFileName(java.lang.String)
	 */
	public void setFileName(String filename) {
		ArgumentChecker.throwIfNull(filename);
		txFilename_.setText(filename);
	}

	/* (non-Javadoc)
	 * @see org.unitarou.yukinoshita.view.jface.dlg.IgoFileChooser#setFolder(java.io.File)
	 */
	public void setFolder(File file) {
		ArgumentChecker.throwIfNull(file);
		if (!file.isDirectory()) {
			throw new IllegalArgumentException("Argument must be directory: " + file); //$NON-NLS-1$
		}
		folderTreeViewer_.setFolder(file);
		filesTableViewer_.setFolder(file);
	}

	/* (non-Javadoc)
	 * @see org.unitarou.yukinoshita.view.jface.dlg.IgoFileChooser#setFilter(org.unitarou.yukinoshita.view.jface.dlg.NamedFileFilter[])
	 */
	public void setFilter(NamedFileFilter[] filters) {
		fileFilters_ = new NamedFileFilter[filters.length];
		System.arraycopy(filters, 0, fileFilters_, 0, fileFilters_.length);
		if (coFilter_ != null) {
			updateFilter();
		}
	}
	
    /**
	 * 
	 */
	private void updateFilter() {
		coFilter_.removeAll();
		for (NamedFileFilter filter : fileFilters_) {
			coFilter_.add(filter.displayName());
		}
		if (fileFilters_.length != 0) {
			coFilter_.select(0);
			filesTableViewer_.setFileFilter(fileFilters_[0]);
		}
	}


	/* (non-Javadoc)
	 * @see org.unitarou.yukinoshita.view.jface.dlg.IgoFileChooser#getParent()
	 */
	public Shell getParent() {
		// TODO Auto-generated method stub
		return null;
	}


	/* (non-Javadoc)
	 * @see org.unitarou.yukinoshita.view.jface.dlg.IgoFileChooser#getStyle()
	 */
	public Style getStyle() {
		return style_;
	}


	/* (non-Javadoc)
	 * @see org.unitarou.yukinoshita.view.jface.dlg.IgoFileChooser#getText()
	 */
	public String getText() {
		return getShell().getText();
	}


	/* (non-Javadoc)
	 * @see org.unitarou.yukinoshita.view.jface.dlg.IgoFileChooser#setText(java.lang.String)
	 */
	public void setText(String title) {
		ArgumentChecker.throwIfNull(title);
		
		getShell().setText(title);
	}

	/**
	 * {@link ExplorerLikeFileChooser#folderTreeViewer_}p̃Xi[łB
	 */
	private class FolderTreeListener implements FolderListener {

		/* (non-Javadoc)
		 * @see org.unitarou.jface.FolderListener#folderChanged(java.io.File)
		 */
		public void folderChanged(File newFolder) {
			filesTableViewer_.setFolder(newFolder);
		}
	}

	/**
	 * {@link ExplorerLikeFileChooser#filesTableViewer_}p̃Xi[łB
	 */
	private class FileListListener implements FileFolderListener {

		/* (non-Javadoc)
		 * @see org.unitarou.jface.FileFolderListener#filesFocused(java.io.File[])
		 */
		public void filesFocused(File[] focused) {
			ArgumentChecker.throwIfNull((Object)focused);
			
			// fBNgǂݎs\̃t@C菜
			List<File> filtered = new ArrayList<File>(focused.length);
			for (File file : focused) {
				if (file.isFile() && file.canRead()) {
					filtered.add(file);
				}
			}
			
			File[] files = filtered.toArray(new File[filtered.size()]);
						
			collectionOutlinePanel_.setFiles(files);
			switch (files.length) {
			case 0:
				txFilename_.setText(Strings.EMPTY);
				break;

			case 1:
				txFilename_.setText(files[0].getName());
				break;

			default:
				StringBuilder builder = new StringBuilder();
				for (File file : files) {
					builder.append(DELIMITER).append(file.getName()).append(DELIMITER).append(" ");  //$NON-NLS-1$
				}
				txFilename_.setText(builder.toString());
			}
		}

		/* (non-Javadoc)
		 * @see org.unitarou.jface.FileFolderListener#filesDoubleClicked(java.io.File)
		 */
		public void filesDoubleClicked(File clicked) {
			// TODO Auto-generated method stub
			
		}

		/* (non-Javadoc)
		 * @see org.unitarou.jface.FolderListener#folderChanged(java.io.File)
		 */
		public void folderChanged(File newFolder) {
			folderTreeViewer_.setFolder(newFolder);
		}
	}
	
	private class CoFilterListener extends SelectionAdapter {

		/* (non-Javadoc)
		 * @see org.eclipse.swt.events.SelectionAdapter#widgetSelected(org.eclipse.swt.events.SelectionEvent)
		 */
		@Override
		public void widgetSelected(SelectionEvent e) {
			int index = coFilter_.getSelectionIndex();
			if (index != -1) {
				filesTableViewer_.setFileFilter(fileFilters_[index]);
			}
		}
		
	}
}
