/*  
 * Copyright 2005 unitarou <boss@unitarou.org>. 
 * All rights reserved.
 * 
 * This program and the accompanying materials are made available under the terms of 
 * the Common Public License v1.0 which accompanies this distribution, 
 * and is available at http://opensource.org/licenses/cpl.php
 * 
 * Contributors:
 *     unitarou - initial API and implementation
 */
package org.unitarou.yukinoshita.view.jface.dlg;

import java.io.File;
import java.lang.reflect.InvocationTargetException;
import java.util.ArrayList;
import java.util.List;

import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.jface.dialogs.ProgressMonitorDialog;
import org.eclipse.jface.operation.IRunnableWithProgress;
import org.eclipse.jface.util.Geometry;
import org.eclipse.swt.SWT;
import org.eclipse.swt.custom.ScrolledComposite;
import org.eclipse.swt.events.ControlAdapter;
import org.eclipse.swt.events.ControlEvent;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.layout.FillLayout;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;

import org.unitarou.ml.MessageResource;
import org.unitarou.sgf.Collection;
import org.unitarou.sgf.RootGameTree;
import org.unitarou.sgf.io.CollectionRepository;
import org.unitarou.swt.WidgetContainer;
import org.unitarou.util.ArgumentChecker;
import org.unitarou.util.StopWatch;
import org.unitarou.yukinoshita.view.jface.board.IgoOutlinePanel;
import org.unitarou.yukinoshita.view.provider.rgtlp.RootGameTreeLabelProvider;

/**
 * {@link org.unitarou.sgf.Collection}ɂăAEgC\plłB
 * ̓Iɂ̓Obh
 * {@link org.unitarou.yukinoshita.view.jface.board.IgoOutlinePanel}zu܂B
 * 
 * @author unitarou &lt;boss@unitarou.org&gt; 
 */
public class FilesOutlinePanel implements WidgetContainer {
	static private final Log log_s_ = LogFactory.getLog(FilesOutlinePanel.class);
	
	/**uǖʐ}ǂݍł܂Bv*/
	private final MessageResource NT_LOADING_POSITION
			= new MessageResource(FilesOutlinePanel.class, "ntLoadingPosition"); //$NON-NLS-1$

	private ScrolledComposite scrolledComposite_;
	private Composite frame_;
	private GridLayout gridLayout_;
	private List<IgoOutlinePanel> list_;
	
	/**
	 * 
	 */
	public FilesOutlinePanel(int col) {
		super();
		if (col <= 0) {
			throw new IllegalArgumentException("Bad size of column: " + col); //$NON-NLS-1$
		}
		scrolledComposite_ = null;
		frame_ = null;
		gridLayout_ = new GridLayout(col, false);
		list_ = new ArrayList<IgoOutlinePanel>();
	}

	/* (non-Javadoc)
	 * @see org.unitarou.swt.WidgetContainer#createContents(org.eclipse.swt.widgets.Composite)
	 */
	public Control createContents(Composite parent) {
		ArgumentChecker.throwIfNull(parent);
		scrolledComposite_ = new ScrolledComposite(parent, SWT.V_SCROLL);
        scrolledComposite_.setLayout(new FillLayout());
        scrolledComposite_.setExpandHorizontal(true);
        scrolledComposite_.setExpandVertical(false);
        scrolledComposite_.addControlListener(new ControlAdapter() {
			@Override
			public void controlResized(ControlEvent e) {
				resized();
			}
        });
        
        frame_ = new Composite(scrolledComposite_, SWT.NONE);
		// ̒iKł͕\Collection̐sȂ̂ŉȂB
		scrolledComposite_.setContent(frame_);
		return scrolledComposite_;
	}

	/* (non-Javadoc)
	 * @see org.unitarou.swt.WidgetContainer#dispose()
	 */
	public void dispose() {
		for (IgoOutlinePanel igoOutlinePanel : list_) {
			igoOutlinePanel.dispose();
		}
	}
	
	/**
	 * ̃pl̍ŏʂ̃Rg[Ԃ܂B
	 * @return
	 */
	public Control getControl() {
		return scrolledComposite_;
	}


	/**
	 * ̃plTCYꂽƂɌĂяoA
	 * eՂ̃TCYvZăTCYs܂B
	 */
	private void resized() {
		Point point = Geometry.getSize(scrolledComposite_.getClientArea());
		scrolledComposite_.setMinSize(point);

		int width = (point.x / gridLayout_.numColumns) 
				- (gridLayout_.horizontalSpacing * 2 + frame_.getBorderWidth());
		point.x = width;
		point.y = width;
		for (IgoOutlinePanel igoOutlinePanel : list_) {
			igoOutlinePanel.setBoardSize(point);
		}
		frame_.pack();
	}

	/**
	 * 
	 * @param files
	 */
	public void setFiles(File[] files) {
		ArgumentChecker.throwIfNull((Object)files);
		StopWatch stopWatch = new StopWatch();
		frame_.dispose();
		for (IgoOutlinePanel igoOutlinePanel : list_) {
			igoOutlinePanel.dispose();
		}
		list_.clear();
        frame_ = new Composite(scrolledComposite_, SWT.NONE);
		frame_.setLayout(gridLayout_);
		for (File file : files) {
			Collection collection = CollectionRepository.instance().load(file);
			if (collection.size() < 5) {
				load(collection);
			} else {
				try {
					new ProgressMonitorDialog(frame_.getShell())
						.run(true, true, new RunnableImpl(collection));
				} catch (InvocationTargetException e) {
					// TODO Auto-generated catch block
					e.printStackTrace();
				} catch (InterruptedException e) {
					// TODO Auto-generated catch block
					e.printStackTrace();
				}
			}
		}
		scrolledComposite_.setContent(frame_);
		resized();
		scrolledComposite_.setMinSize(frame_.getSize());
		
		if (log_s_.isTraceEnabled()) {
			log_s_.trace("Total costs: " + stopWatch.stopSecond() + " [secs]"); //$NON-NLS-1$ //$NON-NLS-2$
		}
	}
	
	private void load(Collection collection) {
		for (RootGameTree rootGameTree : collection) {
			IgoOutlinePanel igoOutlinePanel = new IgoOutlinePanel();
			Control control = igoOutlinePanel.createContents(frame_);
			GridData gridData = new GridData(SWT.FILL, SWT.FILL, true, true);
			control.setLayoutData(gridData);
			igoOutlinePanel.setRootGameTree(rootGameTree);
			list_.add(igoOutlinePanel);
		}
	}
	
	/**
	 * vOXo[ēǂݍ܂邽߂̃GN[L[^[łB
	 */
	private class RunnableImpl implements IRunnableWithProgress {
	    
		private Collection collection_;
		
		private RunnableImpl(Collection collection) {
			collection_ = collection;
		}
		public void run(final IProgressMonitor monitor) {
			monitor.beginTask(NT_LOADING_POSITION.get(), collection_.size());
			
			for (int j = 0 ; j < collection_.size(); ++j) {
				final RootGameTree rgt = collection_.get(j);
				frame_.getDisplay().syncExec(new Runnable() {
					public void run() {
						monitor.subTask(RootGameTreeLabelProvider.CONTEXT.defaultProvider().getLabel(rgt));
						IgoOutlinePanel igoOutlinePanel = new IgoOutlinePanel();
						Control control = igoOutlinePanel.createContents(frame_);
						GridData gridData = new GridData(SWT.FILL, SWT.FILL, true, true);
						control.setLayoutData(gridData);
						igoOutlinePanel.setRootGameTree(rgt);
						list_.add(igoOutlinePanel);
					}
				});
				monitor.worked(1);
				if (monitor.isCanceled()) {
					break;
				}
			}
			monitor.done();
  		}
	}
}
