/*  
 * Copyright 2005 unitarou <boss@unitarou.org>. 
 * All rights reserved.
 * 
 * This program and the accompanying materials are made available under the terms of 
 * the Common Public License v1.0 which accompanies this distribution, 
 * and is available at http://opensource.org/licenses/cpl.php
 * 
 * Contributors:
 *     unitarou - initial API and implementation
 */
package org.unitarou.yukinoshita.view.jface.dlg;

import java.io.File;

import org.eclipse.swt.widgets.Shell;

/**
 * t@CJ߂̃t@C_CAŐʃC^[tFCXłB
 * 
 * @author unitarou &lt;boss@unitarou.org&gt; 
 */
public interface IgoFileChooser {
	/**
	 * t@C`[ŨX^Cw肵܂B 
	 */
	enum Style {
		/** ǂݍݗpɒP̃t@Cw肷ۂɗpX^CłB*/
		OPEN_FILE,
		
		/** ǂݍݗpɕ̃t@Cw肷ۂɗpX^CłB*/
		OPEN_FILES,

		/** ۑpɒP̃t@Cw肷ۂɗpX^CłB*/
		SAVE_FILE,
	}

	/**
	 * _CAOJA[UɃt@CI܂B
	 * 
	 * @return [Ut@CIꍇ<code>true</code>A
	 *          LZG[ȂǂŎw肵Ȃꍇ<code>false</code>B
	 *          
	 * @see org.eclipse.swt.widgets.FileDialog#open()
	 */
	boolean chooseFile();

	
	/**
	 * _CAÕJgtH_[Ԃ܂B
	 * 
	 * @return _CAÕJgtH_[ 
	 */
	File getFolder();

	/**
	 * [UIt@CԂ܂B
	 * ݂Ȃꍇ܂B
	 * ܂[ULZG[ꍇnullԂ܂B
	 */
	File getFile();

	/**
	 * [UIt@CԂ܂B
	 * ݂Ȃꍇ܂B
	 * [ULZG[ꍇ͗vfO̔zԂ܂B
	 * ܂NX͗vf̒ɂ<code>null</code>Ƃۏ؂ĂB
	 */
	File[] getFiles();

	
	/**
	 * [UfileÎ悤Ɏw肵܂B<br>
	 * t@CIĂꍇ́AP݂̂ɕύX܂B
	 * @param file
	 */
	void setFile(File file);

	/**
	 * ftHgt@Cw肵܂B
	 * @param filename
	 * @throws org.unitarou.lang.NullArgumentException  <code>null</code>̏ꍇB
	 */
	void setFileName(String filename);
	

	/**
	 * _CAÕJgtH_[w肵܂B
	 * 
	 * @param file
	 * @throws org.unitarou.lang.NullArgumentException <code>null</code>̏ꍇ
	 * @throws IllegalArgumentException tH_[ł͂ȂꍇB
	 */
	void setFolder(File file);
	
	
	/**
	 * _CAÕtB^[ݒ肵܂B
	 * @param namedFileFilters
	 * @throws org.unitarou.lang.NullArgumentException <code>null</code>̏ꍇ
	 */
	void setFilter(NamedFileFilter[] namedFileFilters);
	
	
	/* (non-Javadoc)
	 * @see org.eclipse.swt.widgets.Dialog#getParent()
	 */
	Shell getParent();

	/**
	 * 
	 */
	Style getStyle();


	/* (non-Javadoc)
	 * @see org.eclipse.swt.widgets.Dialog#getText()
	 */
	String getText();

	/* (non-Javadoc)
	 * @see org.eclipse.swt.widgets.Dialog#setText(java.lang.String)
	 */
	void setText(String string);
}