/*  
 * Copyright 2005 unitarou <boss@unitarou.org>. 
 * All rights reserved.
 * 
 * This program and the accompanying materials are made available under the terms of 
 * the Common Public License v1.0 which accompanies this distribution, 
 * and is available at http://opensource.org/licenses/cpl.php
 * 
 * Contributors:
 *     unitarou - initial API and implementation
 */
package org.unitarou.yukinoshita.view.jface.dlg;

import java.io.File;

import org.apache.commons.io.FilenameUtils;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.swt.SWT;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Shell;

import org.unitarou.io.Ios;
import org.unitarou.lang.Strings;
import org.unitarou.ml.BasicMessages;
import org.unitarou.ml.MessageResource;
import org.unitarou.sgf.Collection;
import org.unitarou.sgf.Sgfs;
import org.unitarou.util.ArgumentChecker;
import org.unitarou.yukinoshita.Yukinoshita;
import org.unitarou.yukinoshita.Application.MessageLevel;
import org.unitarou.yukinoshita.context.Context;
import org.unitarou.yukinoshita.context.CurrentContext;
import org.unitarou.yukinoshita.context.FileContextValue;
import org.unitarou.yukinoshita.view.jface.dlg.IgoFileChooser.Style;
import org.unitarou.yukinoshita.view.provider.rgtlp.GreedyRgtLabelProvider;

/**
 * t@C̕ۑAǂݏow肷_CAOłB<br>
 * ReLXg̐ݒɉĎۂ̃_CAO͈قȂ܂B
 * 
 * @author unitarou &lt;boss@unitarou.org&gt;
 * @see org.unitarou.yukinoshita.view.jface.dlg.ExplorerLikeFileChooser
 * @see org.unitarou.yukinoshita.view.jface.dlg.SwtFileChooser
 */
public class IgoFileDialog {


	/** ǂݍފt@Cw肵ĂB */
	static private final MessageResource NT_FILE_OPEN
			= new MessageResource(IgoFileDialog.class, "ntFileOpen"); //$NON-NLS-1$

	/** ǂݍފt@Cw肵Ă()B */
	static private final MessageResource NT_FILE_OPEN_MULTI 
			= new MessageResource(IgoFileDialog.class, "ntFileOpenMulti"); //$NON-NLS-1$

	/** ۑt@Cw肵ĂB */
	static private final MessageResource NT_FILE_SAVE
			= new MessageResource(IgoFileDialog.class, "ntFileSave"); //$NON-NLS-1$
	
	/** ㏑ۑ̊mF */
	static private final MessageResource NT_CONFIRM_OVERWRITE 
			= new MessageResource(IgoFileDialog.class, "ntConfirmOverwrite"); //$NON-NLS-1$
	
	/** t@C{0}͊ɑ݂܂B\ñt@Cɏ㏑Ă낵łH */
	static private final MessageResource MSG_FILE_IS_EXISTS_OVERWRITE 
			= new MessageResource(IgoFileDialog.class, "msgFileIsExistsOverwrite"); //$NON-NLS-1$
	
	/** ㏑(&W) */
	static private final MessageResource CLB_OVERWRITE 
			= new MessageResource(IgoFileDialog.class, "clbOverwrite"); //$NON-NLS-1$
	
	/** ʂ̖Oŕۑ(&C) */
	static private final MessageResource CLB_SAVE_ANOTHER_NAME
			= new MessageResource(IgoFileDialog.class, "clbSaveAnotherName"); //$NON-NLS-1$

	/** wł܂B */
	static private final MessageResource NT_BAD_ASSIGN
			= new MessageResource(IgoFileDialog.class, "ntBadAssign"); //$NON-NLS-1$

	/** {0}̓fBNgƂĊɑ݂̂\nʂ̖Ow肵ĉB*/
	static private final MessageResource MSG_ASSIGN_NO_DIRECTORY
			= new MessageResource(IgoFileDialog.class, "msgAssignNoDirectory"); //$NON-NLS-1$

	/** {0}͏݋֎~t@CłB\nʂ̖Ow肵ĉB*/
	static private final MessageResource MSG_ASSIGN_WRITABLE
			= new MessageResource(IgoFileDialog.class, "msgAssignWritable"); //$NON-NLS-1$

	
	/** uSimple Game Format ({0})v*/
	static private final MessageResource NT_FILTER_SGF
			= new MessageResource(IgoFileDialog.class, "ntFilterSgf"); //$NON-NLS-1$
	
	/** uAll files ({0})v*/
	static private final MessageResource NT_FILTER_ALL
			= new MessageResource(IgoFileDialog.class, "ntFilterAll"); //$NON-NLS-1$
	
	/** sgft@Cp̃tB^[(*.sgf)łB */
	static private final String FILE_FILTER_SGF = "*." + Sgfs.EXTENSION; //$NON-NLS-1$

	/** tB^[̃tB^[(*.*)łB */
	static private final String FILE_FILTER_ALL = "*.*"; //$NON-NLS-1$
	
	/** _CAÕJgtH_ */
	static private final FileContextValue CURRENT_FOLDER 
			= new FileContextValue(IgoFileDialog.class, "currentFolder", Ios.getCurrentDirectory()); //$NON-NLS-1$
	
	
    /**
     * K؂ȃt@Cw肳邩LZ܂ŁA
     * t@C_CAOŃ[Uɕۑt@Cw肳郁\bhłB<br>
     * [Uw肵t@CԂ܂BŊgq{@link Sgfs#EXTENSION}ȊOŁA
     * {@link Context#APPEND_SGF_EXTENSION_IN_SAVE}<code>true</code>̏ꍇA
     * {@link Sgfs#EXTENSION}t@C̊gqƂ܂B
     * ȂLZꍇnullԂ܂B
     * 
     * @return
     */
    static public File askSaveFile(Collection target) {
    	ArgumentChecker.throwIfNull(target);
    	File folder = target.getFile();
    	if (folder == null) {
    		folder = Ios.getCurrentDirectory();
        	String defaultFileName = new GreedyRgtLabelProvider().getLabel(target.get(0));
        	folder = new File(folder, defaultFileName + '.' + Sgfs.EXTENSION);
    	}
    	do {
    		IgoFileDialog dialog = new IgoFileDialog(
    							Display.getCurrent().getActiveShell(),
    							IgoFileChooser.Style.SAVE_FILE);
    		dialog.setFolder(folder);
    		if (!dialog.open()) {
    			return null;
    		}
    		File file = dialog.getFile();
    		if (Ios.isTemporaryFile(file)) {
        		Yukinoshita.application().openMessageDialog(
        				MessageLevel.WARNING,
        				BasicMessages.NT_FILE_SAVE_FAILURE.get(),
        				Ios.MSG_CANT_WRITE_TO_TMP_FILE.get(file.getAbsolutePath())
        				);
        		continue;
    		}
			return file;
    		
    	} while(true);
    }	
	
	
	private IgoFileChooser fileDialog_;
	private final Shell parent_;
	private final Style style_;
	private final CurrentContext context_;
	private String filename_;
	private File currentDirectory_;
	
    /** 
     * ǂݍݗpAPt@Ĉ݂ŃCX^X쐬܂B
     * @param parent
     */
    public IgoFileDialog(Shell parent) {
        this(parent, Style.OPEN_FILE);
    }

    /**
     * @param parent
     * @param style {@link SWT#OPEN},{@link SWT#SAVE},{@link SWT#MULTI}
     */
    public IgoFileDialog(Shell parent, Style style) {
    	ArgumentChecker.throwIfNull(parent, style);
    	fileDialog_ = null;
    	parent_ = parent;
    	style_ = style;
    	context_ = Yukinoshita.context().getCurrent(null);
    	filename_ = Strings.EMPTY;
    	currentDirectory_ = context_.getFile(CURRENT_FOLDER);
    }

    /**
     * _CAOJă[UɃt@Cw肳܂B
     * ȂRXgN^{@link SWT#MULTI}w肵ꍇ́A
     * ̃\bh̖߂l͎g킸{@link #getFileNames()}Ńt@C擾܂B
     * 
     * @return [Ut@Cw肵ꍇtrueB[ULZꍇfalseB
     */
    public boolean open() {
        // t@Cۑ̏ꍇ͏㏑`FbNsB
    	boolean ret;
    	if (style_.equals(IgoFileChooser.Style.SAVE_FILE)) {
    		ret = openAsSave();
        } else {
        	createFileDialog();
        	ret =  fileDialog_.chooseFile();
        }

    	if (ret) {
    		context_.setFile(CURRENT_FOLDER.id(), fileDialog_.getFolder());
    	}
    	return ret;
    }
    
    /**
     * Ƀt@Cꍇ͏㏑mFs_CAO\܂B
     * 
     * @return [Ut@Cw肵ꍇtrueB[ULZꍇfalseB
     */
    private boolean openAsSave() {
        while(true) {
        	createFileDialog();
        	boolean choose = fileDialog_.chooseFile();
            if (!choose) {
                return choose;
            }
    		context_.setFile(CURRENT_FOLDER.id(), fileDialog_.getFolder());
            File file = fileDialog_.getFile();
            file = checkExtension(file);
            fileDialog_.setFile(file);
            if (!file.exists()) {
                return true;
            }
            if (file.isDirectory()) {
    			MessageDialog.openInformation(
    					fileDialog_.getParent(),
    					NT_BAD_ASSIGN.get(),
    					MSG_ASSIGN_NO_DIRECTORY.get(fileDialog_.getFile().getAbsolutePath())
    					);
    			continue;
            }
            if (!file.canWrite()) {
    			MessageDialog.openInformation(
    					fileDialog_.getParent(),
    					NT_BAD_ASSIGN.get(),
    					MSG_ASSIGN_WRITABLE.get(fileDialog_.getFile().getAbsolutePath())
    					);
    			continue;
            }
			MessageDialog md = new MessageDialog(
			        fileDialog_.getParent(),
			        NT_CONFIRM_OVERWRITE.get(),
			        null,
			        MSG_FILE_IS_EXISTS_OVERWRITE.get(fileDialog_.getFile().getAbsolutePath()),
			        MessageDialog.QUESTION,
			        new String[]{CLB_OVERWRITE.get(), CLB_SAVE_ANOTHER_NAME.get()},
			        1);
			
			if (md.open() == 0) {
			    return true;
			}
        }
    }
    
    /**
     * gq{@link Sgfs#EXTENSION}ȊOŁA
     * {@link Context#APPEND_SGF_EXTENSION_IN_SAVE}<code>true</code>̏ꍇA
     * {@link Sgfs#EXTENSION}t@C̊gqƂ܂B
	 * @param file
	 * @return
	 */
	private File checkExtension(File file) {
		if (Yukinoshita.context().getCurrent(null).getBoolean(
				Context.APPEND_SGF_EXTENSION_IN_SAVE)) 
		{
			String ext = FilenameUtils.getExtension(file.getName());
			if (!ext.equalsIgnoreCase(Sgfs.EXTENSION)) {
				file = new File(file.getAbsolutePath() + "." + Sgfs.EXTENSION); //$NON-NLS-1$
			}
		}
		return file;
	}

	/**
     * 
     */
    private void createFileDialog() {
    	Context.FileDialogStyle style 
    			= (Context.FileDialogStyle)Yukinoshita.context().getAttribute(
    					Context.FILE_DIALOG_STYLE.id(), null);
    	switch (style) {
    	case OS:
    		fileDialog_ = new SwtFileChooser(parent_, style_);
    		break;
    		
    	case ORIGINAL:
        	fileDialog_ = new ExplorerLikeFileChooser(parent_, style_);
    		break;
    		
    	default:
    		assert false;
    	}
    	fileDialog_.setFileName(filename_);
    	fileDialog_.setFolder(currentDirectory_);

    	
    	NamedFileFilter[] filters = new NamedFileFilter[] {
    		new NamedFileFilter(FILE_FILTER_SGF, NT_FILTER_SGF.get()),
    		new NamedFileFilter(FILE_FILTER_ALL, NT_FILTER_ALL.get()),
    	};
    	fileDialog_.setFilter(filters);

        switch (style_) {
        case OPEN_FILE:
            fileDialog_.setText(NT_FILE_OPEN.get());
    		break;
        	
        case OPEN_FILES:
            fileDialog_.setText(NT_FILE_OPEN_MULTI.get());
        	break;
        	
        case SAVE_FILE:
            fileDialog_.setText(NT_FILE_SAVE.get());
            break;
        
        default:
            throw new RuntimeException("Bad style:" + style_); //$NON-NLS-1$
        }
    }

	public File getFile() {
		return fileDialog_.getFile();
	}

	public File[] getFiles() {
		return fileDialog_.getFiles();
	}

	/**
	 * file̐efBNgǂݏoĐݒ肵܂B
	 * @param file
	 */
	public void setFolder(File file) {
		ArgumentChecker.throwIfNull(file);
		while (!file.isDirectory()) {
			filename_ = file.getName();
			file = file.getParentFile();
			if (file == null) {
				return;
			}
		}
		currentDirectory_ = file;
	}
}
