/*  
 * Copyright 2005 unitarou <boss@unitarou.org>. 
 * All rights reserved.
 * 
 * This program and the accompanying materials are made available under the terms of 
 * the Common Public License v1.0 which accompanies this distribution, 
 * and is available at http://opensource.org/licenses/cpl.php
 * 
 * Contributors:
 *     unitarou - initial API and implementation
 */
package org.unitarou.yukinoshita.view.jface.dlg;

import java.util.List;

import org.apache.commons.io.filefilter.WildcardFilter;

import org.unitarou.lang.NameDisplayable;
import org.unitarou.util.ArgumentChecker;

/**
 * @author unitarou &lt;boss@unitarou.org&gt; 
 */
public class NamedFileFilter extends WildcardFilter implements NameDisplayable {

	private final String[] wildcards_;
	
	private final String fileTypeName_;

	/**
	 * @param wildcard
	 * @param fileTypeName gq\t@C^Cv̖̂ł(FSmart Game Format)
	 */
	public NamedFileFilter(String wildcard, String fileTypeName) {
		super(wildcard);
		ArgumentChecker.throwIfNull(wildcard, fileTypeName);
		wildcards_ = new String[1];
		wildcards_[0] = wildcard;
		fileTypeName_ = fileTypeName;
	}

	/**
	 * @param wildcards
	 * @param fileTypeName gq\t@C^Cv̖̂ł(FSmart Game Format)
	 */
	public NamedFileFilter(String[] wildcards, String fileTypeName) {
		super(wildcards);
		ArgumentChecker.throwIfNull(wildcards, fileTypeName);
		wildcards_ = new String[wildcards.length];
		System.arraycopy(wildcards, 0, wildcards_, 0, wildcards_.length);
		fileTypeName_ = fileTypeName;
	}



	/**
	 * @param wildcards
	 * @param fileTypeName gq\t@C^Cv̖̂ł(FSmart Game Format)
	 */
	public NamedFileFilter(List<String> wildcards, String fileTypeName) {
		super(wildcards);
		ArgumentChecker.throwIfNull(wildcards, fileTypeName);
		wildcards_ =wildcards.toArray(new String[wildcards.size()]);
		fileTypeName_ = fileTypeName;
	}

	
	/* (non-Javadoc)
	 * @see org.unitarou.lang.NameDisplayable#getDisplayName()
	 */
	public String displayName() {
		StringBuilder builder = new StringBuilder();
		builder.append(fileTypeName_).append(" ("); //$NON-NLS-1$
		for (String suffix : wildcards_) {
			builder.append(suffix).append(", "); //$NON-NLS-1$
		}
		builder.delete(builder.length() - 2, builder.length());
		if (wildcards_.length != 0) {
			builder.append(")"); //$NON-NLS-1$
		}
		return builder.toString();
	}

	/**
	 * gq̈ꗗԂ܂B
	 * @return
	 */
	public String[] getWildcards() {
		String[] ret = new String[wildcards_.length];
		System.arraycopy(wildcards_, 0, ret, 0, ret.length);
		return ret;
	}
}
