/*  
 * Copyright 2005 unitarou <boss@unitarou.org>. 
 * All rights reserved.
 * 
 * This program and the accompanying materials are made available under the terms of 
 * the Common Public License v1.0 which accompanies this distribution, 
 * and is available at http://opensource.org/licenses/cpl.php
 * 
 * Contributors:
 *     unitarou - initial API and implementation
 */
package org.unitarou.yukinoshita.view.jface.dlg;

import java.util.ArrayList;
import java.util.List;

import org.eclipse.jface.dialogs.IDialogConstants;
import org.eclipse.swt.SWT;
import org.eclipse.swt.events.MouseAdapter;
import org.eclipse.swt.events.MouseEvent;
import org.eclipse.swt.events.MouseListener;
import org.eclipse.swt.layout.FillLayout;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Shell;

import org.unitarou.jface.UTitleAreaDialog;
import org.unitarou.sgf.Collection;
import org.unitarou.sgf.RootGameTree;
import org.unitarou.util.ArgumentChecker;
import org.unitarou.yukinoshita.view.jface.board.CollectionsPanel;
import org.unitarou.yukinoshita.view.jface.board.IgoOutlinePanel;

/**
 * {@link org.unitarou.sgf.Collection}ꗗ\_CAOłB
 * ꌏIAIASI𓙂s܂B
 * 
 * @author unitarou &lt;boss@unitarou.org&gt; 
 */
public class RootGameTreeChooser extends UTitleAreaDialog {
	
	public enum Style {
		/** ꌏIł邱ƂtOłB */
		SINGLE,
		
		/** ꌏȏIł邱ƂtOłB */
		MULTI,
		
		/** IłȂƂtOł */
		ANY;
	}

	/**
	 * \ΏۂƂȂRNVێ܂B
	 */
	private final Collection collection_;
	
	/**
	 * IX^CłB
	 */
	private final Style style_;
	
	/**
	 * _CAOɕ\plłB
	 */
	private final CollectionsPanel<IgoOutlinePanel> collectionsPanel_;
	
	private IgoOutlinePanel[] panels_;
	
	/**
	 * @param parentShell
	 */
	public RootGameTreeChooser(Shell parentShell, Collection collection, Style style) {
		super(parentShell);
		ArgumentChecker.throwIfNull(collection, style);
		setShellStyle(SWT.TITLE | SWT.RESIZE | SWT.PRIMARY_MODAL);
		collection_ = collection;
		style_ = style;
		collectionsPanel_ = new CollectionsPanel<IgoOutlinePanel>(IgoOutlinePanel.factory(), 3);
		
	}

	/* (non-Javadoc)
	 * @see org.unitarou.jface.UTitleAreaDialog#createContents(org.eclipse.swt.widgets.Composite)
	 */
	@Override
	protected Control createContents(Composite parent) {
		Control control = super.createContents(parent);
		
		// IX^C̏ꍇ͈UDisableɂB
		Button button = getButton(IDialogConstants.OK_ID);
		if (button != null) {
			button.setEnabled(style_.equals(Style.ANY));
		} else {
			throw new IllegalStateException("Can't find OK button."); //$NON-NLS-1$
		}
		return control;
	}

	/* (non-Javadoc)
	 * @see org.eclipse.jface.dialogs.TitleAreaDialog#createDialogArea(org.eclipse.swt.widgets.Composite)
	 */
	@Override
	protected Control createDialogArea(Composite parent) {
		Composite composite = (Composite)super.createDialogArea(parent); //MEMO KCompositeԂB
		Composite frame = new Composite(composite, SWT.BORDER);
		GridData gridData = new GridData(SWT.FILL, SWT.FILL, true, true);
		gridData.widthHint = 500;
		gridData.heightHint = 300; //TODO }WbNio[
		frame.setLayoutData(gridData);
		frame.setLayout(new FillLayout());
		collectionsPanel_.createContents(frame);
		collectionsPanel_.set(new Collection[]{collection_});
		
		panels_ = collectionsPanel_.getPanels(new IgoOutlinePanel[0]);
		MouseListener listener = new MouseListened();
		for (IgoOutlinePanel panel : panels_) {
			panel.getBoardControl().addMouseListener(listener);
		}
		return composite;
	}
	
	/**
	 * [UI{@link RootGameTree}̔zԂ܂B<br>
	 * {@link Style#SINGLE}̏ꍇ͗vfP̔zA<br>
	 * {@link Style#MULTI}̏ꍇ͗vf1ȏ̔z<br>
	 * [@link Style#ANY}̏ꍇ͗vfO̔zԂ܂B
	 * @return
	 */
	public RootGameTree[] getSelected() {
		List<RootGameTree> ret = new ArrayList<RootGameTree>(panels_.length);
		for (IgoOutlinePanel panel : panels_) {
			if (panel.isFocused()) {
				ret.add(panel.getRootGameTree());
			}
		}
		return ret.toArray(new RootGameTree[ret.size()]);
	}
	
	/**
	 *  
	 */
	private class MouseListened extends MouseAdapter {

		/* (non-Javadoc)
		 * @see org.eclipse.swt.events.MouseAdapter#mouseDown(org.eclipse.swt.events.MouseEvent)
		 */
		@Override
		public void mouseDown(MouseEvent e) {
			switch (style_) {
			case SINGLE: //PȈꍇ̓NbNplȊȎSẴpl̃tH[JXNA
				for (IgoOutlinePanel panel : panels_) {
					panel.setFocus(panel.getBoardControl().equals(e.widget));
				}
				getButton(IDialogConstants.OK_ID).setEnabled(true);
				break;
				
			case MULTI: //I̏ꍇ̓NbNpl̃tH[JX𔽓]
				int selected = 0;
				for (IgoOutlinePanel panel : panels_) {
					if (panel.getBoardControl().equals(e.widget)) {
						panel.setFocus(!panel.isFocused());
					}					
					selected += panel.isFocused() ? 1 : 0;
				}
				getButton(IDialogConstants.OK_ID).setEnabled(selected != 0);
				break;
				
			default:
				// Ȃ
			}
		}
	}

}
