/*  
 * Copyright 2005 unitarou <boss@unitarou.org>. 
 * All rights reserved.
 * 
 * This program and the accompanying materials are made available under the terms of 
 * the Common Public License v1.0 which accompanies this distribution, 
 * and is available at http://opensource.org/licenses/cpl.php
 * 
 * Contributors:
 *     unitarou - initial API and implementation
 */
package org.unitarou.yukinoshita.view.jface.dlg;

import java.io.File;
import java.util.ArrayList;
import java.util.EnumSet;
import java.util.List;

import org.eclipse.jface.dialogs.TitleAreaDialog;
import org.eclipse.swt.SWT;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.RowLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Group;
import org.eclipse.swt.widgets.Shell;

import org.unitarou.jface.UTitleAreaDialog;
import org.unitarou.lang.Strings;
import org.unitarou.ml.MessageResource;
import org.unitarou.sgf.Collection;
import org.unitarou.sgf.RootGameTree;
import org.unitarou.sgf.type.GameType;
import org.unitarou.util.ArgumentChecker;
import org.unitarou.yukinoshita.Yukinoshita;
import org.unitarou.yukinoshita.view.GameFrameController;
import org.unitarou.yukinoshita.view.WindowController;
import org.unitarou.yukinoshita.view.provider.clp.ForFileNameCollectionProvider;

/**
 * ݊JĂt@C̒I_CAOłB
 * 
 * @author unitarou &lt;boss@unitarou.org&gt; 
 */
public class SelectTargetFileDialog extends UTitleAreaDialog {
	
	/**
	 * _CAO̐ݒw肷enumłB
	 */
	public enum Type {
		/** ҏW[h̃t@Cw܂B */
		PERMITS_NO_EDIT_MODE,
		
		/** VKt@C̎w܂B */
		PERMITS_NEW_FILE,

		/** ݊JĂt@C̎w܂B */
		PERMITS_GAME,

		/** ݊JĂlt@C̎w܂B */
		PERMITS_PROBLEM,

		/** ݊JĂWt@C̎w܂B */
		PERMITS_DRILL;
	}
	
	/** uVKt@Cv*/
	static private final MessageResource LB_NEW_FILE
			= new MessageResource(SelectTargetFileDialog.class, "lbNewFile"); //$NON-NLS-1$
	
	/** ut@Cۑ({0})v*/
	static private final MessageResource LB_UNSAVED
			= new MessageResource(SelectTargetFileDialog.class, "lbUnsaved"); //$NON-NLS-1$
	
	
	/** u(ҏŴ)v*/
	static private final MessageResource LB_EDIT_MODE_ONLY
			= new MessageResource(SelectTargetFileDialog.class, "lbEditModeOnly"); //$NON-NLS-1$

	/** ȕ𖞂t@Cw\łBv*/
	static private final MessageResource NT_YOU_CAN_SELECT_THESE_FILES
			= new MessageResource(SelectTargetFileDialog.class, "ntYouCanSelectTheseFiles"); //$NON-NLS-1$

	/** 
	 * {@link TitleAreaDialog#setMessage(java.lang.String)}
	 * w\ȃt@Č^񋓂ۂ̃Zp[^('/')łB
	 */
	static private final String TYPE_SEPARATOR = "/"; //$NON-NLS-1$

	/**
	 * _CAO̐ݒێ܂B
	 */
	private EnumSet<Type> typeSet_;
	
	/**
	 * [UI^[Qbg̃Rg[ێ܂B<br>
	 * VK쐬IuWFNg쐬<code>null</code>ێ܂B
	 */
	private GameFrameController target_;
	
	private String targetCategoryCaption_;
	
	/**
	 * VKt@Cw\Ɛݒ肵܂B<br>
	 * WƕҏW[h̃t@C͎wsłB
	 * @param parentShell
	 */
	public SelectTargetFileDialog(Shell parentShell) {
		this(parentShell, EnumSet.of(Type.PERMITS_NEW_FILE));
	}

	/**
	 * w肳ꂽp^ŏ܂B<br>
	 * ̃NX̃vCRXgN^łB
	 * @param parentShell
	 */
	public SelectTargetFileDialog(Shell parentShell, EnumSet<Type> typeSet) {
		super(parentShell);
		ArgumentChecker.throwIfNull(typeSet);
		setShellStyle(SWT.TITLE | SWT.RESIZE | SWT.PRIMARY_MODAL);
		typeSet_ = EnumSet.copyOf(typeSet);
		target_ = null;
		targetCategoryCaption_ = Strings.EMPTY;
	}

	/* (non-Javadoc)
	 * @see org.eclipse.jface.dialogs.TitleAreaDialog#createContents(org.eclipse.swt.widgets.Composite)
	 */
	@Override
	protected Control createContents(Composite parent) {
		Control control =  super.createContents(parent);
        setMessage(composeMessage());
        return control;
	}
	
	/**
	 * 
	 * @return
	 */
	private String composeMessage() {
        StringBuilder builder = new StringBuilder();
        
        
        String editCondtionMsg = typeSet_.contains(Type.PERMITS_NO_EDIT_MODE) 
        							? Strings.EMPTY : LB_EDIT_MODE_ONLY.get();
        
        if (typeSet_.contains(Type.PERMITS_NEW_FILE)) {
        	builder.append(LB_NEW_FILE.get())
        		   .append(TYPE_SEPARATOR);
        }
        if (typeSet_.contains(Type.PERMITS_GAME)) {
        	builder.append(GameType.GAME.displayName())
        	       .append(editCondtionMsg)
        	       .append(TYPE_SEPARATOR);
        }
        if (typeSet_.contains(Type.PERMITS_PROBLEM)) {
        	builder.append(GameType.PROBLEM.displayName())
        	       .append(editCondtionMsg)
        	       .append(TYPE_SEPARATOR);
        }
        if (typeSet_.contains(Type.PERMITS_DRILL)) {
        	builder.append(GameType.DRILL.displayName())
        	       .append(editCondtionMsg)
        	       .append(TYPE_SEPARATOR);
        }
        if (builder.length() != 0) {
        	// Ō̃Zp[^폜B
        	builder.delete(builder.length() - TYPE_SEPARATOR.length(), builder.length());
        	
        	// 擪ɃbZ[WǉB
        	builder.insert(0, Strings.LINE_SEPARATOR)
        		   .insert(0, NT_YOU_CAN_SELECT_THESE_FILES.get());
        }
        return builder.toString();
	}

	/* (non-Javadoc)
	 * @see org.eclipse.jface.dialogs.Dialog#createDialogArea(org.eclipse.swt.widgets.Composite)
	 */
	@Override
	protected Control createDialogArea(Composite parent) {
		// KCompositeԂƂۏ
		Composite frame = (Composite)super.createDialogArea(parent);
		Group group_ = new Group(frame, SWT.SHADOW_ETCHED_IN);
		group_.setLayout(new RowLayout(SWT.VERTICAL));
		group_.setText(targetCategoryCaption_);
		
		SelectionListener listener = new ButtonSelected();
		if (typeSet_.contains(Type.PERMITS_NEW_FILE)) {
			Button button = new Button(group_, SWT.RADIO);
			button.setText(LB_NEW_FILE.get());
			button.setData(null); // getTarget()nullԂƂ𖾎ĂB
			button.addSelectionListener(listener);
		}

		boolean permitsNoEditMode = typeSet_.contains(Type.PERMITS_NO_EDIT_MODE);
		ForFileNameCollectionProvider provider = new ForFileNameCollectionProvider();
		for (GameFrameController gfc : findTargets()) {
			Button button = new Button(group_, SWT.RADIO);
			button.setData(gfc); 
			button.setEnabled(permitsNoEditMode || gfc.isEditMode());
			button.addSelectionListener(listener);
			
			File file = gfc.getCollection().getFile();
			if (file == null) {
				button.setText(LB_UNSAVED.get(provider.getLabel(gfc.getCollection())));
			} else {
				button.setText(file.getName());
			}
		}
		return frame;
	}
	
	/**
	 * IΏۂƂt@C̈ꗗԂ܂B<br> 
	 * @return
	 */
	private GameFrameController[] findTargets() {
		List<GameFrameController> gfcList = new ArrayList<GameFrameController>();
		
		for (WindowController controller : Yukinoshita.application().getAllController()) {
			GameFrameController[] gfcs = controller.getGameFrameControllers();
			for (GameFrameController gfc : gfcs) {
				// W̃t@Cǂ
				// ŏCollectionDrillǂŔłB
				Collection collection = gfc.getCollection();
				if (collection.size() == 0) {
					continue;
				}
				GameType gameType = collection.get(0).getGameType();
				if (GameType.DRILL.equals(gameType)) {
					if (typeSet_.contains(Type.PERMITS_DRILL)) {
						gfcList.add(gfc);
					}
					continue;
				}
				
				// Collection̂Ȃ̂ǂꂩłɃ}b`΂njƂB
				for (RootGameTree rgt : collection) {
					if (GameType.GAME.equals(rgt.getGameType())
							&& typeSet_.contains(Type.PERMITS_GAME)) 
					{
						gfcList.add(gfc);
						break;
					}
					if (GameType.PROBLEM.equals(rgt.getGameType())
							&& typeSet_.contains(Type.PERMITS_PROBLEM)) 
					{
						gfcList.add(gfc);
						break;
					}
				}
			}
		}
		return gfcList.toArray(new GameFrameController[gfcList.size()]);
	}

	/**
	 * ^[QbgI郉WI{^̃LvVw肵܂B
	 * @param text
	 * @throws org.unitarou.lang.NullArgumentException <code>null</code>̏ꍇB
	 */
	public void setTargetCategoryCaption(String text) {
		ArgumentChecker.throwIfNull(text);
		targetCategoryCaption_ = text;
	}


	/**
	 * [UI^[Qbg̃Rg[Ԃ܂B<br>
	 * VK쐬IuWFNg쐬<code>null</code>Ԃ܂B
	 */
	public GameFrameController getTarget() {
		return target_;
	}
	

	/**
	 * {^|ꂽɑΉ{@link GameFrameController}ێ܂B
	 */
	private class ButtonSelected extends SelectionAdapter {

		/* (non-Javadoc)
		 * @see org.eclipse.swt.events.SelectionAdapter#widgetSelected(org.eclipse.swt.events.SelectionEvent)
		 */
		@Override
		public void widgetSelected(SelectionEvent e) {
			target_ = (GameFrameController)e.widget.getData();
		}
	}
}
