/*  
 * Copyright 2005 unitarou <boss@unitarou.org>. 
 * All rights reserved.
 * 
 * This program and the accompanying materials are made available under the terms of 
 * the Common Public License v1.0 which accompanies this distribution, 
 * and is available at http://opensource.org/licenses/cpl.php
 * 
 * Contributors:
 *     unitarou - initial API and implementation
 */
package org.unitarou.yukinoshita.view.jface.dlg;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.EnumSet;
import java.util.HashSet;
import java.util.List;
import java.util.Set;

import org.eclipse.jface.dialogs.Dialog;
import org.eclipse.jface.dialogs.IDialogConstants;
import org.eclipse.jface.viewers.CheckStateChangedEvent;
import org.eclipse.jface.viewers.CheckboxTableViewer;
import org.eclipse.jface.viewers.ICheckStateListener;
import org.eclipse.jface.viewers.ILabelProviderListener;
import org.eclipse.jface.viewers.ITableLabelProvider;
import org.eclipse.jface.viewers.LabelProvider;
import org.eclipse.swt.SWT;
import org.eclipse.swt.dnd.Clipboard;
import org.eclipse.swt.dnd.TextTransfer;
import org.eclipse.swt.dnd.Transfer;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.layout.RowLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Group;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Scale;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Table;
import org.eclipse.swt.widgets.TableColumn;
import org.eclipse.swt.widgets.TableItem;
import org.eclipse.swt.widgets.Text;

import org.unitarou.lang.Strings;
import org.unitarou.ml.BasicMessages;
import org.unitarou.ml.MessageResource;
import org.unitarou.sgf.Collection;
import org.unitarou.sgf.GameTree;
import org.unitarou.sgf.Node;
import org.unitarou.sgf.Property;
import org.unitarou.sgf.RootGameTree;
import org.unitarou.sgf.SgfId;
import org.unitarou.sgf.parser.SgfFormatter;
import org.unitarou.sgf.util.filter.InsertLineSeparatorFilter;
import org.unitarou.sgf.util.filter.RemoveSoftLineBreakFilter;
import org.unitarou.sgf.util.filter.RemoveUtrFilter;
import org.unitarou.sgf.util.filter.SieveBySgfIdFilter;
import org.unitarou.swt.EnumSelectionAdapter;
import org.unitarou.swt.LabeledEnumCombo;
import org.unitarou.swt.Swts;
import org.unitarou.swt.USashForm;
import org.unitarou.swt.EnumCombo.Style;
import org.unitarou.util.ArgumentChecker;
import org.unitarou.util.Filter;
import org.unitarou.yukinoshita.Yukinoshita;
import org.unitarou.yukinoshita.view.jface.util.WidgetFactory;
import org.unitarou.yukinoshita.view.provider.rgtlp.RootGameTreeLabelProvider;

/**
 * SGFx^eLXg`ŕҏWăNbv{[hɕʂ_CAOłB
 * 
 * @author unitarou &lt;boss@unitarou.org&gt; 
 */
public class SgfTextDialog extends Dialog {
	/**
	 * UTȐ@肷enumłB
	 */
	enum HandleSgfId {
		/** [U蓮őI邱ƂӖ܂ */
		MANUAL,
		
		/** ݂SẴ^OgƂӖ܂B */ 
		ALL,
		
		/** Kvŏ̃^Ô݂gƂӖ܂*/ 
		REQUISITE;
		
		/* (non-Javadoc)
		 * @see java.lang.Object#toString()
		 */
		@Override
		public String toString() {
			return new MessageResource(this.getClass(), name()).get();
		}
	}	
	
    /** uNbv{[hɕʁvƂɕԂIDłB */
    static private final int COPY_ID = IDialogConstants.CLIENT_ID;
    
    /** uLZvƂɕԂIDłBv */
    static private final int CANCEL_ID = IDialogConstants.CANCEL_ID;
    
    
    
    /** uSGFeLXgv*/
    static private final MessageResource LB_DIALOG_TITLE
    		= new MessageResource(SgfTextDialog.class, "lbDialogTitle"); //$NON-NLS-1$

    /**uNbv{[hɕ(C)v*/
    static private final MessageResource CLB_COPY
    		= new MessageResource(SgfTextDialog.class, "clbCopy"); //$NON-NLS-1$
    
    /** utB^[IvVv*/
    static private final MessageResource CLB_GROUP_FILTER_OPTION 
    		= new MessageResource(SgfTextDialog.class, "clbGroupFilterOption"); //$NON-NLS-1$
    
    /** uSGFÕeLXgv*/
    static private final MessageResource CLB_UTR_COMBO
    		= new MessageResource(SgfTextDialog.class, "clbUtrCombo"); //$NON-NLS-1$

    /** u^ȎIʁv*/
    static private final MessageResource CLB_SGFID_OPTION
    		= new MessageResource(SgfTextDialog.class, "clbSgfidOption"); //$NON-NLS-1$
    
    /** us{0}v*/
    static private final MessageResource LB_LINE_SIZE 
    		= new MessageResource(SgfTextDialog.class, "lbLineSize"); //$NON-NLS-1$

    /**
     * Kvŏ̃^OK肷WłB
     */
    static private final Set<SgfId> requisiteIds_;
    
    static  {
    	Set<SgfId> set = new HashSet<SgfId>();
    	set.addAll(Arrays.asList(new SgfId[]{
    			SgfId.GAME_TYPE, SgfId.SIZE, SgfId.RESULT,
    			SgfId.PLAYER_WHITE, SgfId.PLAYER_BLACK,
    			SgfId.KOMI, SgfId.HANDICAP,
    			SgfId.ADD_WHITE, SgfId.ADD_BLACK, SgfId.ADD_EMPTY,
    			SgfId.WHITE, SgfId.BLACK,
    	}));
    	requisiteIds_ = Collections.unmodifiableSet(set);
    }
    
    
    private final Collection collection_;
    private final int activeGameIndex_;
    private SgfId[] sgfIds_;
    private RemoveUtrFilter.Option utrType_;
    private final EnumSet<InsertLineSeparatorFilter.Option> slbOptions_;

    private LabeledEnumCombo<RemoveUtrFilter.Option> utrCombo_;
    private LabeledEnumCombo<HandleSgfId> sgfIdCombo_;
    private Text text_;
    private CheckboxTableViewer rgtViewer_;
    private CheckboxTableViewer sgfIdViewer_;
    private Label lbLineSize_;
    private Scale scale_;
    
	/**
	 * @param shell
	 * @param collection
	 * @param activeGameIndex
	 */
	public SgfTextDialog(Shell parentShell, Collection collection, int activeGameIndex) {
		super(parentShell);
		ArgumentChecker.throwIfNull(collection);
		ArgumentChecker.throwIfNegative(activeGameIndex);
		setShellStyle(SWT.TITLE | SWT.RESIZE | SWT.APPLICATION_MODAL);
		
		collection_ = collection;
		activeGameIndex_ = activeGameIndex;
		utrType_ = RemoveUtrFilter.Option.REMOVE_ALL;
		slbOptions_ = EnumSet.noneOf(InsertLineSeparatorFilter.Option.class);
		
		utrCombo_ = new LabeledEnumCombo<RemoveUtrFilter.Option>(
				EnumSet.allOf(RemoveUtrFilter.Option.class),
				EnumSet.of(Style.READ_ONLY));
		utrCombo_.setText(CLB_UTR_COMBO.get());
		utrCombo_.addListener(new EnumSelectionAdapter<RemoveUtrFilter.Option>() {
			@Override
			public void itemSelected(RemoveUtrFilter.Option item) {
				utrType_ = item;
				updateText();
			}
		});
		
		sgfIdCombo_ = new LabeledEnumCombo<HandleSgfId>(
				EnumSet.allOf(HandleSgfId.class),
				EnumSet.of(Style.READ_ONLY));
		sgfIdCombo_.setText(CLB_SGFID_OPTION.get());
		sgfIdCombo_.addListener(new EnumSelectionAdapter<HandleSgfId>() {
			@Override
			public void itemSelected(HandleSgfId item) {
				updateSgfIdType(item);
				updateText();
			}
		});
		text_ = null;
		rgtViewer_ = null;
		sgfIdViewer_ = null;
		lbLineSize_ = null;
		scale_ = null;
		
		Set<SgfId> sgfIdSet = new HashSet<SgfId>();
		for (RootGameTree rgt : collection_) {
			addAllSgfId(rgt, sgfIdSet);
		}
		sgfIds_ = sgfIdSet.toArray(new SgfId[sgfIdSet.size()]);
		Arrays.sort(sgfIds_);	
	}
	
	


	
	/**
	 * ɑΉă^O̎蓮ݒESāEŏ̐؂ւs܂B
	 * @param handleSgfId
	 */
	private void updateSgfIdType(HandleSgfId handleSgfId) {
		switch (handleSgfId) {
		case MANUAL:
			for (TableItem tableItem : sgfIdViewer_.getTable().getItems()) {
				tableItem.setGrayed(false);
			}
			break;
			
		case ALL:
			for (TableItem tableItem : sgfIdViewer_.getTable().getItems()) {
				tableItem.setChecked(true);
				tableItem.setGrayed(true);
			}
			break;
			
		case REQUISITE:
			for (TableItem tableItem : sgfIdViewer_.getTable().getItems()) {
				tableItem.setChecked(requisiteIds_.contains(tableItem.getData()));
				tableItem.setGrayed(true);
			}
			break;

		default:
			assert false;
		}
	}
	
	
	/**
	 * ݑIĂ{@link RootGameTree}ŎgĂ{@link SgfId}
	 * 񋓂A{@link #sgfIds_}XV܂B
	 */
	private void updateSgfIds() {
		Collection collection = new Collection();
		for (RootGameTree rgt : collection_) {
			if (rgtViewer_.getChecked(rgt)) {
				collection.addLast(rgt);
			}
		}
		
		Set<SgfId> sgfIdSet = new HashSet<SgfId>();
		for (RootGameTree rgt : collection) {
			addAllSgfId(rgt, sgfIdSet);
		}
		Set<SgfId> uncheckedIds = new HashSet<SgfId>(Arrays.asList(sgfIds_));
		uncheckedIds.removeAll(Arrays.asList(sgfIdViewer_.getCheckedElements()));
		
		sgfIdViewer_.remove(sgfIds_);
		sgfIds_ = sgfIdSet.toArray(new SgfId[sgfIdSet.size()]);
		Arrays.sort(sgfIds_);
		sgfIdViewer_.add(sgfIds_);
		
		Set<SgfId> checkedIds = new HashSet<SgfId>(Arrays.asList(sgfIds_));
		checkedIds.removeAll(uncheckedIds);
		sgfIdViewer_.setCheckedElements(checkedIds.toArray());
		updateSgfIdType(sgfIdCombo_.getSelected());
	}
	
	/**
	 * 
	 * @param gameTree
	 * @param sgfidSet
	 */
	private void addAllSgfId(GameTree gameTree, Set<SgfId> sgfIdSet) {
		for (Node node : gameTree.getSequence()) {
			for (Property property : node.getProperties()) {
				sgfIdSet.add(property.sgfId());
			}
		}
		
		for (GameTree child : gameTree.getChildren()) {
			addAllSgfId(child, sgfIdSet);
		}
	}

	/**
	 * SGFeLXgGA݂̐ݒōXV܂B
	 */
	private void updateText() {
		List<SgfId> list = new ArrayList<SgfId>();
		for (Object object : sgfIdViewer_.getCheckedElements()) {
			list.add((SgfId)object);
		}
		SgfId[] includes = list.toArray(new SgfId[list.size()]);
		
		
		Collection collection = new Collection();
		for (int i = 0; i < collection_.size(); ++i) {
			if (rgtViewer_.getChecked(collection_.get(i))) {
				collection.addLast(collection_.get(i));
			}
		}
		Filter<Collection> filter = new RemoveSoftLineBreakFilter(new SieveBySgfIdFilter(includes));
		if (true) {
			RemoveUtrFilter removeUtrFilter = new RemoveUtrFilter(filter);
			removeUtrFilter.setOption(utrType_);
			filter = removeUtrFilter;
		}
		InsertLineSeparatorFilter ilsFilter = new InsertLineSeparatorFilter(filter, scale_.getSelection());
		ilsFilter.setOption(slbOptions_);
		filter = ilsFilter;
		
		collection = filter.filter(collection);
		String formatted = new SgfFormatter().formatAsString(collection);
		text_.setText(Swts.toWidgetText(formatted));
	}
	
	/* (non-Javadoc)
	 * @see org.eclipse.jface.dialogs.Dialog#createDialogArea(org.eclipse.swt.widgets.Composite)
	 */
	@Override
	protected Control createDialogArea(Composite parent) {
		getShell().setText(LB_DIALOG_TITLE.get());
		GridData gridData = (GridData)parent.getLayoutData();
		gridData.heightHint = 480; //TODO }WbNio[
		gridData.widthHint = 640;
		// KCompositeԂƂۏ
		Composite frame = (Composite)super.createDialogArea(parent);
		createTextArea(frame);
		createSliderArea(frame);		
		updateText();
		return frame;
	}

	/**
	 * eLXgƎcQ[ƃ^O\EҏWGA\z܂B
	 * @param parent
	 */
	private void createTextArea(Composite parent) {
		USashForm sashForm = WidgetFactory.createUSashForm(parent, SWT.HORIZONTAL);
		GridData gridData = new GridData(SWT.FILL, SWT.FILL, true, true);
		sashForm.setLayoutData(gridData);
		
		text_ = new Text(sashForm, SWT.BORDER | SWT.MULTI | SWT.H_SCROLL | SWT.V_SCROLL);
		createControlArea(sashForm);
		sashForm.setWeights(new int[]{1,-220});
	}

	/**
	 * cQ[ƃ^OʂɃ`FbNGA\z܂B
	 * @param parent
	 */
	private void createControlArea(Composite parent) {
		USashForm sashForm = WidgetFactory.createUSashForm(parent, SWT.VERTICAL);

		Composite composite = new Composite(sashForm, SWT.NONE);
		composite.setLayout(new GridLayout());
		
		// Q[̈ꗗ
		rgtViewer_ = CheckboxTableViewer.newCheckList(
				composite,
				SWT.FULL_SELECTION | SWT.SINGLE | SWT.BORDER | SWT.H_SCROLL | SWT.V_SCROLL);
		rgtViewer_.setLabelProvider(new RgtLabelProvider());
		
		for (int i = 0; i < collection_.size(); ++i) {
			RootGameTree rgt = collection_.get(i);
			rgtViewer_.add(rgt);
			if (i == activeGameIndex_) {
				rgtViewer_.setChecked(rgt, true);
			}
		}
		GridData gridData = new GridData(SWT.FILL, SWT.FILL, true, true);
		rgtViewer_.getTable().setLayoutData(gridData);
		rgtViewer_.addCheckStateListener(new ICheckStateListener() {
			public void checkStateChanged(CheckStateChangedEvent event) {
				updateSgfIds();
				updateText();
			}
		});
		createFilterControllerArea(composite);
		
		
		createSgfIdControllerArea(sashForm);
		sashForm.setWeights(new int[]{2,  3});
	}
	
	

	//--------------------------- tB^[IvVp̈֌W ----------------------------
	/**
	 * eLXgϊ̃tB^[̃IvVw肷GA\z܂B
	 * @param parent
	 */
	private void createFilterControllerArea(Composite parent) {
		Group group = new Group(parent, SWT.SHADOW_ETCHED_IN);
		
		GridData gridData = new GridData(SWT.FILL, SWT.CENTER, true, false);
		group.setLayoutData(gridData);
		
		group.setText(CLB_GROUP_FILTER_OPTION.get());
		group.setLayout(new RowLayout(SWT.VERTICAL));

		utrCombo_.createContents(group);
		utrCombo_.select(utrType_);
		createUseSlb(group, InsertLineSeparatorFilter.Option.USE_SLB_FOR_TEXT);
		createUseSlb(group, InsertLineSeparatorFilter.Option.USE_SLB_FOR_SIMPLETEXT);
	}

	/**
	 * @param parent
	 * @param option
	 */
	private void createUseSlb(Composite parent, final InsertLineSeparatorFilter.Option option) {
		final Button button = new Button(parent, SWT.CHECK);
		button.setText(option.toString());
		button.setSelection(slbOptions_.contains(option));
		button.addSelectionListener(new SelectionAdapter() {
			@Override
			public void widgetSelected(SelectionEvent e) {
				if (button.getSelection()) {
					slbOptions_.add(option);
				} else {
					slbOptions_.remove(option);
				}
				updateText();
			}
		});
	}
	//--------------------------- ^OIvVp̈֌W ----------------------------
	/**
	 * c^OʂɃ`FbNGA\z܂B
	 * @param composite
	 */
	private void createSgfIdControllerArea(Composite parent) {
		Composite composite = new Composite(parent, SWT.NONE);
		GridLayout gridLayout = new GridLayout();
		composite.setLayout(gridLayout);	
		
		GridData gridData;
		sgfIdCombo_.createContents(composite);

		
		// ۂ̃^O`FbN镔
		sgfIdViewer_ = CheckboxTableViewer.newCheckList(
				composite, 
				SWT.FULL_SELECTION | SWT.SINGLE | SWT.BORDER | 
				SWT.H_SCROLL | SWT.V_SCROLL);
		sgfIdViewer_.setLabelProvider(new SgfIdLabelProvider());

		Table table = sgfIdViewer_.getTable();
		gridData = new GridData(SWT.FILL, SWT.FILL, true, true);
		table.setLayoutData(gridData);
		table.setHeaderVisible(false);
		new TableColumn(table, SWT.CENTER);
		new TableColumn(table, SWT.LEFT);
		sgfIdViewer_.add(sgfIds_);
		sgfIdViewer_.setAllChecked(true);
		sgfIdViewer_.setAllGrayed(false);
		sgfIdViewer_.addCheckStateListener(new ICheckStateListener() {

			/* (non-Javadoc)
			 * @see org.eclipse.jface.viewers.ICheckStateListener#checkStateChanged(org.eclipse.jface.viewers.CheckStateChangedEvent)
			 */
			public void checkStateChanged(CheckStateChangedEvent event) {
				updateText();
			}
		});
		for (TableColumn column : table.getColumns()) {
			column.pack();
		}
		
		lbLineSize_ = new Label(composite, SWT.NONE);
		gridData = new GridData(SWT.FILL, SWT.BOTTOM, true, false);
		lbLineSize_.setLayoutData(gridData);
	}

	
	//--------------------------- XC_[̈֌W ----------------------------
	/**
	 * s̕\EҏWGA\z܂B
	 * @param frame
	 */
	private void createSliderArea(Composite parent) {
		scale_ = new Scale(parent, SWT.HORIZONTAL);
		GridData gridData = new GridData(SWT.FILL, SWT.BOTTOM, true, false);
		scale_.setLayoutData(gridData);
		scale_.setMinimum(10);
		scale_.setMaximum(100);
		scale_.setSelection(40);
		scale_.addSelectionListener(new SelectionAdapter() {
			/* (non-Javadoc)
			 * @see org.eclipse.swt.events.SelectionAdapter#widgetSelected(org.eclipse.swt.events.SelectionEvent)
			 */
			@Override
			public void widgetSelected(SelectionEvent e) {
				lbLineSize_.setText(LB_LINE_SIZE.get(String.valueOf(scale_.getSelection())));
				updateText();			
			}
		});
		lbLineSize_.setText(LB_LINE_SIZE.get(String.valueOf(scale_.getSelection())));
	}

	/* (non-Javadoc)
	 * @see org.eclipse.jface.dialogs.Dialog#createButtonsForButtonBar(org.eclipse.swt.widgets.Composite)
	 */
	@Override
	protected void createButtonsForButtonBar(Composite parent) {
        createButton(parent, COPY_ID, CLB_COPY.get(), false);
    	createButton(parent, CANCEL_ID, BasicMessages.LB_CANCEL.get(), true);	
    }

	/* (non-Javadoc)
	 * @see org.eclipse.jface.dialogs.Dialog#buttonPressed(int)
	 */
	@Override
	protected void buttonPressed(int buttonId) {
		switch (buttonId) {
		case COPY_ID:
			Clipboard cb = new Clipboard(Display.getCurrent());			
			TextTransfer textTransfer = TextTransfer.getInstance();
			cb.setContents(new Object[]{text_.getText()}, new Transfer[]{textTransfer});
			break;
			
		case CANCEL_ID:
			cancelPressed();
			break;
		} 
	}

	
	/**
	 * eLXgGAɕ\Q[({@link RootGameTree})
	 * ITableViewerp̃xvoC_[łB
	 * ReLXgW{@link RootGameTreeLabelProvider}g܂B 
	 */
	private class RgtLabelProvider extends LabelProvider {
		/* (non-Javadoc)
		 * @see org.eclipse.jface.viewers.LabelProvider#getText(java.lang.Object)
		 */
		@Override
		public String getText(Object element) {
			RootGameTreeLabelProvider provider = Yukinoshita.context().getProvider(
					RootGameTreeLabelProvider.class, null);
			return provider.getLabel((RootGameTree)element);
		}
	}
	
	/**
	 * c^OITableViewerp̃xvoC_[łB
	 * ڂIDAڂɖ̂Lڂ܂B
	 */
	private class SgfIdLabelProvider implements ITableLabelProvider {

		/* (non-Javadoc)
		 * @see org.eclipse.jface.viewers.ITableLabelProvider#getColumnImage(java.lang.Object, int)
		 */
		public Image getColumnImage(Object element, int columnIndex) {
			return null;
		}

		/* (non-Javadoc)
		 * @see org.eclipse.jface.viewers.ITableLabelProvider#getColumnText(java.lang.Object, int)
		 */
		public String getColumnText(Object element, int columnIndex) {
			if (!(element instanceof SgfId)) {
				return Strings.EMPTY;
			}
			SgfId sgfId = (SgfId)element;
			switch (columnIndex) {
				case 0: return sgfId.id();
				case 1: return sgfId.displayName();
			}
			return Strings.EMPTY;
		}

		/* (non-Javadoc)
		 * @see org.eclipse.jface.viewers.IBaseLabelProvider#addListener(org.eclipse.jface.viewers.ILabelProviderListener)
		 */
		public void addListener(ILabelProviderListener listener) {
			// Ȃ
		}

		/* (non-Javadoc)
		 * @see org.eclipse.jface.viewers.IBaseLabelProvider#dispose()
		 */
		public void dispose() {
			// Ȃ
		}

		/* (non-Javadoc)
		 * @see org.eclipse.jface.viewers.IBaseLabelProvider#isLabelProperty(java.lang.Object, java.lang.String)
		 */
		public boolean isLabelProperty(Object element, String property) {
			return false;
		}

		/* (non-Javadoc)
		 * @see org.eclipse.jface.viewers.IBaseLabelProvider#removeListener(org.eclipse.jface.viewers.ILabelProviderListener)
		 */
		public void removeListener(ILabelProviderListener listener) {
			// Ȃ
		}
	}
}
