/*  
 * Copyright 2005 unitarou <boss@unitarou.org>. 
 * All rights reserved.
 * 
 * This program and the accompanying materials are made available under the terms of 
 * the Common Public License v1.0 which accompanies this distribution, 
 * and is available at http://opensource.org/licenses/cpl.php
 * 
 * Contributors:
 *     unitarou - initial API and implementation
 */
package org.unitarou.yukinoshita.view.jface.dlg;

import java.io.File;
import java.util.ArrayList;
import java.util.List;

import org.eclipse.swt.SWT;
import org.eclipse.swt.widgets.FileDialog;
import org.eclipse.swt.widgets.Shell;

import org.unitarou.io.Ios;
import org.unitarou.util.ArgumentChecker;

/**
 * {@link org.eclipse.swt.widgets.FileDialog}̃bp[łB
 * ̃t@C_CAOƐ؂ւ悤ɂĂ܂B
 * 
 * @author unitarou &lt;boss@unitarou.org&gt; 
 */
class SwtFileChooser implements IgoFileChooser {
	
    /**
     * _CAOŌɊJƂ̃tH_[ێ܂B
     */
    static private File lastFolder_s_ = Ios.getCurrentDirectory();
    
    private final Style style_;
	
	private final FileDialog fileDialog_;
	
	/**
	 * 
	 */
	SwtFileChooser(Shell parent, Style style) {
		super();
		ArgumentChecker.throwIfNull(parent, style);
		style_ = style;
		
		int styleValue;
		switch (style) {
		case OPEN_FILE:
			styleValue = SWT.OPEN;
			break;

		case OPEN_FILES:
			styleValue = SWT.OPEN | SWT.MULTI;
			break;

		case SAVE_FILE:
			styleValue = SWT.SAVE;
			break;

		default:
			styleValue = SWT.NONE;
			assert false : "Unknown type :" + style; //$NON-NLS-1$
		}
	    fileDialog_ = new FileDialog(parent, styleValue | SWT.APPLICATION_MODAL);
	    fileDialog_.setFilterPath(lastFolder_s_.getAbsolutePath());
	}

	
		
	/* (non-Javadoc)
	 * @see org.unitarou.yukinoshita.view.jface.dlg.IgoFileChooser#open()
	 */
	public boolean chooseFile() {
		boolean ret = fileDialog_.open() != null;
		lastFolder_s_ = getFolder();
		return ret;
	}
	

	/* (non-Javadoc)
	 * @see org.unitarou.yukinoshita.view.jface.dlg.IgoFileChooser#getFolder()
	 */
	public File getFolder() {
		File file = new File(fileDialog_.getFilterPath());
		while (!(file == null || file.isDirectory())) {
			file = file.getParentFile();
		}
		return (file == null) ? Ios.getCurrentDirectory() : file;
	}

	/* (non-Javadoc)
	 * @see org.unitarou.yukinoshita.view.jface.dlg.IgoFileChooser#getFile()
	 */
	public File getFile() {
		String filename = fileDialog_.getFileName();
		return (filename.length() != 0) ? new File(fileDialog_.getFilterPath(), filename) : null;
	}

	/* (non-Javadoc)
	 * @see org.unitarou.yukinoshita.view.jface.dlg.IgoFileChooser#getFiles()
	 */
	public File[] getFiles() {
		String[] filenames = fileDialog_.getFileNames();
		List<File> ret = new ArrayList<File>(filenames.length);
		for (String filename : filenames) {
			ret.add(new File(fileDialog_.getFilterPath(), filename));
		}
		return ret.toArray(new File[ret.size()]);
	}

	/* (non-Javadoc)
	 * @see org.unitarou.yukinoshita.view.jface.dlg.IgoFileChooser#setFile(java.io.File)
	 */
	public void setFile(File file) {
		ArgumentChecker.throwIfNull(file);
		fileDialog_.setFileName(file.getName());
	}

	/* (non-Javadoc)
	 * @see org.unitarou.yukinoshita.view.jface.dlg.IgoFileChooser#setFileName(java.lang.String)
	 */
	public void setFileName(String filename) {
		ArgumentChecker.throwIfNull(filename);
		fileDialog_.setFileName(filename);
	}

	/* (non-Javadoc)
	 * @see org.unitarou.yukinoshita.view.jface.dlg.IgoFileChooser#setFolder(java.io.File)
	 */
	public void setFolder(File file) {
		ArgumentChecker.throwIfNull(file);
		if (!file.isDirectory()) {
			throw new IllegalArgumentException("Argument must be a directory:" + file); //$NON-NLS-1$
		}
		
		fileDialog_.setFilterPath(file.getAbsolutePath());
	}


	/* (non-Javadoc)
	 * @see org.unitarou.yukinoshita.view.jface.dlg.IgoFileChooser#setFilter(org.unitarou.yukinoshita.view.jface.dlg.NamedFileFilter[])
	 */
	public void setFilter(NamedFileFilter[] filters) {
		ArgumentChecker.throwIfNull((Object)filters);
		
		String[] filterNames = new String[filters.length];
		String[] filterExts = new String[filters.length];
		for (int i = 0; i < filters.length; ++i) {
			filterNames[i] = filters[i].displayName();
			String[] wildcards = filters[i].getWildcards();
			StringBuilder builder = new StringBuilder();
			for(String wildcard : wildcards) {
				builder.append(wildcard).append(", "); //$NON-NLS-1$
			}
			if (wildcards.length != 0) {
				builder.delete(builder.length() - 2, builder.length());
			}
			filterExts[i] = builder.toString();
		}
        fileDialog_.setFilterNames(filterNames);
        fileDialog_.setFilterExtensions(filterExts);
	}
	
	

	/* (non-Javadoc)
	 * @see org.eclipse.swt.widgets.Dialog#getParent()
	 */
	public Shell getParent() {
		return fileDialog_.getParent();
	}

	/* (non-Javadoc)
	 * @see org.eclipse.swt.widgets.Dialog#getStyle()
	 */
	public Style getStyle() {
		return style_;
	}

	/* (non-Javadoc)
	 * @see org.eclipse.swt.widgets.Dialog#getText()
	 */
	public String getText() {
		return fileDialog_.getText();
	}

	/* (non-Javadoc)
	 * @see org.eclipse.swt.widgets.Dialog#setText(java.lang.String)
	 */
	public void setText(String string) {
		fileDialog_.setText(string);
	}
}
