/*  
 * Copyright 2005 unitarou <boss@unitarou.org>. 
 * All rights reserved.
 * 
 * This program and the accompanying materials are made available under the terms of 
 * the Common Public License v1.0 which accompanies this distribution, 
 * and is available at http://opensource.org/licenses/cpl.php
 * 
 * Contributors:
 *     unitarou - initial API and implementation
 */
package org.unitarou.yukinoshita.view.jface.dr;

import java.io.File;
import java.util.EnumSet;
import java.util.HashMap;
import java.util.Map;

import org.apache.commons.io.FilenameUtils;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.eclipse.jface.viewers.AbstractTreeViewer;
import org.eclipse.jface.viewers.ISelectionChangedListener;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.SelectionChangedEvent;
import org.eclipse.jface.viewers.StructuredSelection;
import org.eclipse.jface.viewers.TreeViewer;
import org.eclipse.swt.SWT;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.FillLayout;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.layout.RowLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Group;
import org.eclipse.swt.widgets.Label;

import org.unitarou.io.Ios;
import org.unitarou.lang.Strings;
import org.unitarou.ml.MessageResource;
import org.unitarou.sgf.Collection;
import org.unitarou.sgf.Property;
import org.unitarou.sgf.RootGameTree;
import org.unitarou.sgf.SgfId;
import org.unitarou.sgf.Value;
import org.unitarou.sgf.type.GameType;
import org.unitarou.sgf.type.ProblemProperties.Flag;
import org.unitarou.util.ArgumentChecker;
import org.unitarou.util.StopWatch;
import org.unitarou.yukinoshita.events.EventBroker;
import org.unitarou.yukinoshita.events.ModelEventNotifier;
import org.unitarou.yukinoshita.model.CollectionEditor;
import org.unitarou.yukinoshita.model.NodeView;
import org.unitarou.yukinoshita.model.cmd.UpdateProperty;
import org.unitarou.yukinoshita.view.cmd.FocusInDrillEditorCommand;
import org.unitarou.yukinoshita.view.cmd.ShowDrillCommand;
import org.unitarou.yukinoshita.view.jface.SelectablePanel;
import org.unitarou.yukinoshita.view.jface.dlg.IgoFileDialog;
import org.unitarou.yukinoshita.view.jface.dlg.IgoFileChooser.Style;
import org.unitarou.yukinoshita.view.monitor.CollectionMonitor;
import org.unitarou.yukinoshita.view.monitor.NodeMonitor;
import org.unitarou.yukinoshita.view.monitor.OutlineMonitor;

/**
 * W̕ҏWsplłB
 * 
 * @author unitarou &lt;boss@unitarou.org&gt; 
 */
public class DrillEditorPanel implements SelectablePanel {
	
	static private final Log log_s_ = LogFactory.getLog(DrillEditorPanel.class);

	/** uc[J(&X)v*/
	static private final MessageResource CLB_EXPAND_ALL
			= new MessageResource(DrillEditorPanel.class, "clbExpandAll"); //$NON-NLS-1$

	/** uc[(&C)v*/
	static private final MessageResource CLB_COLLAPSE_ALL
			= new MessageResource(DrillEditorPanel.class, "clbCollapseAll"); //$NON-NLS-1$

	/** uIvV(&O)v*/
	static private final MessageResource CLB_GROUP_OPTION
			= new MessageResource(DrillEditorPanel.class, "clbGroupOption"); //$NON-NLS-1$
	
	/** uǉ(&A)v */
	static private final MessageResource CLB_ADD 
			= new MessageResource(DrillEditorPanel.class, "clbAdd"); //$NON-NLS-1$

	/** u(&U)v */
	static private final MessageResource CLB_UP 
			= new MessageResource(DrillEditorPanel.class, "clbUp"); //$NON-NLS-1$
	
	/** u(&D)v */
	static private final MessageResource CLB_DOWN 
			= new MessageResource(DrillEditorPanel.class, "clbDown"); //$NON-NLS-1$

	/** uҏW(&E)v */
	static private final MessageResource CLB_EDIT
			= new MessageResource(DrillEditorPanel.class, "clbEdit"); //$NON-NLS-1$

	/** u폜(&R)v */
	static private final MessageResource CLB_REMOVE
			= new MessageResource(DrillEditorPanel.class, "clbRemove"); //$NON-NLS-1$

	/** ̃NX̃A_v^[łB */
	private final Adapter adapter_;
	
	
	/** 
	 * ݕҏWĂ^[QbgłB
	 */
	private CollectionEditor collectionEditor_;
	
	
	/**
	 * ۂɕҏWsĂIFvpeBłB
	 */
	private Property ifProperty_;
	
	private final SelectionListener cbSelectionListener_;
	
    private EventBroker eventBroker_;

	private Composite frame_;
	private TreeViewer treeViewer_;
	
	/**
	 * PPvpeBp̃`FbN{bNX}bvB<br>
	 * L[͊e`FbN{bNXɑΉ{@link org.unitarou.sgf.type.ProblemProperties.Flag}
	 */
	private final Map<Flag, Button> cbPpMap_;

	/**
	 * R}hL[ɂ}bvB
	 */
	private final Map<String, Button> btCommandMap_;
	
	

	/**
	 * 
	 */
	public DrillEditorPanel() {
		super();
		adapter_ = new Adapter();
		eventBroker_ = EventBroker.NULL_BROKER;
		btCommandMap_ = new HashMap<String, Button>();
		cbPpMap_ = new HashMap<Flag, Button>();
		cbSelectionListener_ = new SelectionListenerImpl();
	}

	/* (non-Javadoc)
	 * @see org.unitarou.lang.Adaptable#getAdapter(java.lang.Class)
	 */
	public Object getAdapter(Class<?> adapter) {
		if (adapter == null) {
			return null;
		}
		if (adapter.isAssignableFrom(adapter_.getClass())) {
			return adapter_;
		}
		return null;
	}

	/* (non-Javadoc)
	 * @see org.unitarou.swt.WidgetContainer#createContents(org.eclipse.swt.widgets.Composite)
	 */
	public Control createContents(Composite parent) {
		ArgumentChecker.throwIfNull(parent);

		frame_ = new Composite(parent, SWT.NONE);
		frame_.setLayout(new GridLayout(1, true));
		createProblemPropertyContents(frame_);
		
		createTreeHandlerContents(frame_);
		treeViewer_ = new TreeViewer(frame_, SWT.V_SCROLL | SWT.BORDER);
		treeViewer_.getControl().setLayoutData(new GridData(SWT.FILL, SWT.FILL, true, true));
		treeViewer_.addPostSelectionChangedListener(adapter_);
		
		createControllerContents(frame_);
		
		treeViewer_.setContentProvider(new IfContentProvider());
		treeViewer_.setLabelProvider(new IfLabelProvider());
		return frame_;
	}
	
	/**
	 * PPS^OGameInfoMoveɕύX̂łɕҏWRg[B
	 * {@link #cbPpMap_}Ƀ`FbN{bNX͒ǉ܂B
	 * @param frame
	 */
	private void createProblemPropertyContents(Composite frame) {
		Group group = new Group(frame, SWT.SHADOW_ETCHED_IN);
		group.setText(CLB_GROUP_OPTION.get());
		group.setLayout(new FillLayout(SWT.VERTICAL));
		EnumSet<Flag> set = EnumSet.allOf(Flag.class);
		for (Flag flag : set) {
			Button cb = new Button(group, SWT.CHECK);
			cb.setText(flag.getDisplayName());
			cbPpMap_.put(flag, cb);
			cb.addSelectionListener(cbSelectionListener_);
		}
	}
	
	/**
	 * {@link #treeViewer_}̊JAȂǁAfɉe^Ȃc[̕ҏW
	 * sRg[plłB
	 * @param frame
	 */
	private void createTreeHandlerContents(Composite frame) {
		Composite buttonFrame = new Composite(frame_, SWT.NONE);
		buttonFrame.setLayoutData(new GridData(SWT.FILL, SWT.END, true, false));
		buttonFrame.setLayout(new RowLayout(SWT.HORIZONTAL));		
		Button button;
		button = new Button(buttonFrame, SWT.PUSH);
		button.setText(CLB_EXPAND_ALL.get());
		button.addSelectionListener(new SelectionAdapter() {
			@Override
			public void widgetSelected(SelectionEvent e) {
				treeViewer_.expandAll();
			}
		});

		button = new Button(buttonFrame, SWT.PUSH);
		button.setText(CLB_COLLAPSE_ALL.get());
		button.addSelectionListener(new SelectionAdapter() {
			@Override
			public void widgetSelected(SelectionEvent e) {
				treeViewer_.collapseAll();
			}
		});
	}
	
	/**
	 * {@link #treeViewer_}̕ҏWsRg[plłB
	 * @param frame
	 */
	private void createControllerContents(Composite frame) {
		Composite buttonFrame = new Composite(frame_, SWT.NONE);
		buttonFrame.setLayoutData(new GridData(SWT.FILL, SWT.END, true, false));
		buttonFrame.setLayout(new RowLayout(SWT.HORIZONTAL));
		Button button;
		button = new Button(buttonFrame, SWT.PUSH);
		button.setText(CLB_ADD.get());
		button.addSelectionListener(new SelectionAdapter() {
			@Override
			public void widgetSelected(SelectionEvent e) {addClick(e);	}
		});
		btCommandMap_.put("add", button); //$NON-NLS-1$
		
		new Label(buttonFrame, SWT.NONE).setText(" "); //$NON-NLS-1$

		button = new Button(buttonFrame, SWT.PUSH);
		button.setText(CLB_UP.get());
		button.addSelectionListener(new SelectionAdapter() {
			@Override
			public void widgetSelected(SelectionEvent e) {upClick(e);	}
		});
		btCommandMap_.put("up", button); //$NON-NLS-1$

		button = new Button(buttonFrame, SWT.PUSH);
		button.setText(CLB_DOWN.get());
		button.addSelectionListener(new SelectionAdapter() {
			@Override
			public void widgetSelected(SelectionEvent e) {downClick(e);	}
		});
		btCommandMap_.put("down", button); //$NON-NLS-1$

		button = new Button(buttonFrame, SWT.PUSH);
		button.setText(CLB_EDIT.get());
		button.addSelectionListener(new SelectionAdapter() {
			@Override
			public void widgetSelected(SelectionEvent e) {editClick(e);	}
		});
		btCommandMap_.put("edit", button); //$NON-NLS-1$
		
		new Label(buttonFrame, SWT.NONE).setText(" "); //$NON-NLS-1$
		button = new Button(buttonFrame, SWT.PUSH);
		button.setText(CLB_REMOVE.get());
		button.addSelectionListener(new SelectionAdapter() {
			@Override
			public void widgetSelected(SelectionEvent e) {removeClick(e);	}
		});
		btCommandMap_.put("remove", button); //$NON-NLS-1$
	}
	
	/**
	 * TreeViewer̗vfIꂽƂɌĂяo܂B
	 * @param event {@link ISelectionChangedListener#selectionChanged(org.eclipse.jface.viewers.SelectionChangedEvent)}
	 *               ̈Ɠl
	 */
	private void selectItem(SelectionChangedEvent event) {
		int index = findSelectedIndex();
		btCommandMap_.get("edit").setEnabled(index != -1); //$NON-NLS-1$
		btCommandMap_.get("remove").setEnabled(index != -1); //$NON-NLS-1$
		btCommandMap_.get("up").setEnabled(0 < index); //$NON-NLS-1$
		btCommandMap_.get("down").setEnabled(0 <= index && index < ifProperty_.size() - 1); //$NON-NLS-1$

		if (event.getSelection() instanceof StructuredSelection) {
			StructuredSelection structuredSelection = (StructuredSelection)event.getSelection();
			Object element = structuredSelection.getFirstElement();

			if (element instanceof IfElement) {
				eventBroker_.executeCommand(
						new FocusInDrillEditorCommand(
								((IfElement)element).getCollection()));
			} else if (element instanceof RootGameTree) {
				eventBroker_.executeCommand(
						new FocusInDrillEditorCommand((RootGameTree)element));
			}
		}
	}
	
	/**
	 * ǉ{^ꂽƂɌĂяo܂B
	 * t@CĨ_CAOJAݑIĂc[̒OItemǉ܂B
	 * @param e
	 */
	private void addClick(SelectionEvent e) {
		int index = findSelectedIndex();
		if (index == -1) {
			index = 0;
		}
		
		// [UɃt@Cw肳
		IgoFileDialog igoFileDialog = new IgoFileDialog(frame_.getShell(), Style.OPEN_FILES);
		igoFileDialog.setFolder(collectionEditor_.getCollection().getFile());
		igoFileDialog.open();
		File[] filenames = igoFileDialog.getFiles();
		if ((filenames == null) || (filenames.length == 0)){
			return;
		}
		
		String[] lastData = ifProperty_.getStrings();
		String[] data = new String[lastData.length + filenames.length];
		System.arraycopy(lastData, 0, data, 0, index);

		// 
		File file = collectionEditor_.getCollection().getFile();
		int offset = 0;
		for (File filename : filenames) {
			String rp = Ios.calcRelativePath(file.getParent(), filename.getAbsolutePath());
			data[index + offset] = FilenameUtils.separatorsToUnix(rp);
			++offset;
		}
		for (int i = index + offset; i < data.length; ++i) {
			data[i] = lastData[i - offset];
		}
		updateIfProperty(data);
	}
	
	/**
	 * Ƀ{^ꂽƂɌĂяo܂B
	 * ݑIĂ{@link IfElement}A{@link IfElement}Ɠւ܂B
	 * @param e
	 */
	private void upClick(SelectionEvent e) {
		int index = findSelectedIndex();
		if (index  < 1) {
			return;
		}
		String[] data = ifProperty_.getStrings();
		String des = data[index - 1];
		data[index - 1] = data[index];
		data[index] = des;
		updateIfProperty(data);
	}

	/**
	 * Ƀ{^ꂽƂɌĂяo܂B
	 * ݑIĂ{@link IfElement}A{@link IfElement}Ɠւ܂B
	 * @param e
	 */
	private void downClick(SelectionEvent e) {
		int index = findSelectedIndex();
		String[] data = ifProperty_.getStrings();
		if ((index == -1) || (data.length - 1 <= index)) {
			return;
		}
		String des = data[index];
		data[index] = data[index + 1];
		data[index + 1] = des;
		updateIfProperty(data);
	}

	/**
	 * ҏW{^ꂽƂɌĂяo܂B
	 * ݑIĂ{@link IfElement}ԂƂ_CAOJA
	 * ݂TopElementƓւ܂B
	 * 
	 * @param e
	 */
	private void editClick(SelectionEvent e) {
		int index = findSelectedIndex();
		if (index == -1) {
			return;
		}
		File file = collectionEditor_.getCollection().getFile();
		// [UɃt@Cw肳
		IgoFileDialog igoFileDialog = new IgoFileDialog(frame_.getShell(), Style.OPEN_FILE);
		String[] data = ifProperty_.getStrings();
		String filename = data[index];
		igoFileDialog.setFolder(new File(file.getParent(), filename));
		if (!igoFileDialog.open()) {
			return;
		}
		
		String newFilename = igoFileDialog.getFile().getAbsolutePath();
		String rp = Ios.calcRelativePath(file.getParent(), newFilename);
		data[index] = rp;
		updateIfProperty(data);
	}

	/**
	 * 폜{^ꂽƂɌĂяo܂B
	 * ݑIĂ{@link IfElement}폜܂B
	 *  
	 * @param e
	 */
	private void removeClick(SelectionEvent e) {
		int index = findSelectedIndex();
		if (index == -1) {
			return;
		}
		
		String[] lastData = ifProperty_.getStrings();
		String[] data = new String[lastData.length - 1];
		System.arraycopy(lastData, 0, data, 0, index);

		// 
		for (int i = index; i < data.length; ++i) {
			data[i] = lastData[i + 1];
		}
		
		Property remove = new Property(SgfId.INPUT_FILES, lastData[index]);
		ifProperty_.clear();
		ifProperty_.setId(SgfId.INPUT_FILES.id());
		for(String datum : data) {
			ifProperty_.addValue(new Value(datum));
		}
		eventBroker_.executeCommand(
				new UpdateProperty(new Property[]{remove}, ifProperty_, null));
	}
	
	
	/**
	 * {@link #ifElements_}̒猻ݑIĂIuWFNgA
	 * ꍇɂ͂̃CfbNXԂ܂B
	 * @return obj{@link #ifElements_}ł̃CfbNXBȂꍇ-1
	 */
	private int findSelectedIndex() {
		IStructuredSelection selection = (IStructuredSelection)treeViewer_.getSelection();
		Object obj = selection.getFirstElement();
		if (!(obj instanceof IfElement)) {
			return -1;
		}
		
		String lastFileName = FilenameUtils.separatorsToUnix(((IfElement)obj).getInputFileName());
		String[] filnames = ifProperty_.getStrings();
		for (int i = 0; i < filnames.length; ++i) {
			if (filnames[i].equals(lastFileName)) {
				return i;
			}
		}
		return -1;
	}
	
	
	/**
	 * dataIFvpeB\āA
	 * {@link #eventBroker_}ɍXVʒm܂B
	 * @param data IFvpeB̐Vl 
	 */
	private void updateIfProperty(String[] data) {
		ifProperty_.clear();
		ifProperty_.setId(SgfId.INPUT_FILES.id());
		for(String datum : data) {
			ifProperty_.addValue(new Value(datum));
		}
		eventBroker_.executeCommand(
				new UpdateProperty(new Property[0], ifProperty_, null));
	}
	
	/**
	 * `FbN{bNX̉ɂPPvpeB̐ݒ肪ύXɂȂƂɌĂяo܂B
	 */
	private void updatePpProperty() {
		int val = 0;
		for (Map.Entry<Flag, Button> entry : cbPpMap_.entrySet()) {
			if (entry.getValue().getSelection()) {
				val |= entry.getKey().getValue();
			} else {
				val &= ~entry.getKey().getValue();
			}
		}
		Property property = new Property(SgfId.PROBLEM_PROPERTIES, Integer.toString(val));
		eventBroker_.executeCommand(
				new UpdateProperty(new Property[0], property, null));
	}

	/* (non-Javadoc)
	 * @see org.unitarou.yukinoshita.view.jface.gm.SelectablePanel#getControl()
	 */
	public Control getControl() {
		return frame_;
	}

	/* (non-Javadoc)
	 * @see org.unitarou.swt.WidgetContainer#dispose()
	 */
	public void dispose() {
		// ͕sv
	}
	
	
	/**
	 * {@link #treeViewer_}̓̓CX^X{@link #ifProperty_}XV܂B
	 * @param inputFileNames IFvpeB̒lB 
	 */
	private void updateTreeViewer() {
		StopWatch stopWatch = new StopWatch();
		IStructuredSelection selection = (IStructuredSelection)treeViewer_.getSelection();
		Object obj = selection.getFirstElement();
		String lastValue = Strings.EMPTY;
		if (obj instanceof IfElement) {
			lastValue = ((IfElement)obj).getInputFileName();
		}
		File file = collectionEditor_.getCollection().getFile();
		IfElement select = null;
		String[] values = ifProperty_.getStrings();
		IfElement[] ifElements = new IfElement[values.length];
		for (int i = 0; i < ifElements.length; i++) {
			ifElements[i] = new IfElement(
					file.getParent(), 
					FilenameUtils.separatorsToSystem(values[i]));
			if (ifElements[i].getInputFileName().equals(lastValue)) {
				select = ifElements[i];
			}
		}
		treeViewer_.setInput(ifElements);
		if (select != null) {
			treeViewer_.setSelection(new StructuredSelection(select));
		}
		
		Collection[] collections = new Collection[ifElements.length];
		for (int i = 0; i < collections.length; ++i) {
			collections[i] = ifElements[i].getCollection();
		}
		
		if (log_s_.isTraceEnabled()) {
			log_s_.trace(stopWatch.lapSecond() + " secs for getCollection"); //$NON-NLS-1$
		}
		
		eventBroker_.executeCommand(new ShowDrillCommand(collections));
		
		if (log_s_.isTraceEnabled()) {
			log_s_.trace(stopWatch.stopSecond() + " secs for execute ShowDrillCommand"); //$NON-NLS-1$
		}
	}

	/**
	 * `FbN{bNX̕ύXEHb`郊Xi[łB
	 */
	private class SelectionListenerImpl extends SelectionAdapter {

		/* (non-Javadoc)
		 * @see org.eclipse.swt.events.SelectionAdapter#widgetSelected(org.eclipse.swt.events.SelectionEvent)
		 */
		@Override
		public void widgetSelected(SelectionEvent e) {
			updatePpProperty();
		}
	}

	/**
	 * ̃pl̃A_v^[łB
	 */
	private class Adapter 
			implements ModelEventNotifier, CollectionMonitor, NodeMonitor, OutlineMonitor, ISelectionChangedListener
	{
		/* (non-Javadoc)
		 * @see org.unitarou.yukinoshita.events.ModelEventNotifier#setEventBroker(org.unitarou.yukinoshita.events.EventBroker)
		 */
		public void setEventBroker(EventBroker eventBroker) {
            ArgumentChecker.throwIfNull(eventBroker);
            
            eventBroker_.removeView(DrillEditorPanel.this);
            eventBroker_ = eventBroker;
            eventBroker_.addView(DrillEditorPanel.this);
		}

		/* (non-Javadoc)
		 * @see org.unitarou.yukinoshita.view.CollectionMonitor#update(org.unitarou.yukinoshita.model.CollectionEditor)
		 */
		public void update(CollectionEditor collectionEditor) {
			ArgumentChecker.throwIfNull(collectionEditor);
			collectionEditor_ = collectionEditor;
		}

		/* (non-Javadoc)
		 * @see org.unitarou.yukinoshita.view.NodeMonitor#update(org.unitarou.yukinoshita.model.NodeView)
		 */
		public void currentChanged(NodeView nodeView) {
			ArgumentChecker.throwIfNull(nodeView);

			// ݂RootGameTreeDRILLȊOł͉ȂB
			if (!GameType.DRILL.equals(nodeView.getRootView().getGameType())) {
				return;
			}
			
			ifProperty_ = nodeView.getProperty(SgfId.INPUT_FILES);
			if (ifProperty_ == null) {
				ifProperty_ = new Property();
				ifProperty_.setId(SgfId.INPUT_FILES.id());
			}
			updateTreeViewer();
			
			int val = 0;
			Property property = nodeView.getProperty(SgfId.PROBLEM_PROPERTIES);
			if (property != null) {
				String value = property.getString();
				try {
					val = Integer.parseInt(value);
				} catch (NumberFormatException e) {
					// OoĉȂB
				}
			}
			for (Map.Entry<Flag, Button> entry : cbPpMap_.entrySet()) {
				entry.getValue().setSelection(0 != (entry.getKey().getValue() & val));
			}
		}

		/* (non-Javadoc)
		 * @see org.unitarou.yukinoshita.view.OutlineMonitor#show(org.unitarou.sgf.Collection[])
		 */
		public void show(Collection[] collections) {
			// Ȃ
		}

		/* (non-Javadoc)
		 * @see org.unitarou.yukinoshita.view.OutlineMonitor#setFocus(org.unitarou.sgf.Collection)
		 */
		public void setFocus(Collection collection) {
			IfElement[] ifElements = (IfElement[])treeViewer_.getInput();
			for (IfElement ifElement : ifElements) {
				if (ifElement.getCollection().equals(collection)) {
					treeViewer_.removePostSelectionChangedListener(adapter_);
					treeViewer_.setSelection(new StructuredSelection(ifElement));
					treeViewer_.addPostSelectionChangedListener(adapter_);
					return;
				}
			}
			
		}

		/* (non-Javadoc)
		 * @see org.unitarou.yukinoshita.view.OutlineMonitor#setFocus(org.unitarou.sgf.RootGameTree)
		 */
		public void setFocus(RootGameTree rootGameTree) {
			IfElement[] ifElements = (IfElement[])treeViewer_.getInput();
			for (IfElement ifElement : ifElements) {
				Collection collection = ifElement.getCollection();
				for (int i = 0; i < collection.size(); ++i) {
					if (collection.get(i).equals(rootGameTree)) {
						treeViewer_.removePostSelectionChangedListener(adapter_);
						treeViewer_.setSelection(new StructuredSelection(ifElement));
						treeViewer_.expandToLevel(rootGameTree, AbstractTreeViewer.ALL_LEVELS);
						treeViewer_.setSelection(new StructuredSelection(rootGameTree));
						treeViewer_.addPostSelectionChangedListener(adapter_);
						return;
					}
				}
			}
		}

		/* (non-Javadoc)
		 * @see org.eclipse.jface.viewers.ISelectionChangedListener#selectionChanged(org.eclipse.jface.viewers.SelectionChangedEvent)
		 */
		public void selectionChanged(SelectionChangedEvent event) {
			selectItem(event);
		}
	}
}
