/*  
 * Copyright 2005 unitarou <boss@unitarou.org>. 
 * All rights reserved.
 * 
 * This program and the accompanying materials are made available under the terms of 
 * the Common Public License v1.0 which accompanies this distribution, 
 * and is available at http://opensource.org/licenses/cpl.php
 * 
 * Contributors:
 *     unitarou - initial API and implementation
 */
package org.unitarou.yukinoshita.view.jface.dr;


import org.unitarou.sgf.Collection;
import org.unitarou.sgf.RootGameTree;
import org.unitarou.util.Adaptable;
import org.unitarou.util.ArgumentChecker;
import org.unitarou.yukinoshita.events.EventBroker;
import org.unitarou.yukinoshita.events.TieredModelEventNotifier;
import org.unitarou.yukinoshita.view.jface.board.CollectionsPanel;
import org.unitarou.yukinoshita.view.jface.board.IgoOutlinePanelFactory;
import org.unitarou.yukinoshita.view.monitor.OutlineMonitor;

/**
 * DrillIFvpeBۂ̋lt@C\邽߁A
 * {@link org.unitarou.yukinoshita.view.jface.board.IgoOutlinePanel}
 * ^Cɔzuĕ\plłB
 * 
 * @author unitarou &lt;boss@unitarou.org&gt; 
 */
public class DrillViewerPanel extends CollectionsPanel<ProblemOutlinePanel> implements Adaptable {
	/**
	 * {@link ProblemOutlinePanel}Ԃt@Ng[łB
	 */
	static private class FactoryImpl implements IgoOutlinePanelFactory<ProblemOutlinePanel> {

		/* (non-Javadoc)
		 * @see org.unitarou.yukinoshita.view.jface.board.IgoOutlinePanelFactory#create()
		 */
		public ProblemOutlinePanel create() {
			return new ProblemOutlinePanel();
		}
	}


	private final Adapter adapter_;
	private EventBroker eventBroker_;
	
	/**
	 * Sŕ\s܂B
	 */
	public DrillViewerPanel() {
		super(new FactoryImpl(), 4);
		adapter_ = new Adapter();
		eventBroker_ = EventBroker.NULL_BROKER;
	}

	/* (non-Javadoc)
	 * @see org.unitarou.lang.Adaptable#getAdapter(java.lang.Class)
	 */
	public Object getAdapter(Class adapter) {
        if (adapter == null) {
            return null;
        }
        if (adapter.isInstance(adapter_)){
            return adapter_;
        }
        return null;
	}

	/**
	 * ̃NX̃A_v^[łB 
	 */
	private class Adapter extends TieredModelEventNotifier implements OutlineMonitor {

		/* (non-Javadoc)
		 * @see org.unitarou.yukinoshita.events.ModelEventNotifier#setEventBroker(org.unitarou.yukinoshita.events.EventBroker)
		 */
		@Override
		public void setEventBroker(EventBroker eventBroker) {
			ArgumentChecker.throwIfNull(eventBroker);
			
			eventBroker_.removeView(DrillViewerPanel.this);
			eventBroker_ = eventBroker;
			eventBroker_.addView(DrillViewerPanel.this);
			super.setEventBroker(eventBroker);
		}

		/* (non-Javadoc)
		 * @see org.unitarou.yukinoshita.events.TieredModelEventNotifier#getAdaptables()
		 */
		@Override
		protected Adaptable[] getAdaptables() {
			return DrillViewerPanel.this.getPanels(new ProblemOutlinePanel[0]);
		}

		/* (non-Javadoc)
		 * @see org.unitarou.yukinoshita.view.OutlineMonitor#show(org.unitarou.sgf.Collection[])
		 */
		public void show(Collection[] collections) {
			DrillViewerPanel.this.set(collections);
			// TuNXɍĐݒ
			super.setEventBroker(eventBroker_);
		}

		/* (non-Javadoc)
		 * @see org.unitarou.yukinoshita.view.OutlineMonitor#showHighlight(org.unitarou.sgf.Collection)
		 */
		public void setFocus(Collection collection) {
			DrillViewerPanel.this.setFocus(collection);
		}

		/* (non-Javadoc)
		 * @see org.unitarou.yukinoshita.view.OutlineMonitor#showHighlight(org.unitarou.sgf.RootGameTree)
		 */
		public void setFocus(RootGameTree rootGameTree) {
			DrillViewerPanel.this.setFocus(rootGameTree);
		}
	}

}
