/*  
 * Copyright 2005 unitarou <boss@unitarou.org>. 
 * All rights reserved.
 * 
 * This program and the accompanying materials are made available under the terms of 
 * the Common Public License v1.0 which accompanies this distribution, 
 * and is available at http://opensource.org/licenses/cpl.php
 * 
 * Contributors:
 *     unitarou - initial API and implementation
 */
package org.unitarou.yukinoshita.view.jface.dr;

import org.eclipse.jface.viewers.ITreeContentProvider;
import org.eclipse.jface.viewers.Viewer;

import org.unitarou.sgf.RootGameTree;

/**
 * {@link #inputChanged(Viewer, Object, Object)}
 * {@link org.unitarou.yukinoshita.view.jface.dr.IfElement}
 * 󂯎AŏʂIFvpeB̒lA
 * ̎q{@link org.unitarou.sgf.RootGameTree}ԂvoC_[łB
 * 
 * @author unitarou &lt;boss@unitarou.org&gt; 
 */
class IfContentProvider implements ITreeContentProvider {

	/**
	 * 
	 */
	private IfElement[] ifElements_;

	/**
	 * @param panel
	 */
	IfContentProvider() {
		super();
	}


	/* (non-Javadoc)
	 * @see org.eclipse.jface.viewers.ITreeContentProvider#getChildren(java.lang.Object)
	 */
	public Object[] getChildren(Object parentElement) {
		if (!(parentElement instanceof IfElement)) {
			return null;
		}
		IfElement element = (IfElement)parentElement;
		RootGameTree[] ret = new RootGameTree[element.getCollection().size()];
		for (int i = 0; i < ret.length; i++) {
			ret[i] = element.getCollection().get(i);
		}
		return ret;
	}


	/* (non-Javadoc)
	 * @see org.eclipse.jface.viewers.IStructuredContentProvider#getElements(java.lang.Object)
	 */
	public Object[] getElements(Object inputElement) {
		return ifElements_;
	}

	
	/* (non-Javadoc)
	 * @see org.eclipse.jface.viewers.ITreeContentProvider#getParent(java.lang.Object)
	 */
	public Object getParent(Object element) {
		// TODO Auto-generated method stub
		return null;
	}

	/* (non-Javadoc)
	 * @see org.eclipse.jface.viewers.ITreeContentProvider#hasChildren(java.lang.Object)
	 */
	public boolean hasChildren(Object element) {
		return (element instanceof IfElement);
	}


	/* (non-Javadoc)
	 * @see org.eclipse.jface.viewers.IContentProvider#dispose()
	 */
	public void dispose() {
		// Ɍn͕sv
	}

	/* (non-Javadoc)
	 * @see org.eclipse.jface.viewers.IContentProvider#inputChanged(org.eclipse.jface.viewers.Viewer, java.lang.Object, java.lang.Object)
	 */
	public void inputChanged(Viewer viewer, Object oldInput, Object newInput) {
		if (newInput == null) {
			ifElements_ = new IfElement[0];
		} else if (newInput instanceof IfElement[]) {
			IfElement[] newElement = (IfElement[])newInput;
			ifElements_ = new IfElement[newElement.length];
			System.arraycopy(newElement, 0, ifElements_, 0, ifElements_.length);
		} else {
			throw new IllegalArgumentException("newInput must be an instance of IfElement[]. Now is " + newInput.getClass()); //$NON-NLS-1$
		}
	}
}