/*  
 * Copyright 2005 unitarou <boss@unitarou.org>. 
 * All rights reserved.
 * 
 * This program and the accompanying materials are made available under the terms of 
 * the Common Public License v1.0 which accompanies this distribution, 
 * and is available at http://opensource.org/licenses/cpl.php
 * 
 * Contributors:
 *     unitarou - initial API and implementation
 */
package org.unitarou.yukinoshita.view.jface.dr;

import java.io.File;

import org.unitarou.sgf.Collection;
import org.unitarou.sgf.io.CollectionRepository;
import org.unitarou.util.ArgumentChecker;

/**
 * Provider󂯓nŏʂ̃GgłB
 */
class IfElement {
	/** IFvpeB̒lłB */
	private String inputFileName_;

	/** 
	 * {@link DrillEditorPanel#file_}{@link #inputFileName_}쐬
	 * t@Cւ̃nhłB
	 */
	private File inputFile_;
	
	/** ̂̃RNVłB*/
	private Collection collection_;

	/**
	 * @param parent
	 * @param filename
	 */
	IfElement(String parent, String filename) {
		ArgumentChecker.throwIfNull(parent, filename);
		inputFileName_ = filename;
		inputFile_ = new File(parent, filename);
	}


	/**
	 * @return ̂̃RNV
	 */
	Collection getCollection() {
		if (collection_ == null) {
			collection_ = CollectionRepository.instance().load(getInputFile());		
		}
		return collection_;
	}
	

	/**
	 * @return Returns the inputFile.
	 */
	File getInputFile() {
		return inputFile_;
	}

	/**
	 * @return Returns the inputFileName.
	 */
	String getInputFileName() {
		return inputFileName_;
	}

	/**
	 * @param collection The collection to set.
	 */
	void setCollection(Collection collection) {
		collection_ = collection;
	}

	/**
	 * @param inputFile The inputFile to set.
	 */
	void setInputFile(File inputFile) {
		inputFile_ = inputFile;
	}

	/**
	 * @param inputFileName The inputFileName to set.
	 */
	void setInputFileName(String inputFileName) {
		inputFileName_ = inputFileName;
	}
	
	
}