/*  
 * Copyright 2005 unitarou <boss@unitarou.org>. 
 * All rights reserved.
 * 
 * This program and the accompanying materials are made available under the terms of 
 * the Common Public License v1.0 which accompanies this distribution, 
 * and is available at http://opensource.org/licenses/cpl.php
 * 
 * Contributors:
 *     unitarou - initial API and implementation
 */
package org.unitarou.yukinoshita.view.jface.dr;

import java.io.File;

import org.eclipse.jface.viewers.IColorProvider;
import org.eclipse.jface.viewers.LabelProvider;
import org.eclipse.swt.SWT;
import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.widgets.Display;

import org.unitarou.ml.MessageResource;
import org.unitarou.sgf.RootGameTree;
import org.unitarou.sgf.type.GameType;
import org.unitarou.yukinoshita.view.provider.rgtlp.RootGameTreeLabelProvider;

class IfLabelProvider extends LabelProvider implements IColorProvider {
	
	/**uNot foundv*/
	static private final MessageResource LB_NOTFOUND
			= new MessageResource(IfLabelProvider.class, "lbNotfound"); //$NON-NLS-1$

	/**uCannot readv*/
	static private final MessageResource LB_CANNTO_READ
			= new MessageResource(IfLabelProvider.class, "lbCannotRead"); //$NON-NLS-1$
 
	
	/**
	 * vfɊԈႢ(t@CElł͂Ȃ)鎞ɗpt[łB
	 * ̂́u{0}: {1}v{0}ɌA{1}Ɏ̂w肵܂B
	 */
	static private final MessageResource LB_ERROR_FRAME 
			= new MessageResource(IfLabelProvider.class, "lbErrorFrame"); //$NON-NLS-1$

	/* (non-Javadoc)
	 * @see org.eclipse.jface.viewers.LabelProvider#getImage(java.lang.Object)
	 */
	@Override
	public Image getImage(Object element) {
		return super.getImage(element);
	}

	/* (non-Javadoc)
	 * @see org.eclipse.jface.viewers.LabelProvider#getText(java.lang.Object)
	 */
	@Override
	public String getText(Object element) {
		// \ґɂ
		if (element instanceof IfElement) {
			IfElement topElement = (IfElement)element;
			File file = topElement.getInputFile();
			StringBuilder stringBuilder = new StringBuilder();
			if (!file.exists() || !file.isFile()) {
				stringBuilder.append(LB_ERROR_FRAME.get(LB_NOTFOUND.get(), topElement.getInputFileName()));
			
			} else if (!file.canRead()) {
				stringBuilder.append(LB_ERROR_FRAME.get(LB_CANNTO_READ.get(), topElement.getInputFileName()));

			} else {
				stringBuilder.append(topElement.getInputFileName());
			}
			return stringBuilder.toString();

		} else if (element instanceof RootGameTree) {
			RootGameTree rgt = (RootGameTree)element;
			if (rgt.getGameType().equals(GameType.PROBLEM)) {
				return RootGameTreeLabelProvider.CONTEXT.defaultProvider().getLabel((RootGameTree)element);
			}
			return LB_ERROR_FRAME.get(
						rgt.getGameType().displayName(), 
						RootGameTreeLabelProvider.CONTEXT.defaultProvider().getLabel((RootGameTree)element));
		}
		
		return super.getText(element);
	}

	/* (non-Javadoc)
	 * @see org.eclipse.jface.viewers.IColorProvider#getForeground(java.lang.Object)
	 */
	public Color getForeground(Object element) {
		if (element instanceof IfElement) {
			IfElement topElement = (IfElement)element;
			File file = topElement.getInputFile();
			return (file.exists() && file.isFile()) 
				? Display.getCurrent().getSystemColor(SWT.COLOR_DARK_GRAY)
	 			: Display.getCurrent().getSystemColor(SWT.COLOR_RED);
				
		} else if (element instanceof RootGameTree) {
			RootGameTree rgt = (RootGameTree)element;
			if (rgt.getGameType().equals(GameType.PROBLEM)) {
				return Display.getCurrent().getSystemColor(SWT.COLOR_BLACK);
			}
			return Display.getCurrent().getSystemColor(SWT.COLOR_RED);
		}
		return null;
	}

	/* (non-Javadoc)
	 * @see org.eclipse.jface.viewers.IColorProvider#getBackground(java.lang.Object)
	 */
	public Color getBackground(Object element) {
		return null;
	}

}