/*  
 * Copyright 2005 unitarou <boss@unitarou.org>. 
 * All rights reserved.
 * 
 * This program and the accompanying materials are made available under the terms of 
 * the Common Public License v1.0 which accompanies this distribution, 
 * and is available at http://opensource.org/licenses/cpl.php
 * 
 * Contributors:
 *     unitarou - initial API and implementation
 */
package org.unitarou.yukinoshita.view.jface.dr;

import org.eclipse.swt.events.MouseAdapter;
import org.eclipse.swt.events.MouseEvent;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;

import org.unitarou.util.Adaptable;
import org.unitarou.util.ArgumentChecker;
import org.unitarou.yukinoshita.events.EventBroker;
import org.unitarou.yukinoshita.events.ModelEventNotifier;
import org.unitarou.yukinoshita.view.cmd.FocusInDrillEditorCommand;
import org.unitarou.yukinoshita.view.jface.board.IgoOutlinePanel;

/**
 * {@link org.unitarou.yukinoshita.view.jface.dr.DrillViewerPanel}ɔzu
 * e\plłB
 * @author unitarou &lt;boss@unitarou.org&gt; 
 */
public class ProblemOutlinePanel extends IgoOutlinePanel implements Adaptable {
	/**
	 * ̃NX̃A_v^[łB
	 */
	private final Adapter adapter_;

	private EventBroker eventBroker_;

	/**
	 * 
	 */
	public ProblemOutlinePanel() {
		this(Alignment.BOTTOM);
	}

	/**
	 * @param alignment
	 */
	public ProblemOutlinePanel(Alignment alignment) {
		super(alignment);
		adapter_ = new Adapter();
		eventBroker_ = EventBroker.NULL_BROKER;
	}
	
	/* (non-Javadoc)
	 * @see org.unitarou.lang.Adaptable#getAdapter(java.lang.Class)
	 */
	public Object getAdapter(Class<?> adapter) {
		if (adapter == null) {
			return null;
		}
		if (adapter.isAssignableFrom(adapter_.getClass())) {
			return adapter_;
		}
		return null;
	}
	
	/* (non-Javadoc)
	 * @see org.unitarou.yukinoshita.view.jface.board.IgoOutlinePanel#createContents(org.eclipse.swt.widgets.Composite)
	 */
	@Override
	public Control createContents(Composite parent) {
		Control control = super.createContents(parent);
		
		// }EXNbNtH[JXڂƂʒmB
		getBoardControl().addMouseListener(new MouseAdapter() {
			/* (non-Javadoc)
			 * @see org.eclipse.swt.events.MouseAdapter#mouseUp(org.eclipse.swt.events.MouseEvent)
			 */
			@Override
			public void mouseUp(MouseEvent e) {
				eventBroker_.executeCommand(new FocusInDrillEditorCommand(getRootGameTree()));
			}
		});
		return control;
	}

	

	/**
	 * ̃pl̃Cxgnh\ł
	 */
	private class Adapter implements ModelEventNotifier {

		/* (non-Javadoc)
		 * @see org.unitarou.yukinoshita.events.ModelEventNotifier#setEventBroker(org.unitarou.yukinoshita.events.EventBroker)
		 */
		public void setEventBroker(EventBroker eventBroker) {
			ArgumentChecker.throwIfNull(eventBroker);
			
			eventBroker_.removeView(ProblemOutlinePanel.this);
			eventBroker_ = eventBroker;
			eventBroker_.addView(ProblemOutlinePanel.this);
		}
	}

}
