/*  
 * Copyright 2005 unitarou <boss@unitarou.org>. 
 * All rights reserved.
 * 
 * This program and the accompanying materials are made available under the terms of 
 * the Common Public License v1.0 which accompanies this distribution, 
 * and is available at http://opensource.org/licenses/cpl.php
 * 
 * Contributors:
 *     unitarou - initial API and implementation
 */
package org.unitarou.yukinoshita.view.jface.gi;

import java.util.Iterator;
import java.util.Map;
import java.util.TreeMap;

import org.eclipse.swt.SWT;
import org.eclipse.swt.custom.StackLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;

import org.unitarou.sgf.type.GameType;
import org.unitarou.swt.WidgetContainer;
import org.unitarou.util.Adaptable;
import org.unitarou.util.ArgumentChecker;
import org.unitarou.yukinoshita.events.EventBroker;
import org.unitarou.yukinoshita.events.ModelEventNotifier;
import org.unitarou.yukinoshita.model.CollectionEditor;
import org.unitarou.yukinoshita.model.GameMediator;
import org.unitarou.yukinoshita.view.monitor.CollectionMonitor;
import org.unitarou.yukinoshita.view.monitor.GameMonitor;

/**
 * {@link org.unitarou.yukinoshita.view.jface.gi.GameInfoPlainPanel}
 * KwɕێplłBGTX^CŐ؂ւ邱Ƃz肵Ă܂B
 * FIXME ݂Default̃tH[}bĝ݂ɑΉĂB
 * 
 * @author unitarou &lt;boss@unitarou.org&gt;
 */
public class GameInfoPanel implements Adaptable, WidgetContainer {
    
    static public final String ID_DEFAULT = "Default"; //$NON-NLS-1$
    
    private Composite frame_;
    
    /** ݍŏʂɂplłB*/
	private GameInfoPlainPanel currentPanel_;
	
	/** pl̕\ւ邽߂ɕێĂ܂B */
	private final StackLayout stackLayout_;
	
	private final Adapter adapter_;
	

	/** 
     * ^[String:{@link GameInfoPlainPanel#getId()}, 
     *      Map[{@link GameType}:{@link GameInfoPlainPanel#getGameType()}, 
     *          {@link GameInfoPlainPanel}]]
     * łB
     */
    private final Map<String, Map<GameType, GameInfoPlainPanel>> panelsMap_;

    /**
     * 
     */
    public GameInfoPanel() {
        super();
        frame_ = null;
        currentPanel_ = null;
		stackLayout_ = new StackLayout();
        panelsMap_ = new TreeMap<String, Map<GameType, GameInfoPlainPanel>>();
        adapter_ = new Adapter();
    }
    /* (non-Javadoc)
     * @see org.unitarou.lang.Adaptable#getAdapter(java.lang.Class)
     */
    public Object getAdapter(Class<?> adapter) {
        if (adapter == null) {
            return null;
        }
        if (adapter.isAssignableFrom(adapter_.getClass())) {
            return adapter_;
        }
        return null;
    }

    /* (non-Javadoc)
     * @see org.unitarou.swt.WidgetContainer#createControl(org.eclipse.swt.widgets.Composite)
     */
    public Control createContents(Composite parent) {
		frame_ = new Composite(parent, SWT.NONE);
		frame_.setLayout(stackLayout_);
		for (Iterator ip = ((Map)panelsMap_.get(ID_DEFAULT)).values().iterator(); ip.hasNext(); ){
		    GameInfoPlainPanel gameInfoPanel = (GameInfoPlainPanel)ip.next();
		    gameInfoPanel.createContents(frame_);
		}
		currentPanel_ = (GameInfoPlainPanel)((Map)panelsMap_.get(ID_DEFAULT)).get(GameType.GAME);
		stackLayout_.topControl = currentPanel_.getControl();
        return frame_;
    }

	/**
	 * @return
	 */
	public Control getControl() {
		return frame_;
	}

	/* (non-Javadoc)
     * @see org.unitarou.swt.WidgetContainer#dispose()
     */
    public void dispose() {
        // ł͏I͕sv
    }


    /**
     * 
     * @param gameInfoPanel
     * @return VKɊi[łꍇtrueAɃIuWFNgi[ĂꍇfalseB
     * @throws org.unitarou.lang.NullArgumentException null̏ꍇB
     */
    public boolean add(GameInfoPlainPanel gameInfoPanel) {
        ArgumentChecker.throwIfNull(gameInfoPanel);
        
        Map<GameType, GameInfoPlainPanel> map = panelsMap_.get(gameInfoPanel.getId());
        if (map == null) {
            map = new TreeMap<GameType, GameInfoPlainPanel>();
            panelsMap_.put(gameInfoPanel.getId(), map);
        }
        return map.put(gameInfoPanel.getGameType(), gameInfoPanel) == null;
    }
    
    /**
     * w肵gameTypeGameInfoPanel݂Ȃꍇ́A
     * {@link GameType#GAME}GameInfoPanelԂ܂B
     * ꂷ瑶݂ȂꍇnullԂ܂B
     * @param id
     * @param gameType
     * @return
     * @throws org.unitarou.lang.NullArgumentException null̏ꍇB
     */
    private GameInfoPlainPanel get(String id, GameType gameType) {
        ArgumentChecker.throwIfNull(id, gameType);
        
        Map<GameType, GameInfoPlainPanel> map = panelsMap_.get(id);
        if (map != null) {
            GameInfoPlainPanel ret = map.get(gameType);
            if (ret == null) {
                ret = map.get(GameType.GAME);
            }
            return ret;
        }
        return null;
    }

    /**
     * @param game
     * @return
     */
    private GameInfoPlainPanel getDefault(GameType gameType) {
        return get(ID_DEFAULT, gameType);
    }

    
    private class Adapter 
    		implements ModelEventNotifier, CollectionMonitor, GameMonitor
    {

    	private EventBroker eventBroker_ = EventBroker.NULL_BROKER;
    	
        /* (non-Javadoc)
         * @see org.unitarou.yukinoshita.events.ModelEventNotifier#setEventBroker(org.unitarou.yukinoshita.events.EventBroker)
         */
        public void setEventBroker(EventBroker eventBroker) {
            ArgumentChecker.throwIfNull(eventBroker);
            eventBroker_.removeView(GameInfoPanel.this);
            eventBroker_ = eventBroker;
            eventBroker_.addView(GameInfoPanel.this);
    		for (Iterator ip = ((Map)panelsMap_.get(ID_DEFAULT)).values().iterator(); ip.hasNext(); ){
    		    GameInfoPlainPanel gameInfoPanel = (GameInfoPlainPanel)ip.next();
    		    gameInfoPanel.setEventBroker(eventBroker);
    		}
        }

        /* (non-Javadoc)
         * @see org.unitarou.yukinoshita.view.CollectionMonitor#update(org.unitarou.yukinoshita.model.CollectionEditor)
         */
        public void update(CollectionEditor collectionEditor) {
            ArgumentChecker.throwIfNull(collectionEditor);
            update(collectionEditor.getActiveGame());
        }

		/* (non-Javadoc)
		 * @see org.unitarou.yukinoshita.view.GameMonitor#update(org.unitarou.yukinoshita.model.GameMediator)
		 */
		public void update(GameMediator gameMediator) {
			ArgumentChecker.throwIfNull(gameMediator);
            currentPanel_ = getDefault(gameMediator.getGameType());
    		stackLayout_.topControl = currentPanel_.getControl();
    		currentPanel_.getControl().getParent().layout();
		}
    }
}
