/*  
 * Copyright 2005 unitarou <boss@unitarou.org>. 
 * All rights reserved.
 * 
 * This program and the accompanying materials are made available under the terms of 
 * the Common Public License v1.0 which accompanies this distribution, 
 * and is available at http://opensource.org/licenses/cpl.php
 * 
 * Contributors:
 *     unitarou - initial API and implementation
 */
package org.unitarou.yukinoshita.view.jface.gi;

import java.io.IOException;
import java.net.URL;
import java.util.Iterator;
import java.util.List;
import java.util.Properties;

import org.apache.commons.digester.Digester;
import org.apache.commons.digester.xmlrules.DigesterLoader;
import org.xml.sax.SAXException;

import org.unitarou.ml.Messages;
import org.unitarou.util.ArgumentChecker;

/**
 * @author unitarou &lt;boss@unitarou.org&gt;
 */
public class GameInfoPanelFactory {
    static private final Messages messages_s_ = Messages.createByPackage(GameInfoPanelFactory.class);
    static private final GameInfoPanelFactory instance_s_ = new GameInfoPanelFactory();
    
    /** 
     * t@Ng[̗B̃CX^XԂ܂B
     * @return
     */
    static public GameInfoPanelFactory instance() {
        return instance_s_;
    }
    
    
    /**
     * 
     */
    private GameInfoPanelFactory() {
        super();
    }
    
    /**
     * ftHg{@link GameInfoPlainPanel}쐬ĕԂ܂B
     * TODO {@link #create(URL, Properties)}O𑗏o悤ɂȂA
     *      bvRuntimen̗O𓊂(ݒ゠肦Ȃ̂) 
     */
    public GameInfoPanel createDefault() {
        return create(GameInfoPlainPanel.class.getResource("Rule.xml"), //$NON-NLS-1$
                		messages_s_.getAll());
    }
    
    public GameInfoPanel create(URL xmlUrl, Properties properties) {
        ArgumentChecker.throwIfNull(xmlUrl, properties);
		try {
		    Digester digester = digester = DigesterLoader.createDigester(xmlUrl);
		    List list = (List)digester.parse(
		            GameInfoPlainPanel.class.getResourceAsStream("DefaultFormat.xml")); //$NON-NLS-1$
		    
		    GameInfoPanel ret = new GameInfoPanel();
		    for (Iterator ip = list.iterator(); ip.hasNext(); ) {
		        GameInfoPlainPanel panel = (GameInfoPlainPanel)ip.next();
		        panel.setLabel(properties);
		        ret.add(panel);
		    }
		    return ret;

		 // TODO OɌĴŁAOđoB
		} catch (IOException e) {
		    throw new RuntimeException(e);

		} catch (SAXException e) {
		    throw new RuntimeException(e);
		}
    }
}
