/*
 * Copyright 2003-2005 unitarou <boss@unitarou.org>. 
 * All rights reserved.
 * 
 * This program and the accompanying materials are made available under the terms of 
 * the Common Public License v1.0 which accompanies this distribution, 
 * and is available at http://opensource.org/licenses/cpl.php
 * 
 * Contributors:
 *     unitarou - initial API and implementation
 */
package org.unitarou.yukinoshita.view.jface.gi;

import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.Properties;

import org.eclipse.jface.util.Geometry;
import org.eclipse.swt.SWT;
import org.eclipse.swt.custom.ScrolledComposite;
import org.eclipse.swt.events.ControlAdapter;
import org.eclipse.swt.events.ControlEvent;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;

import org.unitarou.lang.Strings;
import org.unitarou.sgf.PropertyType;
import org.unitarou.sgf.type.GameType;
import org.unitarou.sgf.type.TypeParseException;
import org.unitarou.swt.WidgetContainer;
import org.unitarou.util.Adaptable;
import org.unitarou.util.ArgumentChecker;
import org.unitarou.yukinoshita.events.EventBroker;
import org.unitarou.yukinoshita.events.ModelEventNotifier;
import org.unitarou.yukinoshita.model.GameMediator;
import org.unitarou.yukinoshita.model.NodeList;
import org.unitarou.yukinoshita.model.NodeView;
import org.unitarou.yukinoshita.view.monitor.GameInfoNodeMonitor;
import org.unitarou.yukinoshita.view.monitor.GameMonitor;

/**
 * lGameInfovpeB\plłB
 * 
 * @author UNITAROU &lt;boss@unitarou.org&gt;
 */
public class GameInfoPlainPanel 
		implements Adaptable, WidgetContainer, ModelEventNotifier {
	
    /** XMLtH[}bgǂݍ܂ۂ̃tH[}bĝ̂IDłB */
    private String id_;
    
    /**
     * ̃pl\{@link GameType}łB
     * w̏ꍇ{@link GameType#GAME}Ƃ݂Ȃ܂B
     */
    private GameType gameType_;
    
    /**
     * {@link #composite_}̐ełB 
     */
    private ScrolledComposite scrolledComposite_;
    
    /**
     * ۂɃxi[łB
     * {@link #createContents(Composite)}łScrolledComposite
     * ܂͂߂ɍ쐬Ă̂ŁA
     * {@link #dispose()}͐eScrolledCompositedisposeKv܂B
     */
    private Composite composite_;
    
    /** ^{@link GiLine} */
    private final List<GiLine> giLines_; 
    
    private final Adapter adapter_;
    
    private EventBroker eventBroker_;

    /**
	 * 
	 */
	public GameInfoPlainPanel() {
		super();
		id_ = Strings.EMPTY;
		gameType_ = GameType.GAME;
		scrolledComposite_ = null;
		composite_ = null;
		giLines_ = new ArrayList<GiLine>();
		adapter_ = new Adapter();
		eventBroker_ = EventBroker.NULL_BROKER;
	}
	
    /* (non-Javadoc)
     * @see org.unitarou.lang.Adaptable#getAdapter(java.lang.Class)
     */
    public Object getAdapter(Class<?> adapter) {
        if (adapter == null) {
            return null;
        }
        if (adapter.isAssignableFrom(adapter_.getClass())) {
            return adapter_;
        }
        return null;
    }


    /* (non-Javadoc)
     * @see org.unitarou.yukinoshita.view.swt.ControlCreatable#createControl(org.eclipse.swt.widgets.Composite)
     */
    public Control createContents(Composite parent) {
        ArgumentChecker.throwIfNull(parent);
        
        scrolledComposite_ = new ScrolledComposite(parent, SWT.V_SCROLL);
        composite_ = new Composite(scrolledComposite_, SWT.NONE);
        scrolledComposite_.setContent(composite_);

        GridLayout gridLayout = new GridLayout(1, true);
        gridLayout.horizontalSpacing = 0;
        gridLayout.verticalSpacing = 0;
        gridLayout.marginHeight = 0;
        gridLayout.marginWidth = 0;
        composite_.setLayout(gridLayout);
        for (Iterator ip = giLines_.iterator(); ip.hasNext(); ) {
            GiLine giLine = (GiLine)ip.next();
            Control control = giLine.createContents(composite_);
            GridData gridData = new GridData(GridData.BEGINNING, GridData.BEGINNING, false, false);
            control.setLayoutData(gridData);
        }
        composite_.pack();
		Point point = Geometry.getSize(scrolledComposite_.getClientArea());
		scrolledComposite_.setMinSize(point);
		scrolledComposite_.addControlListener(new ControlAdapter() {
			@Override
			public void controlResized(ControlEvent e) {
				resized();
			}
		});
        return scrolledComposite_;
    }

    
	/**
	 * eՂ̃TCYvZăTCYs܂B
	 */
	private void resized() {
        composite_.pack();
		Point point = Geometry.getSize(scrolledComposite_.getClientArea());
		scrolledComposite_.setMinSize(point);
        for (Iterator ip = giLines_.iterator(); ip.hasNext(); ) {
            GiLine giLine = (GiLine)ip.next();
            Control control = giLine.getControl();
            GridData gridData = new GridData(GridData.BEGINNING, GridData.BEGINNING, false, false);
            gridData.widthHint = point.x - 4 ;
            gridData.heightHint = SWT.DEFAULT;
            control.setLayoutData(gridData);
            giLine.setWidth(gridData.widthHint);
        }
        scrolledComposite_.layout(true, true);
	}

	/* (non-Javadoc)
     * @see org.unitarou.yukinoshita.view.swt.ControlCreatable#dispose()
     */
    public void dispose() {
        if (composite_ == null) {
            return;
        }
        scrolledComposite_.dispose();
        scrolledComposite_ = null;
        composite_ = null;
        giLines_.clear();
		id_ = Strings.EMPTY;
		gameType_ = GameType.GAME;
    }

    
    public Control getControl() {
        return composite_.getParent();
    }
    
    public String getId() {
        return id_;
    }
    
    public void setId(String id) {
        ArgumentChecker.throwIfNull(id);
        id_ = id;
    }
    
    public GameType getGameType() {
        return gameType_;
    }

    public void setGameTypeId(String type) {
        ArgumentChecker.throwIfNull(type);

        try {
            gameType_ = GameType.parse(type);

        } catch (TypeParseException e) {
            // TODO Auto-generated catch block
            e.printStackTrace();
        }
    }

    public void addLine(GiLine giLine) {
        ArgumentChecker.throwIfNull(giLine);
        giLines_.add(giLine);
    }


    /**
     * ̃xpropertiesōXV܂B
     * @param properties
     * @throws org.unitarou.lang.NullArgumentException null̏ꍇ
     */
    public void setLabel(Properties properties) {
        ArgumentChecker.throwIfNull(properties);
        for (Iterator ip = giLines_.iterator(); ip.hasNext(); ) {
            GiLine giLine = (GiLine)ip.next();
            giLine.setLabel(properties);
        }
    }


    /* (non-Javadoc)
     * @see org.unitarou.yukinoshita.events.ModelEventNotifier#setEventBroker(org.unitarou.yukinoshita.events.EventBroker)
     */
    public void setEventBroker(EventBroker eventBroker) {
        ArgumentChecker.throwIfNull(eventBroker);
        eventBroker_.removeView(this);
        eventBroker_ = eventBroker;
        eventBroker_.addView(this);
    }
    
    private class Adapter implements GameMonitor, GameInfoNodeMonitor {

		/* (non-Javadoc)
		 * @see org.unitarou.yukinoshita.view.monitor.GameMonitor#update(org.unitarou.yukinoshita.model.GameMediator)
		 */
		public void update(GameMediator gameMediator) {
            ArgumentChecker.throwIfNull(gameMediator);
            
        	NodeList nodeList = gameMediator.getNodeList();
            for(int index = gameMediator.getCurrentNodeIndex(); 0 <= index; --index) { 
            	NodeView nodeView = nodeList.getNodeView(index);
            	if (nodeView.containsPropertyType(PropertyType.GAME_INFO)) {
            		gameInfoChanged(nodeView);
            		return;
            	}
            }
            // GAME_INFOꍇ́A擪Noden
            // ܂ł̏ԂSăNA[B
            gameInfoChanged(nodeList.getNodeView(0));
		}
		
        /* (non-Javadoc)
         * @see org.unitarou.yukinoshita.view.NodeMonitor#update(org.unitarou.yukinoshita.model.NodeView)
         */
        public void gameInfoChanged(NodeView nodeView) {
            ArgumentChecker.throwIfNull(nodeView);
            for (Iterator ip = giLines_.iterator(); ip.hasNext(); ) {
                GiLine giLine = (GiLine)ip.next();
                giLine.currentChanged(nodeView);
            }
            resized();
        }
    }
}
